/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamReferenceContributorKt;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.spring.SpringApiBundle;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.expressions.UInjectionHost;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u00a8\u0006\t"}, d2={"Lcom/intellij/spring/model/jam/utils/SpringResourceLocationsUtil;", "", "()V", "checkResourceLocation", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "attributeElement", "Lcom/intellij/jam/JamStringAttributeElement;", "intellij.spring.core"})
public final class SpringResourceLocationsUtil {
    @NotNull
    public static final SpringResourceLocationsUtil INSTANCE;

    public final void checkResourceLocation(@NotNull ProblemsHolder holder, @NotNull JamStringAttributeElement<?> attributeElement) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter(attributeElement, (String)"attributeElement");
        PsiLiteral psiLiteral = attributeElement.getPsiLiteral();
        if (psiLiteral == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiLiteral, (String)"attributeElement.psiLiteral ?: return");
        PsiLiteral psiLiteral2 = psiLiteral;
        PsiReference[] psiReferenceArray = psiLiteral2.getReferences();
        int n = psiReferenceArray.length;
        for (int i = 0; i < n; ++i) {
            String string;
            PsiElement psiElement;
            ResolveResult[] resolveResultArray;
            PsiReference psiReference;
            PsiReference psiReference2 = psiReference = psiReferenceArray[i];
            Intrinsics.checkNotNullExpressionValue((Object)psiReference2, (String)"psiReference");
            PsiReference unwrapped = JamReferenceContributorKt.unwrapReference((PsiReference)psiReference2);
            if (unwrapped.isSoft() || !(unwrapped instanceof FileReference)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((FileReference)unwrapped).multiResolve(false), (String)"unwrapped.multiResolve(false)");
            boolean bl = false;
            if (!(resolveResultArray.length == 0)) continue;
            UInjectionHost uInjectionHost = (UInjectionHost)UastContextKt.toUElement((PsiElement)((PsiElement)psiLiteral2), UInjectionHost.class);
            Object object = psiElement = uInjectionHost != null ? uInjectionHost.getSourcePsi() : null;
            if (psiElement == null) continue;
            if (((FileReference)unwrapped).isLast()) {
                String string2 = SpringApiBundle.message("model.file.error.message", ((FileReference)unwrapped).getText());
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SpringApiBundle.message(\u2026message\", unwrapped.text)");
            } else {
                String string3 = SpringApiBundle.message("model.directory.error.message", ((FileReference)unwrapped).getText());
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"SpringApiBundle.message(\u2026message\", unwrapped.text)");
            }
            String message = string;
            LocalQuickFix[] localQuickFixArray = ((FileReference)unwrapped).getQuickFixes();
            holder.registerProblem(psiElement, unwrapped.getRangeInElement(), message, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
        }
    }

    private SpringResourceLocationsUtil() {
    }

    static {
        SpringResourceLocationsUtil springResourceLocationsUtil;
        INSTANCE = springResourceLocationsUtil = new SpringResourceLocationsUtil();
    }
}

