/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.semantic.SemService;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalAnnotationModelDependentModelsProvider;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.stereotype.SpringComponentScan;
import com.intellij.spring.model.jam.stereotype.SpringContextImport;
import com.intellij.spring.model.jam.stereotype.SpringImport;
import com.intellij.spring.model.jam.stereotype.SpringImportResource;
import com.intellij.spring.model.jam.stereotype.SpringJamComponentScan;
import com.intellij.spring.model.jam.stereotype.SpringJamComponentScans;
import com.intellij.spring.model.jam.stereotype.SpringJamPropertySource;
import com.intellij.spring.model.jam.stereotype.SpringPropertySource;
import com.intellij.spring.model.jam.stereotype.SpringPropertySources;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.jam.utils.filters.SpringContextFilter;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringJamUtilsImpl
extends SpringJamUtils {
    private static final Key<CachedValue<Set<CommonSpringBean>>> ANNOTATION_CONFIG_APPLICATION_CONTEXT_CACHE = Key.create((String)"ANNOTATION_CONFIG_APPLICATION_CONTEXT_CACHE");
    private static final List<String> ANNOTATIONS = ContainerUtil.immutableList((Object[])new String[]{"org.springframework.context.annotation.Import", "org.springframework.context.annotation.ImportResource"});

    @NotNull
    private static Map<SpringBean, Set<CommonSpringBean>> getAnnotationConfigAppContextedBeans(@NotNull CommonSpringModel model, @NotNull Module module) {
        if (model == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(0);
        }
        if (module == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(1);
        }
        LinkedHashMap<SpringBean, Set<CommonSpringBean>> ac = new LinkedHashMap<SpringBean, Set<CommonSpringBean>>();
        for (SpringBeanPointer<?> appConfig : SpringModelVisitorUtils.getAnnotationConfigApplicationContexts(model)) {
            Object commonSpringBean = appConfig.getSpringBean();
            if (!(commonSpringBean instanceof SpringBean)) continue;
            SpringBean springBean = (SpringBean)commonSpringBean;
            ac.put(springBean, SpringJamUtilsImpl.getAnnotationAppContextBeans(module, springBean));
        }
        LinkedHashMap<SpringBean, Set<CommonSpringBean>> linkedHashMap = ac;
        if (linkedHashMap == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(2);
        }
        return linkedHashMap;
    }

    private static Set<CommonSpringBean> getAnnotationAppContextBeans(Module module, SpringBean springBean) {
        return (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)springBean, ANNOTATION_CONFIG_APPLICATION_CONTEXT_CACHE, () -> {
            LinkedHashSet<CommonSpringBean> set = new LinkedHashSet<CommonSpringBean>();
            Set<ConstructorArg> allConstructorArgs = springBean.getAllConstructorArgs();
            if (allConstructorArgs.size() == 1) {
                set.addAll(SpringJamUtilsImpl.getAnnotatedStereotypes(allConstructorArgs.iterator().next(), module));
            }
            return CachedValueProvider.Result.create(set, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }, false);
    }

    @NotNull
    private static Set<CommonSpringBean> getAnnotatedStereotypes(@NotNull ConstructorArg arg, @NotNull Module module) {
        Set<String> names;
        if (arg == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(3);
        }
        if (module == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(4);
        }
        if ((names = SpringJamUtilsImpl.collectNames(arg)).isEmpty()) {
            Set<CommonSpringBean> set = Collections.emptySet();
            if (set == null) {
                SpringJamUtilsImpl.$$$reportNull$$$0(5);
            }
            return set;
        }
        LinkedHashSet<CommonSpringBean> stereotypeElements = new LinkedHashSet<CommonSpringBean>();
        for (CommonSpringBean commonSpringBean : SpringJamModel.getModel(module).getStereotypeComponents()) {
            PsiElement aClass = commonSpringBean.getIdentifyingPsiElement();
            if (!(aClass instanceof PsiClass) || !SpringJamUtilsImpl.isStereotypeAccepted((PsiClass)aClass, names)) continue;
            stereotypeElements.add(commonSpringBean);
        }
        LinkedHashSet<CommonSpringBean> linkedHashSet = stereotypeElements;
        if (linkedHashSet == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    private static boolean isStereotypeAccepted(@NotNull PsiClass aClass, @NotNull Set<String> names) {
        String fqn;
        if (aClass == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(7);
        }
        if (names == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(8);
        }
        if ((fqn = aClass.getQualifiedName()) == null) {
            return false;
        }
        for (String classOrPackageName : names) {
            if (!fqn.startsWith(classOrPackageName) && !InheritanceUtil.isInheritor((PsiClass)aClass, (String)classOrPackageName)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Set<CommonModelElement> findStereotypeConfigurationBeans(@NotNull CommonSpringModel model, @NotNull List<? extends SpringBeanPointer<?>> beansInModel, @Nullable Module module) {
        Collection<CommonSpringBean> stereotypeElements;
        if (model == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(9);
        }
        if (beansInModel == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(10);
        }
        if (module == null) {
            Set<CommonModelElement> set = Collections.emptySet();
            if (set == null) {
                SpringJamUtilsImpl.$$$reportNull$$$0(11);
            }
            return set;
        }
        LinkedHashSet<CommonModelElement> result = new LinkedHashSet<CommonModelElement>();
        for (Map.Entry<SpringBeansPackagesScan, List<CommonSpringBean>> entry : SpringJamUtilsImpl.getComponentScannedBeans(model, module).entrySet()) {
            for (SpringBeanPointer<?> stereotypeMappedBean : beansInModel) {
                stereotypeElements = entry.getValue();
                if (!stereotypeElements.contains(stereotypeMappedBean.getSpringBean())) continue;
                result.add(entry.getKey());
            }
        }
        for (Map.Entry<CommonModelElement, Collection<CommonSpringBean>> entry : SpringJamUtilsImpl.getAnnotationConfigAppContextedBeans(model, module).entrySet()) {
            for (SpringBeanPointer<?> stereotypeMappedBean : beansInModel) {
                stereotypeElements = (Set)entry.getValue();
                if (!stereotypeElements.contains(stereotypeMappedBean.getSpringBean())) continue;
                result.add(entry.getKey());
            }
        }
        LinkedHashSet<CommonModelElement> linkedHashSet = result;
        if (linkedHashSet == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(12);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<String> collectNames(@NotNull ConstructorArg arg) {
        if (arg == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(13);
        }
        LinkedHashSet<String> strings = new LinkedHashSet<String>();
        if (DomUtil.hasXml((DomElement)arg.getValueAttr())) {
            SpringJamUtilsImpl.addIfNotNull(strings, arg.getValueAttr().getStringValue());
        }
        if (DomUtil.hasXml((DomElement)arg.getValue())) {
            SpringJamUtilsImpl.addIfNotNull(strings, arg.getValue().getStringValue());
        }
        for (String s : SpringPropertyUtils.getListOrSetValues(arg)) {
            SpringJamUtilsImpl.addIfNotNull(strings, s);
        }
        LinkedHashSet<String> linkedHashSet = strings;
        if (linkedHashSet == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(14);
        }
        return linkedHashSet;
    }

    private static void addIfNotNull(@NotNull Set<? super String> strings, String s) {
        if (strings == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(15);
        }
        if (!StringUtil.isEmptyOrSpaces((String)s)) {
            strings.add(s);
        }
    }

    private static Map<SpringBeansPackagesScan, List<CommonSpringBean>> getComponentScannedBeans(@NotNull CommonSpringModel model, @NotNull Module module) {
        if (model == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(16);
        }
        if (module == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(17);
        }
        LinkedHashMap<SpringBeansPackagesScan, List<CommonSpringBean>> cs = new LinkedHashMap<SpringBeansPackagesScan, List<CommonSpringBean>>();
        for (SpringBeansPackagesScan packagesScan : SpringModelVisitorUtils.getComponentScans(model)) {
            cs.put(packagesScan, SpringProfileUtils.filterBeansInActiveProfiles(packagesScan.getScannedElements(module), model.getActiveProfiles()));
        }
        return cs;
    }

    @Override
    @NotNull
    public Set<CommonSpringBean> filterComponentScannedStereotypes(@NotNull Module module, @NotNull SpringBeansPackagesScan componentScan, @NotNull List<? extends CommonSpringBean> allComponents) {
        Set<PsiPackage> psiPackages;
        if (module == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(18);
        }
        if (componentScan == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(19);
        }
        if (allComponents == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(20);
        }
        if ((psiPackages = componentScan.getPsiPackages()).isEmpty()) {
            Set<CommonSpringBean> set = Collections.emptySet();
            if (set == null) {
                SpringJamUtilsImpl.$$$reportNull$$$0(21);
            }
            return set;
        }
        Set<CommonSpringBean> set = this.filterComponentScannedStereotypes(module, allComponents, psiPackages, componentScan.useDefaultFilters(), componentScan.getExcludeContextFilters(), componentScan.getIncludeContextFilters());
        if (set == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(22);
        }
        return set;
    }

    @Override
    public Set<CommonSpringBean> filterComponentScannedStereotypes(@NotNull Module module, @NotNull List<? extends CommonSpringBean> allComponents, @NotNull Set<PsiPackage> psiPackages, boolean useDefaultFilters, @NotNull Set<SpringContextFilter.Exclude> excludeContextFilters, @NotNull Set<SpringContextFilter.Include> includeContextFilters) {
        if (module == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(23);
        }
        if (allComponents == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(24);
        }
        if (psiPackages == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(25);
        }
        if (excludeContextFilters == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(26);
        }
        if (includeContextFilters == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(27);
        }
        ArrayList<SpringStereotypeElement> includeFiltered = new ArrayList<SpringStereotypeElement>();
        for (SpringContextFilter.Include includeFilter : includeContextFilters) {
            includeFiltered.addAll(includeFilter.includeStereotypes(module, psiPackages));
        }
        LinkedHashSet<CommonSpringBean> resultElements = new LinkedHashSet<CommonSpringBean>();
        if (useDefaultFilters) {
            resultElements.addAll(SpringJamUtilsImpl.filterStereotypeComponents(allComponents, excludeContextFilters, psiPackages));
        }
        resultElements.addAll(SpringJamUtilsImpl.filterStereotypeComponents(includeFiltered, excludeContextFilters, psiPackages));
        return resultElements;
    }

    @Override
    @NotNull
    public List<ContextJavaBean> getContextBeans(@NotNull PsiClass beanClass, @Nullable Set<String> activeProfiles) {
        if (beanClass == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(28);
        }
        List<ContextJavaBean> contextJavaBeans = SpringJamUtilsImpl.doGetContextBeans(beanClass);
        List<ContextJavaBean> list = SpringProfileUtils.filterBeansInActiveProfiles(contextJavaBeans, activeProfiles);
        if (list == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(29);
        }
        return list;
    }

    private static List<ContextJavaBean> doGetContextBeans(PsiClass beanClass) {
        return JamService.getJamService((Project)beanClass.getProject()).getAnnotatedMembersList(beanClass, ContextJavaBean.BEAN_JAM_KEY, 10);
    }

    @Override
    @Nullable
    public SpringStereotypeElement findStereotypeElement(@NotNull PsiClass psiClass) {
        JamPsiMemberSpringBean bean;
        if (psiClass == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(30);
        }
        return (bean = (JamPsiMemberSpringBean)JamService.getJamService((Project)psiClass.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)psiClass)) instanceof SpringStereotypeElement ? (SpringStereotypeElement)bean : null;
    }

    static boolean isInPackage(@NotNull Set<? extends PsiPackage> psiPackages, PsiClass psiClass) {
        String qualifiedName;
        if (psiPackages == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(31);
        }
        if ((qualifiedName = psiClass.getQualifiedName()) != null) {
            for (PsiPackage psiPackage : psiPackages) {
                if (psiPackage.getQualifiedName().isEmpty() && !qualifiedName.contains(".")) {
                    return true;
                }
                if (!StringUtil.startsWithConcatenation((String)qualifiedName, (String[])new String[]{psiPackage.getQualifiedName(), "."})) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public Set<XmlFile> getImportedResources(@NotNull PsiClass psiClass, Module ... contexts) {
        SpringImportResource importResource;
        if (psiClass == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(32);
        }
        if ((importResource = (SpringImportResource)SpringImportResource.META.getJamElement((PsiModifierListOwner)psiClass)) == null) {
            Set<XmlFile> set = Collections.emptySet();
            if (set == null) {
                SpringJamUtilsImpl.$$$reportNull$$$0(33);
            }
            return set;
        }
        return new LinkedHashSet<XmlFile>(importResource.getImportedResources(contexts));
    }

    @Override
    public boolean processImportedResources(@NotNull PsiClass psiClass, @NotNull Processor<Pair<List<XmlFile>, ? extends PsiElement>> processor2, Module ... contexts) {
        SpringImportResource importResource;
        if (psiClass == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(34);
        }
        if (processor2 == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(35);
        }
        if ((importResource = (SpringImportResource)SpringImportResource.META.getJamElement((PsiModifierListOwner)psiClass)) == null) {
            return true;
        }
        return importResource.processImportedResources(processor2, contexts);
    }

    @Override
    @NotNull
    public Set<PsiClass> getImportedClasses(@NotNull PsiClass clazz, @Nullable Module module) {
        SpringImport springImport;
        if (clazz == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(36);
        }
        if ((springImport = (SpringImport)SemService.getSemService((Project)clazz.getProject()).getSemElement(SpringImport.IMPORT_JAM_KEY, (PsiElement)clazz)) == null) {
            Set<PsiClass> set = Collections.emptySet();
            if (set == null) {
                SpringJamUtilsImpl.$$$reportNull$$$0(37);
            }
            return set;
        }
        return new LinkedHashSet<PsiClass>(springImport.getImportedClasses());
    }

    @Override
    public boolean processImportedClasses(@NotNull PsiClass clazz, @NotNull Processor<Pair<PsiClass, ? extends PsiElement>> processor2) {
        SpringContextImport springImport;
        if (clazz == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(38);
        }
        if (processor2 == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(39);
        }
        if ((springImport = (SpringContextImport)SpringContextImport.META.getJamElement((PsiModifierListOwner)clazz)) == null) {
            return true;
        }
        return springImport.processImportedClasses(processor2);
    }

    @Override
    @NotNull
    public List<? extends SpringBeansPackagesScan> getBeansPackagesScan(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(40);
        }
        SmartList scans = new SmartList();
        SemService service = SemService.getSemService((Project)psiClass.getProject());
        for (PsiAnnotation psiAnnotation : AnnotationUtil.findAnnotations((PsiModifierListOwner)psiClass, Collections.singleton("org.springframework.context.annotation.ComponentScan"))) {
            ContainerUtil.addAllNotNull((Collection)scans, (Iterable)service.getSemElements(SpringJamComponentScan.REPEATABLE_ANNO_JAM_KEY, (PsiElement)psiAnnotation));
        }
        List elements = service.getSemElements(SpringComponentScan.COMPONENT_SCAN_JAM_KEY, (PsiElement)psiClass);
        scans.addAll(ContainerUtil.filter((Collection)elements, scan -> !(scan instanceof SpringJamComponentScan)));
        SpringJamComponentScans springJamComponentScans = (SpringJamComponentScans)SpringJamComponentScans.META.getJamElement((PsiModifierListOwner)psiClass);
        if (springJamComponentScans != null) {
            scans.addAll(springJamComponentScans.getComponentScans());
        }
        SmartList smartList = scans;
        if (smartList == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(41);
        }
        return smartList;
    }

    @Override
    @NotNull
    public Collection<SpringPropertySource> getPropertySources(@NotNull PsiClass psiClass) {
        SpringPropertySources propertySources;
        if (psiClass == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(42);
        }
        SmartList sources = new SmartList();
        Object[] annotations = AnnotationUtil.findAnnotations((PsiModifierListOwner)psiClass, Collections.singleton("org.springframework.context.annotation.PropertySource"));
        SemService semService = SemService.getSemService((Project)psiClass.getProject());
        for (PsiAnnotation psiAnnotation : annotations) {
            sources.addAll(semService.getSemElements(SpringJamPropertySource.REPEATABLE_ANNO_JAM_KEY, (PsiElement)psiAnnotation));
        }
        JamService jamService = JamService.getJamService((Project)psiClass.getProject());
        SpringPropertySource propertySource = (SpringPropertySource)jamService.getJamElement(SpringPropertySource.PROPERTY_SOURCE_JAM_KEY, (PsiElement)psiClass);
        if (propertySource != null && propertySource.getAnnotation() != null && !ArrayUtil.contains((Object)propertySource.getAnnotation(), (Object[])annotations)) {
            sources.add(propertySource);
        }
        if ((propertySources = (SpringPropertySources)SpringPropertySources.META.getJamElement((PsiModifierListOwner)psiClass)) != null) {
            sources.addAll(propertySources.getPropertySources());
        }
        SmartList smartList = sources;
        if (smartList == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(43);
        }
        return smartList;
    }

    @NotNull
    private static List<CommonSpringBean> filterStereotypeComponents(@NotNull List<? extends CommonSpringBean> components, @NotNull Set<? extends SpringContextFilter.Exclude> excludeFilters, @NotNull Set<? extends PsiPackage> psiPackages) {
        if (components == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(44);
        }
        if (excludeFilters == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(45);
        }
        if (psiPackages == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(46);
        }
        ArrayList<CommonSpringBean> filtered = new ArrayList<CommonSpringBean>();
        for (CommonSpringBean commonSpringBean : components) {
            PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)commonSpringBean.getBeanType());
            if (psiClass == null || !SpringJamUtilsImpl.isInPackage(psiPackages, psiClass)) continue;
            boolean exclude = false;
            for (SpringContextFilter.Exclude exclude2 : excludeFilters) {
                if (!exclude2.exclude(psiClass)) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            filtered.add(commonSpringBean);
        }
        ArrayList<CommonSpringBean> arrayList = filtered;
        if (arrayList == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(47);
        }
        return arrayList;
    }

    @Override
    public boolean processCustomAnnotations(@NotNull PsiClass psiClass, @NotNull Processor<Pair<PsiClass, LocalModelDependency>> processor2) {
        PsiModifierList modifierList;
        if (psiClass == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(48);
        }
        if (processor2 == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(49);
        }
        if ((modifierList = psiClass.getModifierList()) != null) {
            for (PsiAnnotation psiAnnotation : modifierList.getAnnotations()) {
                LocalModelDependency dependency;
                boolean enableAnnotation;
                PsiClass annotationClass;
                String name = psiAnnotation.getQualifiedName();
                if (StringUtil.isEmptyOrSpaces((String)name) || (annotationClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(name, psiClass.getResolveScope())) == null || !(enableAnnotation = StringUtil.getShortName((String)name).startsWith("Enable")) && !SpringJamUtilsImpl.containsImportAnnotations(annotationClass) || processor2.process((Object)Pair.create((Object)annotationClass, (Object)(dependency = LocalModelDependency.create(enableAnnotation ? LocalModelDependencyType.ENABLE_ANNO : LocalModelDependencyType.IMPORT, psiAnnotation.getOriginalElement()))))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean containsImportAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringJamUtilsImpl.$$$reportNull$$$0(50);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, ANNOTATIONS, (int)0);
    }

    @Override
    public boolean processCustomDependentLocalModels(LocalAnnotationModel localAnnotationModel, PairProcessor<? super LocalModel, ? super LocalModelDependency> processor2) {
        for (LocalAnnotationModelDependentModelsProvider provider : (LocalAnnotationModelDependentModelsProvider[])LocalAnnotationModelDependentModelsProvider.EP_NAME.getExtensions()) {
            if (provider.processCustomDependentLocalModels(localAnnotationModel, processor2)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 21: 
            case 22: 
            case 29: 
            case 33: 
            case 37: 
            case 41: 
            case 43: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 21: 
            case 22: 
            case 29: 
            case 33: 
            case 37: 
            case 41: 
            case 43: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 4: 
            case 17: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 21: 
            case 22: 
            case 29: 
            case 33: 
            case 37: 
            case 41: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beansInModel";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentScan";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allComponents";
                break;
            }
            case 25: 
            case 31: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackages";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeContextFilters";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeContextFilters";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
            case 30: 
            case 32: 
            case 34: 
            case 40: 
            case 42: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 35: 
            case 39: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/utils/SpringJamUtilsImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationConfigAppContextedBeans";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotatedStereotypes";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findStereotypeConfigurationBeans";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNames";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "filterComponentScannedStereotypes";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextBeans";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportedResources";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportedClasses";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeansPackagesScan";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertySources";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "filterStereotypeComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationConfigAppContextedBeans";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 21: 
            case 22: 
            case 29: 
            case 33: 
            case 37: 
            case 41: 
            case 43: 
            case 47: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotatedStereotypes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isStereotypeAccepted";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findStereotypeConfigurationBeans";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectNames";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotNull";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getComponentScannedBeans";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "filterComponentScannedStereotypes";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getContextBeans";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findStereotypeElement";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isInPackage";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getImportedResources";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "processImportedResources";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getImportedClasses";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processImportedClasses";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getBeansPackagesScan";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getPropertySources";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "filterStereotypeComponents";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "processCustomAnnotations";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "containsImportAnnotations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 21: 
            case 22: 
            case 29: 
            case 33: 
            case 37: 
            case 41: 
            case 43: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

