/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JamAnnotationTypeUtilImpl
extends JamAnnotationTypeUtil {
    @NonNls
    private static final String[] DEFAULT_SPRING_COMPONENTS = new String[]{"org.springframework.stereotype.Component", "org.springframework.stereotype.Controller", "org.springframework.stereotype.Repository", "org.springframework.stereotype.Service", "org.springframework.config.java.annotation.Configuration", "org.springframework.context.annotation.Configuration", "javax.inject.Named"};
    private final Module myModule;

    public JamAnnotationTypeUtilImpl(Module module) {
        this.myModule = module;
    }

    @Override
    @NotNull
    public List<PsiClass> getQualifierAnnotationTypesWithChildren() {
        SmartList list = new SmartList();
        list.addAll(this.getAnnotationTypesWithChildren("org.springframework.beans.factory.annotation.Qualifier"));
        list.addAll(this.getAnnotationTypesWithChildren("javax.inject.Qualifier"));
        list.addAll(this.getImplicitQualifierAnnotations());
        SmartList smartList = list;
        if (smartList == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(0);
        }
        return smartList;
    }

    private Set<PsiClass> getImplicitQualifierAnnotations() {
        return (Set)CachedValuesManager.getManager((Project)this.myModule.getProject()).getCachedValue((UserDataHolder)this.myModule, () -> {
            PsiClass customAutowireConfigurerClass = SpringCommonUtils.findLibraryClass(this.myModule, "org.springframework.beans.factory.annotation.CustomAutowireConfigurer");
            if (customAutowireConfigurerClass == null) {
                return CachedValueProvider.Result.create(Collections.emptySet(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            GlobalSearchScope moduleSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule);
            SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass(customAutowireConfigurerClass).withInheritors();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myModule.getProject());
            HashSet<PsiClass> types = new HashSet<PsiClass>();
            for (SpringModel model : SpringManager.getInstance(this.myModule.getProject()).getAllModels(this.myModule)) {
                List<SpringBeanPointer<?>> beanPointers = SpringModelSearchers.findBeans((CommonSpringModel)model, searchParameters);
                for (SpringBeanPointer<?> beanPointer : beanPointers) {
                    Object bean = beanPointer.getSpringBean();
                    SpringPropertyDefinition propertyDefinition = SpringPropertyUtils.findPropertyByName(bean, "customQualifierTypes");
                    if (!(propertyDefinition instanceof SpringProperty)) continue;
                    for (String value : SpringPropertyUtils.getListOrSetValues((SpringProperty)propertyDefinition)) {
                        PsiClass psiClass;
                        if (StringUtil.isEmptyOrSpaces((String)value) || (psiClass = facade.findClass(value, moduleSearchScope)) == null || !psiClass.isAnnotationType()) continue;
                        types.add(psiClass);
                    }
                }
            }
            return CachedValueProvider.Result.create(types, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Override
    @NotNull
    public List<String> getUserDefinedCustomComponentAnnotations() {
        List<String> annotations = this.getCustomComponentAnnotations();
        for (String defaultAnno : DEFAULT_SPRING_COMPONENTS) {
            if (defaultAnno.equals("org.springframework.stereotype.Component")) {
                annotations.remove(defaultAnno);
                continue;
            }
            for (PsiClass annoClass : this.getAnnotationTypesWithChildren(defaultAnno)) {
                String qualifiedName = annoClass.getQualifiedName();
                if (qualifiedName == null) continue;
                annotations.remove(qualifiedName);
            }
        }
        List<String> list = annotations;
        if (list == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    private List<String> getCustomComponentAnnotations() {
        Collection<PsiClass> classes = this.getAnnotationTypesWithChildrenIncludingTests("org.springframework.stereotype.Component");
        List list = ContainerUtil.mapNotNull(classes, (Function)((NullableFunction)PsiClass::getQualifiedName));
        if (list == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<PsiClass> getAnnotationTypesWithChildren(@NotNull String annotationName) {
        if (annotationName == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(3);
        }
        Collection<PsiClass> collection = this.getAnnotationTypes(annotationName, false);
        if (collection == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    public Collection<PsiClass> getAnnotationTypesWithChildrenIncludingTests(@NotNull String annotationName) {
        if (annotationName == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(5);
        }
        return this.getAnnotationTypes(annotationName, true);
    }

    private Collection<PsiClass> getAnnotationTypes(@NotNull String annotationName, boolean inTests) {
        if (annotationName == null) {
            JamAnnotationTypeUtilImpl.$$$reportNull$$$0(6);
        }
        if (this.myModule.isDisposed()) {
            return Collections.emptyList();
        }
        return MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)this.myModule, (String)annotationName, (boolean)inTests);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/utils/JamAnnotationTypeUtilImpl";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierAnnotationTypesWithChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserDefinedCustomComponentAnnotations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomComponentAnnotations";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/utils/JamAnnotationTypeUtilImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationTypesWithChildren";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationTypesWithChildren";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationTypesWithChildrenIncludingTests";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

