/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts.converters;

import com.intellij.jam.JamSimpleReferenceConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourcePathReferenceConverter<T>
extends JamSimpleReferenceConverter<List<T>> {
    public List<T> fromString(@Nullable String s, JamStringAttributeElement<List<T>> context) {
        return s == null ? null : this.getFiles(this.getReferences(s, context));
    }

    public List<T> getFiles(PsiReference[] references) {
        for (PsiReference reference : references) {
            FileReference lastFileReference;
            FileReference fileReference = FileReference.findFileReference((PsiReference)reference);
            if (fileReference == null || (lastFileReference = fileReference.getLastFileReference()) == null) continue;
            Object[] resolve = lastFileReference.multiResolve(false);
            return ContainerUtil.mapNotNull((Object[])resolve, this.getMapper());
        }
        return Collections.emptyList();
    }

    protected abstract Function<ResolveResult, T> getMapper();

    public PsiReference @NotNull [] createReferences(@NotNull JamStringAttributeElement<List<T>> context, @NotNull PsiLanguageInjectionHost injectionHost) {
        if (context == null) {
            ResourcePathReferenceConverter.$$$reportNull$$$0(0);
        }
        if (injectionHost == null) {
            ResourcePathReferenceConverter.$$$reportNull$$$0(1);
        }
        PsiReference[] psiReferenceArray = ResourcePathReferenceConverter.getReferences(injectionHost);
        if (psiReferenceArray == null) {
            ResourcePathReferenceConverter.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    protected PsiReference[] getReferences(@NotNull String s, JamStringAttributeElement<List<T>> context) {
        PsiLiteral psiLiteral;
        if (s == null) {
            ResourcePathReferenceConverter.$$$reportNull$$$0(3);
        }
        if ((psiLiteral = context.getPsiLiteral()) == null) {
            return ResourcePathReferenceConverter.getReferencesOnFakeElement((PsiElement)context.getPsiElement(), s, new Module[0]);
        }
        return ResourcePathReferenceConverter.getReferences((PsiElement)psiLiteral, s, new Module[0]);
    }

    private static PsiReference[] getReferences(@NotNull PsiElement psiLiteral, String s, Module ... modules) {
        if (psiLiteral == null) {
            ResourcePathReferenceConverter.$$$reportNull$$$0(4);
        }
        SpringResourcesBuilder resourcesBuilder = SpringResourcesBuilder.create(psiLiteral, s).fromRoot(s.startsWith("/")).soft(false).modules(modules);
        return SpringResourcesUtil.getInstance().getReferences(resourcesBuilder);
    }

    protected static PsiReference @NotNull [] getReferencesOnFakeElement(@Nullable PsiElement element, @NotNull String s, Module ... modules) {
        block7: {
            PsiReference[] psiReferenceArray;
            if (s == null) {
                ResourcePathReferenceConverter.$$$reportNull$$$0(5);
            }
            if (element == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    ResourcePathReferenceConverter.$$$reportNull$$$0(6);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            try {
                PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)element.getProject()).createExpressionFromText("\"" + s + "\"", element);
                if (!(psiExpression instanceof PsiLiteral)) break block7;
                psiReferenceArray = ResourcePathReferenceConverter.getReferences((PsiElement)psiExpression, s, modules);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
            if (psiReferenceArray == null) {
                ResourcePathReferenceConverter.$$$reportNull$$$0(7);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            ResourcePathReferenceConverter.$$$reportNull$$$0(8);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static PsiReference[] getReferences(@NotNull PsiLanguageInjectionHost injectionHost) {
        if (injectionHost == null) {
            ResourcePathReferenceConverter.$$$reportNull$$$0(9);
        }
        String s = ElementManipulators.getValueText((PsiElement)injectionHost);
        return ResourcePathReferenceConverter.getReferences((PsiElement)injectionHost, s, new Module[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionHost";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/testContexts/converters/ResourcePathReferenceConverter";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/testContexts/converters/ResourcePathReferenceConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesOnFakeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesOnFakeElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

