/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamEnumAttributeElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.highlighting.jam.SpringJavaInspectionBase;
import com.intellij.spring.model.jam.testContexts.SpringContextHierarchy;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.jam.testContexts.dirtiesContexts.ClassMode;
import com.intellij.spring.model.jam.testContexts.dirtiesContexts.HierarchyMode;
import com.intellij.spring.model.jam.testContexts.dirtiesContexts.MethodMode;
import com.intellij.spring.model.jam.testContexts.dirtiesContexts.SpringTestingDirtiesContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringTestingDirtiesContextInspection
extends SpringJavaInspectionBase {
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Module module;
        if (aClass == null) {
            SpringTestingDirtiesContextInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringTestingDirtiesContextInspection.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass)) == null || !SpringTestContextUtil.getInstance().isTestContextConfigurationClass(aClass)) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
        SpringTestingDirtiesContext dirtiesContext = (SpringTestingDirtiesContext)SpringTestingDirtiesContext.CLASS_META.getJamElement((PsiModifierListOwner)aClass);
        if (dirtiesContext != null) {
            SpringTestingDirtiesContextInspection.checkMethodModeOnClass(holder, dirtiesContext);
            SpringTestingDirtiesContextInspection.checkHierarchyMode(aClass, holder, dirtiesContext);
        }
        for (PsiMethod method : aClass.getMethods()) {
            SpringTestingDirtiesContext methodDirties = (SpringTestingDirtiesContext)SpringTestingDirtiesContext.METHOD_META.getJamElement((PsiModifierListOwner)method);
            if (methodDirties == null) continue;
            SpringTestingDirtiesContextInspection.checkHierarchyMode(aClass, holder, methodDirties);
            SpringTestingDirtiesContextInspection.checkClassModeOnMethod(holder, methodDirties);
        }
        return holder.getResultsArray();
    }

    private static void checkMethodModeOnClass(ProblemsHolder holder, SpringTestingDirtiesContext dirtiesContext) {
        PsiAnnotationMemberValue psiElement;
        JamEnumAttributeElement<MethodMode> methodModeElement = dirtiesContext.getMethodModeElement();
        if (methodModeElement.getValue() != null && (psiElement = methodModeElement.getPsiElement()) != null) {
            holder.registerProblem((PsiElement)psiElement, SpringBundle.message("spring.testing.model.dirties.method.mode.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static void checkClassModeOnMethod(ProblemsHolder holder, SpringTestingDirtiesContext methodDirties) {
        PsiAnnotationMemberValue psiElement;
        JamEnumAttributeElement<ClassMode> methodModeElement = methodDirties.getClassModeElement();
        if (methodModeElement.getValue() != null && (psiElement = methodModeElement.getPsiElement()) != null) {
            holder.registerProblem((PsiElement)psiElement, SpringBundle.message("spring.testing.model.dirties.class.mode.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static void checkHierarchyMode(@Nullable PsiClass aClass, ProblemsHolder holder, @NotNull SpringTestingDirtiesContext dirtiesContext) {
        PsiAnnotationMemberValue psiElement;
        if (dirtiesContext == null) {
            SpringTestingDirtiesContextInspection.$$$reportNull$$$0(2);
        }
        if (aClass == null) {
            return;
        }
        JamEnumAttributeElement<HierarchyMode> hierarchyModeElement = dirtiesContext.getHierarchyModeElement();
        if (hierarchyModeElement.getValue() != null && SpringContextHierarchy.META.getJamElement((PsiModifierListOwner)aClass) == null && (psiElement = hierarchyModeElement.getPsiElement()) != null) {
            holder.registerProblem((PsiElement)psiElement, SpringBundle.message("spring.testing.model.dirties.hierarchy.mode.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtiesContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/jam/testContexts/SpringTestingDirtiesContextInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkHierarchyMode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

