/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.jam.JamSimpleReferenceConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanReferenceJamConverter
extends JamSimpleReferenceConverter<SpringBeanPointer<?>> {
    @Nullable
    private final String myBaseClass;

    public SpringBeanReferenceJamConverter(@Nullable String baseClass) {
        this.myBaseClass = baseClass;
    }

    @Nullable
    public String getBaseClass() {
        return this.myBaseClass;
    }

    public SpringBeanPointer<?> fromString(@Nullable String s, JamStringAttributeElement<SpringBeanPointer<?>> context) {
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return null;
        }
        CommonSpringModel model = this.getSpringModel((PsiElement)context.getPsiElement());
        return SpringModelSearchers.findBean(model, s);
    }

    public Collection<SpringBeanPointer<?>> getVariants(JamStringAttributeElement<SpringBeanPointer<?>> context) {
        PsiAnnotationMemberValue psiElement = context.getPsiElement();
        if (psiElement == null) {
            return Collections.emptyList();
        }
        if (this.myBaseClass == null) {
            CommonSpringModel model = this.getSpringModel((PsiElement)psiElement);
            return model.getAllCommonBeans();
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)psiElement.getProject()).findClass(this.myBaseClass, psiElement.getResolveScope());
        if (psiClass == null) {
            return Collections.emptyList();
        }
        CommonSpringModel model = this.getSpringModel((PsiElement)psiElement);
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass(psiClass).withInheritors().effectiveBeanTypes();
        return SpringModelSearchers.findBeans(model, searchParameters);
    }

    @NotNull
    protected LookupElement createLookupElementFor(@NotNull SpringBeanPointer<?> target) {
        LookupElement variant;
        if (target == null) {
            SpringBeanReferenceJamConverter.$$$reportNull$$$0(0);
        }
        LookupElement lookupElement = (variant = SpringConverterUtil.createCompletionVariant(target)) != null ? variant : super.createLookupElementFor(target);
        if (lookupElement == null) {
            SpringBeanReferenceJamConverter.$$$reportNull$$$0(1);
        }
        return lookupElement;
    }

    protected PsiElement getPsiElementFor(@NotNull SpringBeanPointer<?> target) {
        if (target == null) {
            SpringBeanReferenceJamConverter.$$$reportNull$$$0(2);
        }
        return target.getSpringBean().getIdentifyingPsiElement();
    }

    @NotNull
    protected CommonSpringModel getSpringModel(PsiElement psiElement) {
        CommonSpringModel commonSpringModel = SpringModelUtils.getInstance().getSpringModel(psiElement);
        if (commonSpringModel == null) {
            SpringBeanReferenceJamConverter.$$$reportNull$$$0(3);
        }
        return commonSpringModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/converters/SpringBeanReferenceJamConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/converters/SpringBeanReferenceJamConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElementFor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElementFor";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

