/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.spring.model.values.PlaceholderPropertyReference;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringPlaceholdersInspection
extends BasicDomElementsInspection<Beans> {
    public SpringPlaceholdersInspection() {
        super(Beans.class, new Class[0]);
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        if (element instanceof GenericDomValue) {
            XmlElement xmlElement;
            GenericDomValue value = (GenericDomValue)element;
            if (PlaceholderUtils.getInstance().isRawTextPlaceholder(value) && (xmlElement = SpringPlaceholdersInspection.getPlaceholderElement(value)) != null) {
                for (PsiReference psiReference : xmlElement.getReferences()) {
                    ResolveResult[] resolve;
                    PlaceholderPropertyReference placeholderPropertyReference;
                    String defaultValue;
                    if (!(psiReference instanceof PlaceholderPropertyReference) || (defaultValue = (placeholderPropertyReference = (PlaceholderPropertyReference)psiReference).getDefaultValue()) != null || (resolve = placeholderPropertyReference.multiResolve(false)).length != 0) continue;
                    holder.createResolveProblem(value, (PsiReference)placeholderPropertyReference);
                }
            }
        }
    }

    @Nullable
    private static XmlElement getPlaceholderElement(@NotNull GenericDomValue<?> value) {
        XmlElement xmlElement;
        if (value == null) {
            SpringPlaceholdersInspection.$$$reportNull$$$0(0);
        }
        if ((xmlElement = value.getXmlElement()) instanceof XmlAttribute) {
            return ((XmlAttribute)xmlElement).getValueElement();
        }
        return xmlElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/spring/model/highlighting/xml/SpringPlaceholdersInspection", "getPlaceholderElement"));
    }
}

