/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.highlighting.jam.SpringJavaInspectionBase;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringJavaAutowiredFieldsWarningInspection
extends SpringJavaInspectionBase {
    public ProblemDescriptor @Nullable [] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiFile file;
        if (aClass == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(1);
        }
        if (JamCommonUtil.isPlainJavaFile((PsiElement)(file = aClass.getContainingFile())) && !ProjectRootsUtil.isInTestSource((PsiFile)file)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
            if (!SpringCommonUtils.hasSpringFacet(module) && !SpringModelUtils.getInstance().hasAutoConfiguredModels(module)) {
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            if (!SpringCommonUtils.isStereotypeComponentOrMeta(aClass)) {
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            if (!SpringLibraryUtil.isAtLeastVersion(module, SpringLibraryUtil.SpringVersion.V_4_3)) {
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            for (JamSpringBeanPointer pointer : SpringJavaClassInfo.getSpringJavaClassInfo(aClass).getStereotypeMappedBeans()) {
                if (!(pointer.getSpringBean() instanceof ContextJavaBean)) continue;
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
            Set<String> annotations = SpringAutowireUtil.getAutowiredAnnotations(module);
            Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> autowiredFields = SpringJavaAutowiredFieldsWarningInspection.getAutowiredFields(aClass, annotations);
            LocalQuickFix allFieldsFix = null;
            if (autowiredFields.size() > 1) {
                allFieldsFix = SpringJavaAutowiredFieldsWarningInspection.getFieldsAutowiredFix(aClass, autowiredFields, annotations);
            }
            for (Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>> pair : autowiredFields) {
                LocalQuickFix[] localQuickFixArray;
                LocalQuickFix fieldFx = SpringJavaAutowiredFieldsWarningInspection.getFieldsAutowiredFix(aClass, Collections.singleton(pair), annotations);
                if (allFieldsFix != null) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[2];
                    localQuickFixArray2[0] = fieldFx;
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[1] = allFieldsFix;
                } else {
                    LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray3;
                    localQuickFixArray3[0] = fieldFx;
                }
                LocalQuickFix[] fixes = localQuickFixArray;
                PsiAnnotation psiAnnotation = (PsiAnnotation)((SmartPsiElementPointer)pair.getSecond()).getElement();
                if (psiAnnotation == null) continue;
                holder.registerProblem((PsiElement)psiAnnotation, SpringBundle.message("field.injection.is.not.recommended", new Object[0]), fixes);
            }
            return holder.getResultsArray();
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private static Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> getAutowiredFields(@NotNull PsiClass aClass, @NotNull Set<String> annotations) {
        if (aClass == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(2);
        }
        if (annotations == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(3);
        }
        HashSet<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> pairs = new HashSet<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>>();
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)aClass.getProject());
        for (PsiField psiField : aClass.getFields()) {
            for (String autowiredAnno : annotations) {
                if (autowiredAnno.equals("javax.annotation.Resource")) continue;
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiField, (String[])new String[]{autowiredAnno});
                if (annotation == null) continue;
                smartPointerManager.createSmartPsiElementPointer((PsiElement)psiField);
                pairs.add((Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>)Pair.create((Object)smartPointerManager.createSmartPsiElementPointer((PsiElement)psiField), (Object)smartPointerManager.createSmartPsiElementPointer((PsiElement)annotation)));
            }
        }
        return pairs;
    }

    private static LocalQuickFix getFieldsAutowiredFix(PsiClass aClass, Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> fields, Set<String> annotations) {
        PsiMethod constructor = SpringJavaAutowiredFieldsWarningInspection.findAutowiredConstructor(aClass, annotations);
        return constructor != null ? new AddParameterQuickFix(aClass, constructor, fields) : new CreateAutowiredConstructorQuickFix(aClass, fields);
    }

    @Nullable
    private static PsiMethod findAutowiredConstructor(@NotNull PsiClass aClass, @NotNull Set<String> annotations) {
        PsiMethod[] constructors;
        if (aClass == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(4);
        }
        if (annotations == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(5);
        }
        if ((constructors = aClass.getConstructors()).length == 1) {
            return constructors[0] instanceof LightElement ? null : constructors[0];
        }
        for (PsiMethod method : constructors) {
            if (method instanceof LightElement || !AnnotationUtil.isAnnotated((PsiModifierListOwner)method, annotations, (int)0)) continue;
            return method;
        }
        return null;
    }

    private static void addAutowiredAnnotationIfNeeded(@Nullable PsiClass psiClass, @NotNull PsiMethod constructor, @NotNull String fqnAnno) {
        if (constructor == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(6);
        }
        if (fqnAnno == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(7);
        }
        if (psiClass == null || psiClass.getConstructors().length == 1) {
            return;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)constructor.getProject()).getElementFactory();
        PsiAnnotation psiAnnotation = elementFactory.createAnnotationFromText("@" + fqnAnno, null);
        PsiModifierList modifierList = constructor.getModifierList();
        PsiElement element = modifierList.getFirstChild();
        if (element != null) {
            modifierList.addBefore((PsiElement)psiAnnotation, element);
        } else {
            modifierList.add((PsiElement)psiAnnotation);
        }
    }

    @NotNull
    private static String getAutowiredAnnotation(@NotNull SmartPsiElementPointer<PsiAnnotation> anno) {
        String qualifiedName;
        PsiAnnotation annotation;
        if (anno == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(8);
        }
        if ((annotation = (PsiAnnotation)anno.getElement()) != null && annotation.isValid() && StringUtil.isNotEmpty((String)(qualifiedName = annotation.getQualifiedName()))) {
            String string = qualifiedName;
            if (string == null) {
                SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(9);
            }
            return string;
        }
        return "org.springframework.beans.factory.annotation.Autowired";
    }

    private static void addParameters(Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> myParameterCandidates, PsiMethod constructor) {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)constructor.getProject()).getElementFactory();
        Map qualifierAnnotationClassNames = FactoryMap.create(module -> {
            List<PsiClass> qualifierAnnotations = JamAnnotationTypeUtil.getInstance(module).getQualifierAnnotationTypesWithChildren();
            return ContainerUtil.mapNotNull(qualifierAnnotations, PsiClass::getQualifiedName);
        });
        for (Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>> pair : myParameterCandidates) {
            PsiClass containingClass;
            PsiModifierList fieldModifierList;
            PsiField field = (PsiField)((SmartPsiElementPointer)pair.first).getElement();
            PsiAnnotation annotation = (PsiAnnotation)((SmartPsiElementPointer)pair.second).getElement();
            if (field == null || annotation == null || !field.isValid() || !annotation.isValid()) continue;
            String name = field.getName();
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                return;
            }
            PsiParameter parameter = elementFactory.createParameter(name, field.getType());
            PsiModifierList modifierList = parameter.getModifierList();
            if (modifierList != null) {
                for (PsiAnnotation qualifierAnno : SpringJavaAutowiredFieldsWarningInspection.getQualifierAnnotations(field, qualifierAnnotationClassNames)) {
                    modifierList.add((PsiElement)elementFactory.createAnnotationFromText(qualifierAnno.getText(), (PsiElement)modifierList));
                    qualifierAnno.delete();
                }
            }
            constructor.getParameterList().add((PsiElement)parameter);
            PsiCodeBlock body = constructor.getBody();
            if (body != null) {
                body.add((PsiElement)elementFactory.createStatementFromText("this." + name + " = " + name + ";", (PsiElement)constructor));
            }
            if ((fieldModifierList = field.getModifierList()) != null && !fieldModifierList.hasModifierProperty("final") && (containingClass = constructor.getContainingClass()) != null && containingClass.getConstructors().length == 1) {
                fieldModifierList.setModifierProperty("final", true);
            }
            annotation.delete();
        }
    }

    private static PsiAnnotation[] getQualifierAnnotations(@NotNull PsiField first, Map<Module, List<String>> qualifierAnnotationClassNames) {
        Module module;
        if (first == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(10);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)first)) == null) {
            return PsiAnnotation.EMPTY_ARRAY;
        }
        List<String> annotations = qualifierAnnotationClassNames.get(module);
        List vs = ContainerUtil.mapNotNull(annotations, s -> AnnotationUtil.findAnnotation((PsiModifierListOwner)first, (String[])new String[]{s}));
        return vs.toArray(PsiAnnotation.EMPTY_ARRAY);
    }

    @NotNull
    private static String getConstructorName(@Nullable PsiMethod psiMethod, @NotNull Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> parameterCandidates) {
        if (parameterCandidates == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(11);
        }
        StringBuilder sb = new StringBuilder();
        if (psiMethod != null) {
            sb.append(psiMethod.getName());
            sb.append("(");
            sb.append(SpringJavaAutowiredFieldsWarningInspection.getConstructorParameters(psiMethod.getParameterList().getParameters()));
            sb.append(SpringJavaAutowiredFieldsWarningInspection.addNewParameters(parameterCandidates));
            sb.append(")");
        }
        String string = sb.toString();
        if (string == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static String getConstructorParameters(PsiParameter[] parameters) {
        StringBuilder sb = new StringBuilder();
        int maxParamsLength = 53;
        for (PsiParameter parameter : parameters) {
            String presentableText = parameter.getType().getPresentableText();
            if (sb.length() + presentableText.length() >= maxParamsLength) {
                sb.append("...,");
                break;
            }
            sb.append(presentableText);
            sb.append(",");
        }
        return sb.toString();
    }

    @NotNull
    private static String getConstructorName(@Nullable String name, @NotNull Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> parameterCandidates) {
        if (parameterCandidates == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(13);
        }
        String string = name + "(" + SpringJavaAutowiredFieldsWarningInspection.addNewParameters(parameterCandidates) + ")";
        if (string == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static String addNewParameters(@NotNull Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> parameterCandidates) {
        if (parameterCandidates == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(15);
        }
        StringBuilder sb = new StringBuilder();
        int maxNewParamsLength = 53;
        int current = 0;
        for (Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>> pair : parameterCandidates) {
            PsiField psiField = (PsiField)((SmartPsiElementPointer)pair.first).getElement();
            if (psiField != null) {
                String newParam = "<b>" + psiField.getType().getPresentableText() + "</b>";
                if (sb.length() + newParam.length() < maxNewParamsLength || current == parameterCandidates.size() - 1 || current == 0) {
                    if (current > 0) {
                        sb.append(",");
                    }
                    sb.append(newParam);
                } else {
                    sb.append(" and ");
                    sb.append(parameterCandidates.size() - current);
                    sb.append(" more parameters");
                    break;
                }
            }
            current = (byte)(current + 1);
        }
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqnAnno";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/jam/SpringJavaAutowiredFieldsWarningInspection";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/jam/SpringJavaAutowiredFieldsWarningInspection";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutowiredAnnotation";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAutowiredFields";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findAutowiredConstructor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAutowiredAnnotationIfNeeded";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAutowiredAnnotation";
                break;
            }
            case 9: 
            case 12: 
            case 14: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierAnnotations";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addNewParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddParameterQuickFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<PsiMethod> myConstructor;
        private final Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> myParameterCandidates;

        AddParameterQuickFix(PsiClass containingClass, @NotNull PsiMethod constructor, @NotNull Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> pairs) {
            if (constructor == null) {
                AddParameterQuickFix.$$$reportNull$$$0(0);
            }
            if (pairs == null) {
                AddParameterQuickFix.$$$reportNull$$$0(1);
            }
            this.myConstructor = SmartPointerManager.getInstance((Project)constructor.getProject()).createSmartPsiElementPointer((PsiElement)constructor);
            this.myParameterCandidates = pairs;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = SpringBundle.message("field.injection.add.parameters", SpringJavaAutowiredFieldsWarningInspection.getConstructorName((PsiMethod)this.myConstructor.getElement(), this.myParameterCandidates));
            if (string == null) {
                AddParameterQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethod constructor;
            if (project == null) {
                AddParameterQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                AddParameterQuickFix.$$$reportNull$$$0(4);
            }
            if ((constructor = (PsiMethod)this.myConstructor.getElement()) == null) {
                return;
            }
            if (!this.myParameterCandidates.isEmpty()) {
                SpringJavaAutowiredFieldsWarningInspection.addParameters(this.myParameterCandidates, constructor);
            }
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("field.injection.add.parameter.family.warning", new Object[0]);
            if (string == null) {
                AddParameterQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constructor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pairs";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/highlighting/jam/SpringJavaAutowiredFieldsWarningInspection$AddParameterQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/highlighting/jam/SpringJavaAutowiredFieldsWarningInspection$AddParameterQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CreateAutowiredConstructorQuickFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<PsiClass> myClass;
        private final Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> myParameterCandidates;
        private final String message;

        CreateAutowiredConstructorQuickFix(PsiClass containingClass, @NotNull Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> pairs) {
            if (pairs == null) {
                CreateAutowiredConstructorQuickFix.$$$reportNull$$$0(0);
            }
            this.myClass = SmartPointerManager.getInstance((Project)containingClass.getProject()).createSmartPsiElementPointer((PsiElement)containingClass);
            this.myParameterCandidates = pairs;
            this.message = SpringJavaAutowiredFieldsWarningInspection.getConstructorName(containingClass.getName(), this.myParameterCandidates);
        }

        @Nls
        @NotNull
        public String getName() {
            String string = SpringBundle.message("field.injection.create.constructor.injection", this.message);
            if (string == null) {
                CreateAutowiredConstructorQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiClass containingClass;
            if (project == null) {
                CreateAutowiredConstructorQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                CreateAutowiredConstructorQuickFix.$$$reportNull$$$0(3);
            }
            if ((containingClass = (PsiClass)this.myClass.getElement()) == null) {
                return;
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiMethod constructor = elementFactory.createConstructor();
            constructor.setName(containingClass.getName());
            PsiMethod addedConstructor = (PsiMethod)containingClass.add((PsiElement)constructor);
            PsiUtil.setModifierProperty((PsiModifierListOwner)addedConstructor, (String)"public", (boolean)true);
            SpringJavaAutowiredFieldsWarningInspection.addParameters(this.myParameterCandidates, addedConstructor);
            SpringJavaAutowiredFieldsWarningInspection.addAutowiredAnnotationIfNeeded(containingClass, addedConstructor, SpringJavaAutowiredFieldsWarningInspection.getAutowiredAnnotation((SmartPsiElementPointer<PsiAnnotation>)((SmartPsiElementPointer)this.myParameterCandidates.iterator().next().second)));
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("field.injection.create.constructor.family.warning", new Object[0]);
            if (string == null) {
                CreateAutowiredConstructorQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pairs";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/highlighting/jam/SpringJavaAutowiredFieldsWarningInspection$CreateAutowiredConstructorQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/highlighting/jam/SpringJavaAutowiredFieldsWarningInspection$CreateAutowiredConstructorQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

