/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.jam.stereotype.SpringImportResource;
import com.intellij.spring.model.jam.utils.SpringResourceLocationsUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/spring/model/highlighting/jam/SpringImportResourceInspection;", "Lcom/intellij/spring/model/highlighting/jam/SpringUastInspectionBase;", "()V", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "uClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.spring.core"})
public final class SpringImportResourceInspection
extends SpringUastInspectionBase {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        UElement uElement = uClass.getUastAnchor();
        if (uElement == null || (uElement = uElement.getSourcePsi()) == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        UElement nameIdentifier = uElement;
        PsiClass psiClass = uClass.getJavaPsi();
        if (!SpringCommonUtils.isConfigurationOrMeta(psiClass)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        SpringImportResource importResource = (SpringImportResource)SpringImportResource.META.getJamElement((PsiModifierListOwner)psiClass);
        if (importResource != null) {
            ProblemsHolder holder = new ProblemsHolder(manager, nameIdentifier.getContainingFile(), isOnTheFly);
            Iterator<JamStringAttributeElement<List<XmlFile>>> iterator = importResource.getLocationElements().iterator();
            while (iterator.hasNext()) {
                JamStringAttributeElement<List<XmlFile>> attributeElement;
                JamStringAttributeElement<List<XmlFile>> jamStringAttributeElement = attributeElement = iterator.next();
                Intrinsics.checkNotNullExpressionValue(jamStringAttributeElement, (String)"attributeElement");
                SpringResourceLocationsUtil.INSTANCE.checkResourceLocation(holder, jamStringAttributeElement);
            }
            return holder.getResultsArray();
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    public SpringImportResourceInspection() {
        super(Reflection.getOrCreateKotlinClass(UClass.class));
    }
}

