/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSpringJavaConfigInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AbstractSpringJavaConfigInspection.$$$reportNull$$$0(0);
        }
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                AbstractSpringJavaConfigInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile());
        if (!SpringLibraryUtil.hasSpringLibrary(module) || !SpringCommonUtils.hasSpringFacet(module)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                AbstractSpringJavaConfigInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            AbstractSpringJavaConfigInspection.$$$reportNull$$$0(3);
        }
        return psiElementVisitor;
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            AbstractSpringJavaConfigInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            AbstractSpringJavaConfigInspection.$$$reportNull$$$0(5);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (SpringModelUtils.getInstance().hasAutoConfiguredModels(module)) {
            ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
            this.checkJavaFile((PsiJavaFile)file, holder, isOnTheFly, module);
            List problemDescriptors = holder.getResults();
            return problemDescriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
        }
        return null;
    }

    protected void checkJavaFile(@NotNull PsiJavaFile javaFile, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull Module module) {
        if (javaFile == null) {
            AbstractSpringJavaConfigInspection.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            AbstractSpringJavaConfigInspection.$$$reportNull$$$0(7);
        }
        if (module == null) {
            AbstractSpringJavaConfigInspection.$$$reportNull$$$0(8);
        }
        for (PsiClass psiClass : javaFile.getClasses()) {
            this.checkClassInternal(psiClass, holder, module);
        }
    }

    private void checkClassInternal(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            AbstractSpringJavaConfigInspection.$$$reportNull$$$0(9);
        }
        this.checkClass(aClass, holder, module);
        for (PsiClass psiClass : aClass.getInnerClasses()) {
            this.checkClass(psiClass, holder, module);
        }
    }

    protected abstract void checkClass(PsiClass var1, ProblemsHolder var2, @NotNull Module var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/jam/AbstractSpringJavaConfigInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/jam/AbstractSpringJavaConfigInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkJavaFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkClassInternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

