/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.dom;

import com.intellij.codeInsight.daemon.impl.quickfix.ExtendsListFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.RequiredBeanType;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.ArrayList;
import java.util.List;

public final class RequiredBeanTypeChecker {
    private RequiredBeanTypeChecker() {
    }

    public static void check(DomElement element, DomElementAnnotationHolder holder) {
        boolean isOneRequiredClass;
        if (!(element instanceof GenericAttributeValue)) {
            return;
        }
        RequiredBeanType requiredBeanType = (RequiredBeanType)element.getAnnotation(RequiredBeanType.class);
        if (requiredBeanType == null) {
            return;
        }
        Object value = ((GenericAttributeValue)element).getValue();
        if (value == null) {
            return;
        }
        String[] requiredClasses = requiredBeanType.value();
        int notFoundRequiredClasses = 0;
        SmartList foundRequiredClasses = new SmartList();
        for (String requiredClassName : requiredClasses) {
            PsiClass requiredClass = DomJavaUtil.findClass((String)requiredClassName, (DomElement)element);
            if (requiredClass == null) {
                notFoundRequiredClasses = (short)(notFoundRequiredClasses + 1);
                continue;
            }
            foundRequiredClasses.add(requiredClass);
        }
        boolean bl = isOneRequiredClass = requiredClasses.length == 1;
        if (notFoundRequiredClasses == requiredClasses.length) {
            String message = isOneRequiredClass ? SpringApiBundle.message("bean.base.class.not.found", requiredClasses[0]) : SpringApiBundle.message("bean.base.classes.not.found", StringUtil.join((String[])requiredClasses, (String)","));
            holder.createProblem(element, message, new LocalQuickFix[0]);
            return;
        }
        if (value instanceof SpringBeanPointer) {
            SpringBeanPointer springBeanPointer = (SpringBeanPointer)value;
            RequiredBeanTypeChecker.checkSpringBeanPointer(element, holder, requiredClasses, (List<PsiClass>)foundRequiredClasses, isOneRequiredClass, springBeanPointer, false);
        } else if (value instanceof List) {
            List pointers = (List)value;
            for (SpringBeanPointer pointer : pointers) {
                RequiredBeanTypeChecker.checkSpringBeanPointer(element, holder, requiredClasses, (List<PsiClass>)foundRequiredClasses, isOneRequiredClass, pointer, true);
            }
        } else {
            throw new IllegalArgumentException("must (List)SpringBeanPointer: " + element);
        }
    }

    private static void checkSpringBeanPointer(DomElement element, DomElementAnnotationHolder holder, String[] requiredClasses, List<PsiClass> foundRequiredClasses, boolean oneRequiredClass, SpringBeanPointer<?> springBeanPointer, boolean multiple) {
        PsiClass psiClass;
        String message;
        String classText;
        PsiType[] psiTypes = springBeanPointer.getEffectiveBeanTypes();
        for (PsiClass requiredClass : foundRequiredClasses) {
            for (PsiType psiType : psiTypes) {
                if (!PsiTypesUtil.getClassType((PsiClass)requiredClass).isAssignableFrom(psiType)) continue;
                return;
            }
        }
        String string = classText = oneRequiredClass ? requiredClasses[0] : StringUtil.join((String[])requiredClasses, (String)",");
        if (!multiple) {
            message = oneRequiredClass ? SpringApiBundle.message("bean.must.be.of.type", classText) : SpringApiBundle.message("bean.must.be.one.of.these.types", classText);
        } else {
            String beanName = springBeanPointer.getName();
            message = oneRequiredClass ? SpringApiBundle.message("bean.name.must.be.of.type", beanName, classText) : SpringApiBundle.message("bean.name.must.be.one.of.these.types", beanName, classText);
        }
        ArrayList<ExtendsListFix> quickfixes = new ArrayList<ExtendsListFix>(foundRequiredClasses.size());
        if (psiTypes.length > 0 && (psiClass = PsiTypesUtil.getPsiClass((PsiType)psiTypes[0])) != null) {
            for (PsiClass foundRequiredClass : foundRequiredClasses) {
                quickfixes.add(new ExtendsListFix(psiClass, foundRequiredClass, true));
            }
        }
        holder.createProblem(element, message, quickfixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }
}

