/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.config;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.facet.validation.SpringProgrammaticConfigurationCollector;
import com.intellij.spring.model.highlighting.config.SetupProgrammaticContextFix;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringFacetProgrammaticInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SpringFacetProgrammaticInspection.$$$reportNull$$$0(0);
        }
        if (!ApplicationManager.getApplication().isInternal()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SpringFacetProgrammaticInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile());
        if (!SpringLibraryUtil.hasSpringLibrary(module)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SpringFacetProgrammaticInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            SpringFacetProgrammaticInspection.$$$reportNull$$$0(3);
        }
        return psiElementVisitor;
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SpringFacetProgrammaticInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            SpringFacetProgrammaticInspection.$$$reportNull$$$0(5);
        }
        Project project = manager.getProject();
        SpringProgrammaticConfigurationCollector collector = new SpringProgrammaticConfigurationCollector(project);
        collector.collect((ProgressIndicator)new EmptyProgressIndicator(), GlobalSearchScope.fileScope((PsiFile)file));
        List<PsiElement> results = collector.getResults();
        if (results.isEmpty()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        boolean hasSpringFacet = SpringCommonUtils.hasSpringFacet(module);
        SmartList problems = new SmartList();
        for (PsiElement element : results) {
            SetupProgrammaticContextFix fix2 = hasSpringFacet ? new SetupProgrammaticContextFix(element) : null;
            problems.add(manager.createProblemDescriptor(element, SpringBundle.message("spring.facet.programmatic.inspection.spring.context", new Object[0]), (LocalQuickFix)fix2, ProblemHighlightType.WEAK_WARNING, isOnTheFly));
        }
        return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/config/SpringFacetProgrammaticInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/config/SpringFacetProgrammaticInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

