/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.events.jam;

import com.intellij.jam.JamService;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.boot.reactor.ReactorConstants;
import com.intellij.spring.constants.SpringConstants;
import com.intellij.spring.model.events.beans.PublishEventPointDescriptor;
import com.intellij.spring.model.events.jam.CustomSpringEventListener;
import com.intellij.spring.model.events.jam.SpringBeanEventListener;
import com.intellij.spring.model.events.jam.SpringEventListener;
import com.intellij.spring.model.events.jam.SpringJamEventListener;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public final class SpringEventModelUtils {
    private static final String PUBLISH_EVENT_METHOD = "publishEvent";

    private SpringEventModelUtils() {
    }

    @NotNull
    public static Collection<PublishEventPointDescriptor> getPublishPoints(@NotNull Module module, @NotNull PsiType handledType) {
        PsiClass eventClass;
        if (module == null) {
            SpringEventModelUtils.$$$reportNull$$$0(0);
        }
        if (handledType == null) {
            SpringEventModelUtils.$$$reportNull$$$0(1);
        }
        boolean includeLibraries = true;
        if (handledType instanceof PsiClassType && (eventClass = ((PsiClassType)handledType).resolve()) != null && ModuleUtilCore.findModuleForPsiElement((PsiElement)eventClass) != null) {
            includeLibraries = false;
        }
        List list = ContainerUtil.filter(SpringEventModelUtils.getPublishPoints(module, includeLibraries), descriptor -> {
            PsiType publishType = descriptor.getEventType();
            return publishType != null && handledType.isAssignableFrom(publishType);
        });
        if (list == null) {
            SpringEventModelUtils.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private static Collection<PublishEventPointDescriptor> getPublishPoints(@NotNull Module module, boolean includeLibraries) {
        if (module == null) {
            SpringEventModelUtils.$$$reportNull$$$0(3);
        }
        List modulePublishPoints = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            List<PublishEventPointDescriptor> cacheValue = SpringEventModelUtils.findEventPublishingPoints(module.getProject(), module, SpringEventModelUtils.moduleNetworkScope(module));
            return CachedValueProvider.Result.createSingleDependency(cacheValue, (Object)UastModificationTracker.getInstance((Project)module.getProject()));
        });
        if (!includeLibraries) {
            List list = modulePublishPoints;
            if (list == null) {
                SpringEventModelUtils.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<PublishEventPointDescriptor> libraryPublishPoints = SpringEventModelUtils.getLibraryPublishPoints(module.getProject());
        List list = ContainerUtil.concat(libraryPublishPoints, (List)modulePublishPoints);
        if (list == null) {
            SpringEventModelUtils.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static GlobalSearchScope moduleNetworkScope(@NotNull Module module) {
        if (module == null) {
            SpringEventModelUtils.$$$reportNull$$$0(6);
        }
        HashSet<Module> moduleNetwork = new HashSet<Module>();
        moduleNetwork.add(module);
        SpringEventModelUtils.collectModuleNetwork(moduleNetwork, module);
        if (moduleNetwork.size() == 1) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleScope((Module)module);
            if (globalSearchScope == null) {
                SpringEventModelUtils.$$$reportNull$$$0(7);
            }
            return globalSearchScope;
        }
        List scopes = ContainerUtil.map2List(moduleNetwork, m -> GlobalSearchScope.moduleScope((Module)m));
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union((Collection)scopes);
        if (globalSearchScope == null) {
            SpringEventModelUtils.$$$reportNull$$$0(8);
        }
        return globalSearchScope;
    }

    private static void collectModuleNetwork(Set<Module> visited, Module module) {
        SmartList toVisit = new SmartList();
        HashSet dependencies = new HashSet();
        ModuleUtilCore.getDependencies((Module)module, dependencies);
        for (Module networkModule : dependencies) {
            if (visited.contains(networkModule) || !SpringLibraryUtil.hasSpringLibrary(networkModule)) continue;
            visited.add(networkModule);
            toVisit.add(networkModule);
        }
        HashSet dependents = new HashSet();
        ModuleUtilCore.collectModulesDependsOn((Module)module, dependents);
        for (Module networkModule : dependents) {
            if (visited.contains(networkModule)) continue;
            visited.add(networkModule);
            toVisit.add(networkModule);
        }
        for (Module visitModule : toVisit) {
            SpringEventModelUtils.collectModuleNetwork(visited, visitModule);
        }
    }

    @NotNull
    private static List<PublishEventPointDescriptor> getLibraryPublishPoints(@NotNull Project project) {
        if (project == null) {
            SpringEventModelUtils.$$$reportNull$$$0(9);
        }
        List list = (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            GlobalSearchScope scope = ProjectScope.getLibrariesScope((Project)project);
            List<PublishEventPointDescriptor> cacheValue = SpringEventModelUtils.findEventPublishingPoints(project, null, scope);
            return CachedValueProvider.Result.createSingleDependency(cacheValue, (Object)ProjectRootManager.getInstance((Project)project));
        });
        if (list == null) {
            SpringEventModelUtils.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private static List<PublishEventPointDescriptor> findEventPublishingPoints(@NotNull Project project, @Nullable Module module, GlobalSearchScope scope) {
        if (project == null) {
            SpringEventModelUtils.$$$reportNull$$$0(11);
        }
        LinkedHashSet<PublishEventPointDescriptor> descriptors = new LinkedHashSet<PublishEventPointDescriptor>();
        for (PsiMethod publishEventMethod : SpringEventModelUtils.getPublishEventMethods(project, module)) {
            descriptors.addAll(SpringEventModelUtils.searchPublishPoints(publishEventMethod, (SearchScope)scope));
        }
        descriptors.addAll(SpringEventModelUtils.searchEventListenerDescriptors(project, module));
        return descriptors.isEmpty() ? List.of() : new ArrayList(descriptors);
    }

    @NotNull
    private static List<PsiMethod> getPublishEventMethods(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            SpringEventModelUtils.$$$reportNull$$$0(12);
        }
        if (module != null) {
            PsiClass eventPublisherClass = SpringCommonUtils.findLibraryClass(module, "org.springframework.context.ApplicationEventPublisher");
            if (eventPublisherClass != null) {
                List<PsiMethod> list = List.of(eventPublisherClass.findMethodsByName(PUBLISH_EVENT_METHOD, false));
                if (list == null) {
                    SpringEventModelUtils.$$$reportNull$$$0(13);
                }
                return list;
            }
            List<PsiMethod> list = List.of();
            if (list == null) {
                SpringEventModelUtils.$$$reportNull$$$0(14);
            }
            return list;
        }
        JavaPsiFacade javaPsi = JavaPsiFacade.getInstance((Project)project);
        PsiClass[] classes = javaPsi.findClasses("org.springframework.context.ApplicationEventPublisher", GlobalSearchScope.allScope((Project)project));
        if (classes.length == 0) {
            List<PsiMethod> list = List.of();
            if (list == null) {
                SpringEventModelUtils.$$$reportNull$$$0(15);
            }
            return list;
        }
        List<PsiMethod> list = Arrays.stream(classes).flatMap(c -> Arrays.stream(c.findMethodsByName(PUBLISH_EVENT_METHOD, false))).collect(Collectors.toList());
        if (list == null) {
            SpringEventModelUtils.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public static List<SpringEventListener> getEventListeners(@NotNull Project project, @Nullable Module module, @NotNull PsiType publishType) {
        if (project == null) {
            SpringEventModelUtils.$$$reportNull$$$0(17);
        }
        if (publishType == null) {
            SpringEventModelUtils.$$$reportNull$$$0(18);
        }
        if (!publishType.isValid()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SpringEventModelUtils.$$$reportNull$$$0(19);
            }
            return list;
        }
        List list = ContainerUtil.filter(SpringEventModelUtils.getEventListeners(project, module), listener2 -> {
            for (PsiType eventType : SpringEventModelUtils.getEventListenerHandledType(listener2)) {
                if (!eventType.isAssignableFrom(publishType)) continue;
                return true;
            }
            return false;
        });
        if (list == null) {
            SpringEventModelUtils.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    private static List<SpringEventListener> getEventListeners(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            SpringEventModelUtils.$$$reportNull$$$0(21);
        }
        if (module != null) {
            List list = (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
                SmartList listeners = new SmartList();
                SpringEventModelUtils.findModuleEventListeners(module, (List<SpringEventListener>)listeners, SpringEventModelUtils.moduleNetworkScope(module), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
                return CachedValueProvider.Result.create((Object)listeners, (Object[])new Object[]{UastModificationTracker.getInstance((Project)module.getProject()), ProjectRootManager.getInstance((Project)module.getProject())});
            });
            if (list == null) {
                SpringEventModelUtils.$$$reportNull$$$0(22);
            }
            return list;
        }
        List<SpringEventListener> list = SpringEventModelUtils.getProjectEventListeners(project);
        if (list == null) {
            SpringEventModelUtils.$$$reportNull$$$0(23);
        }
        return list;
    }

    private static List<SpringEventListener> getProjectEventListeners(@NotNull Project project) {
        if (project == null) {
            SpringEventModelUtils.$$$reportNull$$$0(24);
        }
        return (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            SmartList listeners = new SmartList();
            for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
                if (!SpringLibraryUtil.hasSpringLibrary(m) || !SpringCommonUtils.hasSpringFacet(m) || m.getName().endsWith(".test")) continue;
                SpringEventModelUtils.findModuleEventListeners(m, (List<SpringEventListener>)listeners, GlobalSearchScope.moduleScope((Module)m), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)m));
            }
            return CachedValueProvider.Result.create((Object)listeners, (Object[])new Object[]{UastModificationTracker.getInstance((Project)project), ProjectRootManager.getInstance((Project)project)});
        });
    }

    private static void findModuleEventListeners(@NotNull Module module, @NotNull List<SpringEventListener> result, @NotNull GlobalSearchScope scope, @NotNull GlobalSearchScope apiScope) {
        if (module == null) {
            SpringEventModelUtils.$$$reportNull$$$0(25);
        }
        if (result == null) {
            SpringEventModelUtils.$$$reportNull$$$0(26);
        }
        if (scope == null) {
            SpringEventModelUtils.$$$reportNull$$$0(27);
        }
        if (apiScope == null) {
            SpringEventModelUtils.$$$reportNull$$$0(28);
        }
        JamService jamService = JamService.getJamService((Project)module.getProject());
        result.addAll(jamService.getJamMethodElements(SpringJamEventListener.SEM_KEY, "org.springframework.context.event.EventListener", scope));
        JamAnnotationTypeUtil annotationTypeUtil = JamAnnotationTypeUtil.getInstance(module);
        List customAnnotations = ContainerUtil.mapNotNull(annotationTypeUtil.getAnnotationTypesWithChildren("org.springframework.context.event.EventListener"), PsiClass::getQualifiedName);
        for (String annotation : customAnnotations) {
            result.addAll(jamService.getJamMethodElements(CustomSpringEventListener.JAM_KEY, annotation, scope));
        }
        SpringEventModelUtils.collectEventListenerBeans(module, scope, apiScope, result);
    }

    private static void collectEventListenerBeans(@NotNull Module module, @NotNull GlobalSearchScope scope, @NotNull GlobalSearchScope apiScope, @NotNull List<SpringEventListener> result) {
        if (module == null) {
            SpringEventModelUtils.$$$reportNull$$$0(29);
        }
        if (scope == null) {
            SpringEventModelUtils.$$$reportNull$$$0(30);
        }
        if (apiScope == null) {
            SpringEventModelUtils.$$$reportNull$$$0(31);
        }
        if (result == null) {
            SpringEventModelUtils.$$$reportNull$$$0(32);
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        for (PsiClass listenerInterface : javaPsiFacade.findClasses("org.springframework.context.ApplicationListener", apiScope)) {
            PsiClass applicationEventClass = javaPsiFacade.findClass("org.springframework.context.ApplicationEvent", apiScope);
            Query entries = ClassInheritorsSearch.search((PsiClass)listenerInterface, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false);
            for (PsiClass entry : entries) {
                PsiMethod[] onEventMethods;
                if (!SpringCommonUtils.isSpringBeanCandidateClass(entry)) continue;
                for (PsiMethod method : onEventMethods = entry.findMethodsByName("onApplicationEvent", false)) {
                    SpringBeanEventListener beanEventListener;
                    if (!SpringEventModelUtils.isValidReceiverMethod(method, applicationEventClass) || (beanEventListener = (SpringBeanEventListener)SpringBeanEventListener.METHOD_META.getJamElement((PsiModifierListOwner)method)) == null) continue;
                    result.add(beanEventListener);
                }
            }
        }
    }

    private static boolean isValidReceiverMethod(PsiMethod method, PsiClass applicationEventClass) {
        PsiClass resolvedClass;
        String parameterClassName;
        if (!PsiType.VOID.equals((Object)method.getReturnType()) || method.getParameterList().getParametersCount() != 1) {
            return false;
        }
        PsiParameter parameter = method.getParameterList().getParameters()[0];
        return !(parameter.getType() instanceof PsiClassType) || (parameterClassName = ((PsiClassType)parameter.getType()).getClassName()) != null && !parameterClassName.equals("ApplicationEvent") || (resolvedClass = ((PsiClassType)parameter.getType()).resolve()) != null && !resolvedClass.isEquivalentTo((PsiElement)applicationEventClass);
    }

    @NotNull
    private static Collection<PublishEventPointDescriptor> searchEventListenerDescriptors(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            SpringEventModelUtils.$$$reportNull$$$0(33);
        }
        if (module == null) {
            List<PublishEventPointDescriptor> list = List.of();
            if (list == null) {
                SpringEventModelUtils.$$$reportNull$$$0(34);
            }
            return list;
        }
        ArrayList<PublishEventPointDescriptor> descriptors = new ArrayList<PublishEventPointDescriptor>();
        for (SpringEventListener listener2 : SpringEventModelUtils.getEventListeners(project, module)) {
            PsiType returnType;
            PsiMethod psiMethod = listener2.getPsiElement();
            if (psiMethod == null || (returnType = psiMethod.getReturnType()) == null || PsiType.VOID.equals((Object)returnType)) continue;
            descriptors.add(PublishEventPointDescriptor.create(psiMethod, module));
        }
        ArrayList<PublishEventPointDescriptor> arrayList = descriptors;
        if (arrayList == null) {
            SpringEventModelUtils.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    @NotNull
    private static Collection<PublishEventPointDescriptor> searchPublishPoints(@NotNull PsiMethod publishEventMethod, @NotNull SearchScope searchScope) {
        if (publishEventMethod == null) {
            SpringEventModelUtils.$$$reportNull$$$0(36);
        }
        if (searchScope == null) {
            SpringEventModelUtils.$$$reportNull$$$0(37);
        }
        ArrayList<PublishEventPointDescriptor> result = new ArrayList<PublishEventPointDescriptor>();
        MethodReferencesSearch.search((PsiMethod)publishEventMethod, (SearchScope)searchScope, (boolean)true).forEach(psiReference -> {
            List arguments;
            UElement expression = UastContextKt.toUElement((PsiElement)psiReference.getElement());
            UCallExpression callExpression = UastUtils.getUCallExpression((UElement)expression);
            if (callExpression != null && (arguments = callExpression.getValueArguments()).size() == 1) {
                result.add(PublishEventPointDescriptor.create((UExpression)arguments.get(0)));
            }
            return true;
        });
        ArrayList<PublishEventPointDescriptor> arrayList = result;
        if (arrayList == null) {
            SpringEventModelUtils.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<PsiType> getEventListenerHandledType(@NotNull SpringEventListener eventListener) {
        PsiMethod psiMethod;
        if (eventListener == null) {
            SpringEventModelUtils.$$$reportNull$$$0(39);
        }
        if ((psiMethod = eventListener.getPsiElement()) == null) {
            List<PsiType> list = List.of();
            if (list == null) {
                SpringEventModelUtils.$$$reportNull$$$0(40);
            }
            return list;
        }
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        if (parameters.length == 1) {
            Set<PsiType> set = Collections.singleton(parameters[0].getType());
            if (set == null) {
                SpringEventModelUtils.$$$reportNull$$$0(41);
            }
            return set;
        }
        if (parameters.length == 0) {
            List list = ContainerUtil.mapNotNull(eventListener.getEventListenerClasses(), PsiTypesUtil::getClassType);
            if (list == null) {
                SpringEventModelUtils.$$$reportNull$$$0(42);
            }
            return list;
        }
        List<PsiType> list = List.of();
        if (list == null) {
            SpringEventModelUtils.$$$reportNull$$$0(43);
        }
        return list;
    }

    public static boolean isPublishEventExpression(@NotNull UCallExpression psiElement) {
        PsiMethod element;
        if (psiElement == null) {
            SpringEventModelUtils.$$$reportNull$$$0(44);
        }
        if (PUBLISH_EVENT_METHOD.equals(psiElement.getMethodName()) && (element = psiElement.resolve()) != null) {
            PsiClass containingClass = element.getContainingClass();
            return containingClass != null && InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.springframework.context.ApplicationEventPublisher");
        }
        return false;
    }

    @Nullable
    public static PsiType getEventType(@Nullable PsiType methodReturnType, @Nullable Module module) {
        PsiClassType returnType;
        PsiType[] parameters;
        if (methodReturnType instanceof PsiArrayType) {
            return ((PsiArrayType)methodReturnType).getComponentType();
        }
        if (methodReturnType instanceof PsiClassType && (parameters = (returnType = (PsiClassType)methodReturnType).getParameters()).length == 1 && SpringEventModelUtils.isEventWrapperType(returnType.resolve(), module)) {
            return parameters[0];
        }
        return methodReturnType;
    }

    private static boolean isEventWrapperType(@Nullable PsiClass resolvedClass, @Nullable Module module) {
        if (resolvedClass == null) {
            return false;
        }
        String qualifiedName = resolvedClass.getQualifiedName();
        return SpringConstants.EVENT_WRAPPER_CLASSES.contains(qualifiedName) || (SpringConstants.REACTIVE_EVENT_WRAPPER_CLASSES.contains(qualifiedName) || ReactorConstants.REACTIVE_EVENT_WRAPPER_CLASSES.contains(qualifiedName)) && SpringLibraryUtil.isAtLeastVersion(module, SpringLibraryUtil.SpringVersion.V_5_2) && JavaLibraryUtils.hasLibraryClass((Module)module, (String)"reactor.core.publisher.Flux");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handledType";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/events/jam/SpringEventModelUtils";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 17: 
            case 21: 
            case 24: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishType";
                break;
            }
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apiScope";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishEventMethod";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventListener";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/events/jam/SpringEventModelUtils";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublishPoints";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleNetworkScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryPublishPoints";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublishEventMethods";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventListeners";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "searchEventListenerDescriptors";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "searchPublishPoints";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventListenerHandledType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPublishPoints";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "moduleNetworkScope";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryPublishPoints";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findEventPublishingPoints";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPublishEventMethods";
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getEventListeners";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getProjectEventListeners";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findModuleEventListeners";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "collectEventListenerBeans";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "searchEventListenerDescriptors";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "searchPublishPoints";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getEventListenerHandledType";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isPublishEventExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

