/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.events.annotator;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.model.events.beans.PublishEventPointDescriptor;
import com.intellij.spring.model.events.jam.SpringEventListener;
import com.intellij.spring.model.events.jam.SpringEventModelUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastContextKt;

final class SpringEventListenerAnnotator
extends RelatedItemLineMarkerProvider {
    private static final NotNullFunction<PublishEventPointDescriptor, Collection<? extends PsiElement>> PUBLISH_EVENT_CONVERTOR = descriptor -> ContainerUtil.createMaybeSingletonList((Object)descriptor.getNavigatableElement());
    private static final NotNullFunction<SpringEventListener, Collection<? extends PsiElement>> EVENT_LISTENER_CONVERTOR = descriptor -> ContainerUtil.createMaybeSingletonList((Object)descriptor.getPsiElement());

    SpringEventListenerAnnotator() {
    }

    public String getId() {
        return "SpringEventListenerAnnotator";
    }

    public String getName() {
        return SpringBundle.message("spring.core.event.listener.annotator.name", new Object[0]);
    }

    public Icon getIcon() {
        return SpringApiIcons.Listener;
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(0);
        }
        if (result == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(1);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null || !SpringCommonUtils.hasSpringFacets(psiElement.getProject()) || !SpringLibraryUtil.hasSpringLibrary(psiElement.getProject())) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module != null && !SpringLibraryUtil.isAtLeastVersion(module, SpringLibraryUtil.SpringVersion.V_4_2)) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        UElement uElement;
        if (psiElement == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(2);
        }
        if (result == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(3);
        }
        if ((uElement = UastContextKt.toUElementOfExpectedTypes((PsiElement)psiElement, (Class[])new Class[]{UMethod.class, UCallExpression.class, UQualifiedReferenceExpression.class})) == null) {
            return;
        }
        if (uElement instanceof UMethod) {
            UMethod uMethod = (UMethod)uElement;
            PsiMethod psiMethod = (PsiMethod)UElementKt.getAsJavaPsiElement((UElement)uMethod, PsiMethod.class);
            if (psiMethod == null) {
                return;
            }
            if (!psiMethod.hasModifierProperty("public") || psiMethod.hasModifierProperty("static") || psiMethod.isConstructor()) {
                return;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            if (module == null) {
                return;
            }
            SemService semService = SemService.getSemService((Project)psiElement.getProject());
            for (SpringEventListener eventListener : semService.getSemElements(SpringEventListener.EVENT_LISTENER_ROOT_JAM_KEY, (PsiElement)psiMethod)) {
                PsiElement identifier;
                PsiType returnType;
                PsiAnnotation psiAnnotation = eventListener.getAnnotation();
                if (psiAnnotation != null) {
                    SpringEventListenerAnnotator.annotateEventListenerMethod(() -> SpringEventListenerAnnotator.findPublishPoints(module, eventListener), uMethod, result);
                } else if (eventListener.getPsiElement() != null && "onApplicationEvent".equals(psiMethod.getName())) {
                    SpringEventListenerAnnotator.annotateOnApplicationEventMethod(() -> SpringEventListenerAnnotator.findPublishPoints(module, eventListener), uMethod, result);
                }
                if ((returnType = SpringEventModelUtils.getEventType(psiMethod.getReturnType(), module)) == null || PsiType.VOID.equals((Object)returnType) || (identifier = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor())) == null) continue;
                SpringEventListenerAnnotator.annotatePublishPoints(module.getProject(), module, result, returnType, identifier);
            }
        } else {
            UCallExpression callExpression = (UCallExpression)UastContextKt.toUElement((PsiElement)psiElement, UCallExpression.class);
            if (callExpression != null && callExpression.getSourcePsi() == psiElement && SpringEventModelUtils.isPublishEventExpression(callExpression)) {
                SpringEventListenerAnnotator.annotateMethodCallExpression(callExpression, result);
            }
        }
    }

    @NotNull
    private static Collection<PublishEventPointDescriptor> findPublishPoints(Module module, SpringEventListener eventListener) {
        if (!eventListener.isValid()) {
            List<PublishEventPointDescriptor> list = Collections.emptyList();
            if (list == null) {
                SpringEventListenerAnnotator.$$$reportNull$$$0(4);
            }
            return list;
        }
        LinkedHashSet<PublishEventPointDescriptor> points = new LinkedHashSet<PublishEventPointDescriptor>();
        for (PsiType handledType : SpringEventModelUtils.getEventListenerHandledType(eventListener)) {
            points.addAll(SpringEventModelUtils.getPublishPoints(module, handledType));
        }
        LinkedHashSet<PublishEventPointDescriptor> linkedHashSet = points;
        if (linkedHashSet == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(5);
        }
        return linkedHashSet;
    }

    private static void annotateOnApplicationEventMethod(@NotNull Supplier<Collection<PublishEventPointDescriptor>> supplier, @NotNull UMethod uMethod, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        PsiElement identifier;
        if (supplier == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(6);
        }
        if (uMethod == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(7);
        }
        if (result == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(8);
        }
        if ((identifier = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor())) == null) {
            return;
        }
        result.add(SpringEventListenerAnnotator.createEventListenerMarker(supplier, identifier));
    }

    private static void annotateEventListenerMethod(@NotNull Supplier<Collection<PublishEventPointDescriptor>> supplier, @NotNull UMethod uMethod, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        PsiElement identifier;
        if (supplier == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(9);
        }
        if (uMethod == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(10);
        }
        if (result == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(11);
        }
        if ((identifier = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor())) == null) {
            return;
        }
        result.add(SpringEventListenerAnnotator.createEventListenerMarker(supplier, identifier));
    }

    private static RelatedItemLineMarkerInfo<?> createEventListenerMarker(@NotNull Supplier<Collection<PublishEventPointDescriptor>> supplier, @NotNull PsiElement identifier) {
        if (supplier == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(12);
        }
        if (identifier == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(13);
        }
        SpringGutterIconBuilder<PublishEventPointDescriptor> builder = SpringGutterIconBuilder.createBuilder(SpringApiIcons.Gutter.Publisher, PUBLISH_EVENT_CONVERTOR, null);
        builder.setTargets(NotNullLazyValue.lazy(supplier)).setPopupTitle(SpringBundle.message("spring.event.publisher.choose.title", new Object[0])).setTooltipText(SpringBundle.message("spring.event.publisher.tooltip.text", new Object[0])).setEmptyPopupText(SpringBundle.message("spring.event.publisher.empty.tooltip.text", new Object[0])).setCellRenderer((PsiElementListCellRenderer)SpringEventListenerAnnotator.getPublishEventRenderer());
        return builder.createSpringRelatedMergeableLineMarkerInfo(identifier);
    }

    @NotNull
    private static DefaultPsiElementCellRenderer getPublishEventRenderer() {
        return new DefaultPsiElementCellRenderer(){

            protected Icon getIcon(PsiElement element) {
                if (UastContextKt.toUElement((PsiElement)element, UCallExpression.class) != null) {
                    return SpringApiIcons.Gutter.Publisher;
                }
                return super.getIcon(element);
            }

            public String getContainerText(PsiElement element, String name) {
                PsiMethod methodJavaPsi;
                PsiClass containingClass;
                UMethod uMethod;
                if (UastContextKt.toUElement((PsiElement)element, UCallExpression.class) != null && (uMethod = (UMethod)UastContextKt.getUastParentOfType((PsiElement)element, UMethod.class)) != null && (containingClass = (methodJavaPsi = uMethod.getJavaPsi()).getContainingClass()) != null) {
                    return SymbolPresentationUtil.getSymbolPresentableText((PsiElement)containingClass) + "." + SymbolPresentationUtil.getSymbolPresentableText((PsiElement)methodJavaPsi);
                }
                return super.getContainerText(element, name);
            }
        };
    }

    @NotNull
    private static DefaultPsiElementCellRenderer getEventListenerRenderer() {
        return new DefaultPsiElementCellRenderer(){

            protected Icon getIcon(PsiElement element) {
                UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)element, UMethod.class);
                if (uMethod != null && uMethod.getSourcePsi() != null) {
                    return super.getIcon(uMethod.getSourcePsi());
                }
                return super.getIcon(element);
            }
        };
    }

    private static void annotateMethodCallExpression(@NotNull UCallExpression expression, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        PsiType publishedType;
        List expressions;
        if (expression == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(14);
        }
        if (result == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(15);
        }
        if ((expressions = expression.getValueArguments()).size() == 1 && (publishedType = ((UExpression)expressions.get(0)).getExpressionType()) != null) {
            PsiElement sourcePsi = expression.getSourcePsi();
            if (sourcePsi == null) {
                return;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourcePsi);
            PsiElement identifier = UElementKt.getSourcePsiElement((UElement)expression.getMethodIdentifier());
            if (identifier != null) {
                SpringEventListenerAnnotator.annotatePublishPoints(sourcePsi.getProject(), module, result, publishedType, PsiTreeUtil.getDeepestFirst((PsiElement)identifier));
            }
        }
    }

    private static void annotatePublishPoints(@NotNull Project project, @Nullable Module module, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, @NotNull PsiType publishedType, @NotNull PsiElement element) {
        if (project == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(16);
        }
        if (result == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(17);
        }
        if (publishedType == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(18);
        }
        if (element == null) {
            SpringEventListenerAnnotator.$$$reportNull$$$0(19);
        }
        SpringGutterIconBuilder<SpringEventListener> builder = SpringGutterIconBuilder.createBuilder(SpringApiIcons.Gutter.Listener, EVENT_LISTENER_CONVERTOR, null);
        builder.setTargets(NotNullLazyValue.lazy(() -> SpringEventModelUtils.getEventListeners(project, module, publishedType))).setPopupTitle(SpringBundle.message("spring.event.listener.choose.title", new Object[0])).setTooltipText(SpringBundle.message("spring.event.listener.tooltip.text", new Object[0])).setEmptyPopupText(SpringBundle.message("spring.event.listener.empty.tooltip.text", new Object[0])).setCellRenderer((PsiElementListCellRenderer)SpringEventListenerAnnotator.getEventListenerRenderer());
        result.add(builder.createSpringRelatedMergeableLineMarkerInfo(element));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 11: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishedType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/events/annotator/SpringEventListenerAnnotator";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findPublishPoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "annotateOnApplicationEventMethod";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "annotateEventListenerMethod";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createEventListenerMarker";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "annotateMethodCallExpression";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "annotatePublishPoints";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

