/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters.fixes.bean;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.converters.fixes.bean.SpringBeanResolveQuickFixProvider;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.custom.ParseCustomBeanIntention;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ParseCustomBeanQuickFixProvider
implements SpringBeanResolveQuickFixProvider {
    ParseCustomBeanQuickFixProvider() {
    }

    @Override
    @NotNull
    public List<LocalQuickFix> getQuickFixes(ConvertContext context, @NotNull Beans beans, @Nullable String beanId, List<PsiClassType> requiredClasses) {
        String parseBeanId;
        if (beans == null) {
            ParseCustomBeanQuickFixProvider.$$$reportNull$$$0(0);
        }
        GenericDomValue beanPointer = (GenericDomValue)context.getInvocationElement();
        String string = parseBeanId = beanId != null ? beanId : beanPointer.getStringValue();
        if (StringUtil.isEmptyOrSpaces((String)parseBeanId)) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                ParseCustomBeanQuickFixProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        XmlFile file = context.getFile();
        SpringModel springModel = SpringManager.getInstance(file.getProject()).getSpringModelByFile((PsiFile)file);
        if (springModel == null) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                ParseCustomBeanQuickFixProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        Collection<XmlTag> tags = SpringModelVisitorUtils.getCustomBeanCandidates(springModel, parseBeanId);
        if (tags.isEmpty()) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                ParseCustomBeanQuickFixProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<LocalQuickFix> list = Collections.singletonList(new TryParsingCustomBeansFix(tags));
        if (list == null) {
            ParseCustomBeanQuickFixProvider.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/fixes/bean/ParseCustomBeanQuickFixProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/fixes/bean/ParseCustomBeanQuickFixProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TryParsingCustomBeansFix
    implements LocalQuickFix,
    IntentionAction {
        private final Collection<XmlTag> myTags;

        private TryParsingCustomBeansFix(Collection<XmlTag> tags) {
            this.myTags = tags;
        }

        @NotNull
        public String getText() {
            String string = this.getName();
            if (string == null) {
                TryParsingCustomBeansFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                TryParsingCustomBeansFix.$$$reportNull$$$0(1);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                TryParsingCustomBeansFix.$$$reportNull$$$0(2);
            }
            ParseCustomBeanIntention.invokeCustomBeanParsers(project, this.myTags);
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("try.parsing.custom.beans", new Object[0]);
            if (string == null) {
                TryParsingCustomBeansFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                TryParsingCustomBeansFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                TryParsingCustomBeansFix.$$$reportNull$$$0(5);
            }
            throw new UnsupportedOperationException("Method applyFix is not yet implemented in " + this.getClass().getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/converters/fixes/bean/ParseCustomBeanQuickFixProvider$TryParsingCustomBeansFix";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/converters/fixes/bean/ParseCustomBeanQuickFixProvider$TryParsingCustomBeansFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

