/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.spring.SpringApiBundle;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternFileReferenceSet
extends FileReferenceSet {
    private final String myTemplateName;

    public PatternFileReferenceSet(String str, @NotNull PsiElement element, int offset) {
        if (element == null) {
            PatternFileReferenceSet.$$$reportNull$$$0(0);
        }
        this(str, element, offset, true);
    }

    public PatternFileReferenceSet(@NotNull String str, @NotNull PsiElement element, int offset, boolean endingSlashNotAllowed) {
        if (str == null) {
            PatternFileReferenceSet.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PatternFileReferenceSet.$$$reportNull$$$0(2);
        }
        this(str, element, offset, endingSlashNotAllowed, null);
    }

    public PatternFileReferenceSet(@NotNull String str, @NotNull PsiElement element, int offset, boolean endingSlashNotAllowed, @Nullable String templateName) {
        if (str == null) {
            PatternFileReferenceSet.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PatternFileReferenceSet.$$$reportNull$$$0(4);
        }
        super(str, element, offset, null, true, endingSlashNotAllowed, null, false);
        this.myTemplateName = templateName;
        this.reparse();
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        if (!PatternFileReferenceSet.isAntPattern(text)) {
            return new FileReference(this, range, index, text){

                @Nullable
                public String getNewFileTemplateName() {
                    return PatternFileReferenceSet.this.myTemplateName;
                }
            };
        }
        return new PatternFileReference(this, range, index, text, (Condition<? super PsiFileSystemItem>)this.getReferenceCompletionFilter());
    }

    public static boolean isAntPattern(String str) {
        return str.indexOf(42) != -1 || str.indexOf(63) != -1;
    }

    protected boolean isSoft() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "str";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/model/converters/PatternFileReferenceSet";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PatternFileReference
    extends FileReference {
        private final Condition<? super PsiFileSystemItem> myFilter;

        public PatternFileReference(FileReferenceSet referenceSet, TextRange range, int index, String text, Condition<? super PsiFileSystemItem> filter) {
            super(referenceSet, range, index, text);
            this.myFilter = filter;
        }

        protected void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, @NotNull Collection<ResolveResult> result, boolean caseSensitive) {
            if (text == null) {
                PatternFileReference.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PatternFileReference.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PatternFileReference.$$$reportNull$$$0(2);
            }
            if (text.equals("**")) {
                PatternFileReference.addDirectoryResolves((PsiElement)context, result);
            } else {
                PsiElement[] psiElements;
                String patternText = FileUtil.convertAntToRegexp((String)text);
                Pattern pattern = Pattern.compile(patternText);
                for (PsiElement psiElement : psiElements = context.getChildren()) {
                    boolean acceptFile;
                    PsiFileSystemItem psiFileSystemItem;
                    if (!(psiElement instanceof PsiFileSystemItem) || !pattern.matcher((psiFileSystemItem = (PsiFileSystemItem)psiElement).getName()).matches()) continue;
                    boolean bl = acceptFile = psiFileSystemItem.isDirectory() || this.myFilter.value((Object)PatternFileReference.getOriginalFile((PsiFileSystemItem)psiFileSystemItem));
                    if (!acceptFile) continue;
                    result.add((ResolveResult)new PsiElementResolveResult(psiElement));
                }
            }
        }

        private static void addDirectoryResolves(PsiElement context, final Collection<? super ResolveResult> result) {
            if (!(context instanceof PsiFileSystemItem)) {
                return;
            }
            PsiFileSystemItem fileSystemItem = (PsiFileSystemItem)context;
            if (fileSystemItem.isDirectory()) {
                result.add((ResolveResult)new PsiElementResolveResult(context));
                fileSystemItem.processChildren((PsiElementProcessor)new PsiFileSystemItemProcessor(){

                    public boolean acceptItem(@NotNull String name, boolean isDirectory) {
                        if (name == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return isDirectory;
                    }

                    public boolean execute(@NotNull PsiFileSystemItem element) {
                        VirtualFile virtualFile;
                        if (element == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if ((virtualFile = element.getVirtualFile()) != null) {
                            PatternFileReference.addDirectoryResolves((PsiElement)element.getManager().findDirectory(virtualFile), result);
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "name";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "element";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/spring/model/converters/PatternFileReferenceSet$PatternFileReference$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "acceptItem";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "execute";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        }

        @NotNull
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getUnresolvedMessagePattern() {
            String string = SpringApiBundle.message("pattern.fileset.no.matching.files", new Object[0]);
            if (string == null) {
                PatternFileReference.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/converters/PatternFileReferenceSet$PatternFileReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/converters/PatternFileReferenceSet$PatternFileReference";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "innerResolveInContext";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

