/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.generate;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.MacroFactory;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringTemplateBuilder {
    private final Template myTemplate;
    private final Project myProject;
    private int myCount;
    private static final Set<String> myConvertableTypes = new HashSet<String>();

    public SpringTemplateBuilder(Project project) {
        this.myProject = project;
        this.myTemplate = TemplateManager.getInstance((Project)project).createTemplate("", "");
        this.myTemplate.setToReformat(true);
    }

    private boolean createValue(PsiType type, CommonSpringModel model) {
        if (type instanceof PsiClassType) {
            if ("java.lang.Object".equals(type.getCanonicalText())) {
                this.createAttr("value");
                return false;
            }
            PsiClassType psiClassType = (PsiClassType)type;
            if (InheritanceUtil.isInheritor((PsiType)psiClassType, (String)"java.util.Properties")) {
                this.createProperties();
                return true;
            }
            if (InheritanceUtil.isInheritor((PsiType)psiClassType, (String)"java.util.Map")) {
                this.createMap();
                return true;
            }
            if (InheritanceUtil.isInheritor((PsiType)psiClassType, (String)"java.util.Set")) {
                this.createCollection("set");
                return true;
            }
            if (InheritanceUtil.isInheritor((PsiType)psiClassType, (String)"java.util.Collection")) {
                this.createCollection("list");
                return true;
            }
            this.createAttr(psiClassType, model, false);
            return false;
        }
        if (type instanceof PsiArrayType) {
            this.createCollection("list");
            return true;
        }
        this.createAttr("value");
        return false;
    }

    public void createValueAndClose(PsiType type, CommonSpringModel model, @NonNls String tagName) {
        boolean closingTagNeeded = this.createValue(type, model);
        if (closingTagNeeded) {
            this.addTextSegment("</");
            this.addVariableSegment("NS_PREFIX");
            this.addTextSegment(tagName + ">");
        } else {
            this.addTextSegment("/>");
        }
    }

    private void createAttr(PsiClassType type, CommonSpringModel model, boolean key) {
        boolean canBeReferenced;
        boolean bl = canBeReferenced = !SpringBeanCoreUtils.getBeansByType((PsiType)type, model).isEmpty();
        if (canBeReferenced || !SpringTemplateBuilder.isConvertable((PsiType)type)) {
            if (key) {
                this.createAttr("key-ref");
            } else {
                this.createAttr("ref", true);
            }
        } else {
            this.createAttr(key ? "key-value" : "value");
        }
    }

    private static boolean isConvertable(PsiType type) {
        return myConvertableTypes.contains(type.getCanonicalText());
    }

    private void createMap() {
        this.addTextSegment("><");
        this.addVariableSegment("NS_PREFIX");
        this.addTextSegment("map>\n<");
        this.addVariableSegment("NS_PREFIX");
        this.addTextSegment("entry");
        this.createAttr("key");
        this.createAttr("value");
        this.addTextSegment("/>\n</");
        this.addVariableSegment("NS_PREFIX");
        this.addTextSegment("map>\n");
    }

    private void createProperties() {
        this.addTextSegment(">\n<");
        this.addVariableSegment("NS_PREFIX");
        this.addTextSegment("props>\n<");
        this.addVariableSegment("NS_PREFIX");
        this.addTextSegment("prop key=\"");
        MacroCallNode node = new MacroCallNode(MacroFactory.createMacro((String)"complete"));
        this.myTemplate.addVariable("PROP_KEY", (Expression)node, (Expression)node, true);
        this.addTextSegment("\">");
        this.myTemplate.addVariable("PROP_VALUE", (Expression)node, (Expression)node, true);
        this.addTextSegment("</");
        this.addVariableSegment("NS_PREFIX");
        this.addTextSegment("prop>\n</");
        this.addVariableSegment("NS_PREFIX");
        this.addTextSegment("props>");
    }

    public void createCollection(String name) {
        this.addTextSegment(">\n<");
        this.addVariableSegment("NS_PREFIX");
        this.addTextSegment(name + ">\n");
        this.addTextSegment("<");
        this.addVariableSegment("NS_PREFIX");
        this.addTextSegment("value>");
        MacroCallNode node = new MacroCallNode(MacroFactory.createMacro((String)"complete"));
        this.myTemplate.addVariable(name + this.myCount++, (Expression)node, (Expression)node, true);
        this.addTextSegment("</");
        this.addVariableSegment("NS_PREFIX");
        this.addTextSegment("value>\n");
        this.addTextSegment("</");
        this.addVariableSegment("NS_PREFIX");
        this.addTextSegment(name + ">\n");
    }

    private void createAttr(String name) {
        this.createAttr(name, false);
    }

    private void createAttr(String name, boolean isSmartCompletion) {
        this.addTextSegment(" " + name + "=\"");
        MacroCallNode node = new MacroCallNode(MacroFactory.createMacro((String)(isSmartCompletion ? "completeSmart" : "complete")));
        this.myTemplate.addVariable(name + this.myCount++, (Expression)node, (Expression)node, true);
        this.addTextSegment("\"");
    }

    public void addTextSegment(@NonNls String s) {
        this.myTemplate.addTextSegment(s);
    }

    public void addVariableSegment(@NonNls String s) {
        this.myTemplate.addVariableSegment(s);
    }

    public void startTemplate(Editor editor) {
        this.startTemplate(editor, this.getPredefinedMap());
    }

    @NotNull
    protected HashMap<String, String> getPredefinedMap() {
        return new HashMap<String, String>();
    }

    public void startTemplate(Editor editor, @NotNull Map<String, String> predefinedVarValues) {
        if (predefinedVarValues == null) {
            SpringTemplateBuilder.$$$reportNull$$$0(0);
        }
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("NS_PREFIX", "beans:");
        TemplateManager.getInstance((Project)this.myProject).startTemplate(editor, this.myTemplate, true, predefinedVarValues, null);
    }

    public static void preparePlace(Editor editor, Project project, DomElement element) {
        DomElement copy = element.createStableCopy();
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        XmlTag tag = copy.getXmlTag();
        assert (tag != null);
        int offset = tag.getTextOffset();
        editor.getDocument().deleteString(offset, tag.getTextRange().getEndOffset());
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        editor.getCaretModel().moveToOffset(offset);
    }

    public static Editor getEditor(ProblemDescriptor descriptor) {
        PsiFile psiFile = descriptor.getPsiElement().getContainingFile();
        Project project = psiFile.getProject();
        VirtualFile virtualFile = psiFile.getVirtualFile();
        assert (virtualFile != null);
        Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile, 0), false);
        assert (editor != null);
        return editor;
    }

    static {
        Object[] classes = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.Character", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.math.BigDecimal", "java.math.BigInteger", "java.lang.Class", "org.springframework.core.io.Resource", "java.net.URL", "java.io.File", "java.io.InputStream", "java.util.Locale", "java.util.Properties"};
        ContainerUtil.addAll(myConvertableTypes, (Object[])classes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predefinedVarValues", "com/intellij/spring/model/actions/generate/SpringTemplateBuilder", "startTemplate"));
    }
}

