/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.DerivedSpringBeanPointer;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBaseBeanPointer<T extends CommonSpringBean>
implements SpringBeanPointer<T> {
    private final String myName;
    private final Project myProject;
    private CachedValue<PsiType[]> effectiveTypesValue;
    private final NotNullLazyValue<String[]> myAliases;

    protected SpringBaseBeanPointer(@Nullable String name, @NotNull Project project) {
        if (project == null) {
            SpringBaseBeanPointer.$$$reportNull$$$0(0);
        }
        this.myAliases = NotNullLazyValue.volatileLazy(() -> this.getSpringBean().getAliases());
        this.myName = name;
        this.myProject = project;
    }

    @Override
    @Nullable
    public String getName() {
        return this.myName;
    }

    @Override
    public PsiType[] getEffectiveBeanTypes() {
        if (this.effectiveTypesValue == null) {
            this.effectiveTypesValue = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> {
                Object bean = this.getSpringBean();
                PsiType[] types = BeanService.getInstance().getEffectiveBeanTypes((CommonSpringBean)bean);
                return CachedValueProvider.Result.create((Object)types, (Object[])SpringBaseBeanPointer.getDependencies(bean, this.myProject));
            }, false);
        }
        return (PsiType[])this.effectiveTypesValue.getValue();
    }

    private static Object @NotNull [] getDependencies(@NotNull CommonSpringBean bean, @NotNull Project project) {
        if (bean == null) {
            SpringBaseBeanPointer.$$$reportNull$$$0(1);
        }
        if (project == null) {
            SpringBaseBeanPointer.$$$reportNull$$$0(2);
        }
        HashSet<Object> deps = new HashSet<Object>();
        ContainerUtil.addIfNotNull(deps, (Object)bean.getContainingFile().getVirtualFile());
        deps.add(SpringModificationTrackersManager.getInstance(project).getOuterModelsModificationTracker());
        deps.add(PsiModificationTracker.MODIFICATION_COUNT);
        Object[] objectArray = ArrayUtil.toObjectArray(deps);
        if (objectArray == null) {
            SpringBaseBeanPointer.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    @Override
    public String[] getAliases() {
        return (String[])this.myAliases.getValue();
    }

    @Override
    @NotNull
    public SpringBeanPointer<?> getBasePointer() {
        SpringBaseBeanPointer springBaseBeanPointer = this;
        if (springBaseBeanPointer == null) {
            SpringBaseBeanPointer.$$$reportNull$$$0(4);
        }
        return springBaseBeanPointer;
    }

    @Override
    public SpringBeanPointer<?> derive(@NotNull String name) {
        if (name == null) {
            SpringBaseBeanPointer.$$$reportNull$$$0(5);
        }
        return Objects.equals(name, this.getName()) ? this : new DerivedSpringBeanPointer(this, name);
    }

    @Override
    public boolean isReferenceTo(@Nullable CommonSpringBean springBean) {
        if (springBean == null) {
            return false;
        }
        PsiFile file = springBean.getContainingFile();
        return file.equals(this.getContainingFile()) && springBean.equals(this.getSpringBean());
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    @Nullable
    public SpringBeanPointer<?> getParentPointer() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpringBeanPointer)) {
            return false;
        }
        SpringBeanPointer that = (SpringBeanPointer)o;
        return Objects.equals(this.myName, that.getName()) && Comparing.equal((Object)this.getPsiElement(), (Object)that.getPsiElement());
    }

    public int hashCode() {
        return this.myName != null ? this.myName.hashCode() : 0;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.myName + "]";
    }

    protected Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/SpringBaseBeanPointer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/SpringBaseBeanPointer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBasePointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "derive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

