/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.impl;

import com.intellij.facet.FacetFinder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.impl.SpringEndpointsModificationTracker;
import com.intellij.spring.impl.SpringKtOutOfCodeBlockModificationTracker;
import com.intellij.spring.impl.SpringOuterModelsModificationTracker;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringModificationTrackersManagerImpl
extends SpringModificationTrackersManager
implements Disposable {
    @NotNull
    private final Project myProject;
    private final SimpleModificationTracker myProfilesModificationTracker;
    private final SimpleModificationTracker myMultipleContextsModificationTracker;
    private final SimpleModificationTracker myCustomBeanParserModificationTracker;
    private final ModificationTracker myOuterModelsModificationTracker;
    @Nullable
    private final SpringKtOutOfCodeBlockModificationTracker myKtModificationTracker;
    private final SpringEndpointsModificationTracker myEndpointsModificationTracker;

    public SpringModificationTrackersManagerImpl(@NotNull Project project) {
        if (project == null) {
            SpringModificationTrackersManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProfilesModificationTracker = new SimpleModificationTracker();
        this.myMultipleContextsModificationTracker = new SimpleModificationTracker();
        this.myCustomBeanParserModificationTracker = new SimpleModificationTracker();
        this.myProject = project;
        if (Registry.is((String)"spring.use.uast.modification.tracker")) {
            this.myOuterModelsModificationTracker = new SpringOuterModelsModificationTracker(project, this, true);
            this.myKtModificationTracker = null;
        } else {
            this.myOuterModelsModificationTracker = new SpringOuterModelsModificationTracker(project, this, false);
            this.myKtModificationTracker = new SpringKtOutOfCodeBlockModificationTracker(project, this);
        }
        this.myEndpointsModificationTracker = new SpringEndpointsModificationTracker(this.myProject, this.myOuterModelsModificationTracker);
    }

    @Override
    public ModificationTracker getProfilesModificationTracker() {
        return this.myProfilesModificationTracker;
    }

    @Override
    public ModificationTracker getMultipleContextsModificationTracker() {
        return this.myMultipleContextsModificationTracker;
    }

    @Override
    public ModificationTracker getOuterModelsModificationTracker() {
        return this.myOuterModelsModificationTracker;
    }

    @Override
    public ModificationTracker getCustomBeanParserModificationTracker() {
        return this.myCustomBeanParserModificationTracker;
    }

    @Override
    public ModificationTracker getEndpointsModificationTracker() {
        return this.myEndpointsModificationTracker;
    }

    @Override
    public void fireActiveProfilesChanged() {
        this.myProfilesModificationTracker.incModificationCount();
    }

    @Override
    public void fireMultipleContextsChanged() {
        this.myMultipleContextsModificationTracker.incModificationCount();
    }

    @Override
    public void fireCustomBeanParserChanged() {
        this.myCustomBeanParserModificationTracker.incModificationCount();
    }

    @Override
    public Object[] getOuterModelsDependencies() {
        ArrayList<Object> dependencies = new ArrayList<Object>();
        dependencies.add(this.getOuterModelsModificationTracker());
        if (this.myKtModificationTracker != null) {
            dependencies.add((Object)this.myKtModificationTracker);
        }
        dependencies.add(this.getProfilesModificationTracker());
        dependencies.add(this.getMultipleContextsModificationTracker());
        dependencies.add(ProjectRootManager.getInstance((Project)this.myProject));
        dependencies.add(FacetFinder.getInstance((Project)this.myProject).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID));
        dependencies.add(DumbService.getInstance((Project)this.myProject).getModificationTracker());
        return ArrayUtil.toObjectArray(dependencies);
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/impl/SpringModificationTrackersManagerImpl", "<init>"));
    }
}

