/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.impl;

import com.intellij.facet.FacetFinder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.chooser.SpringContextDescriptor;
import com.intellij.spring.contexts.chooser.SpringMultipleContextsManager;
import com.intellij.spring.contexts.model.CombinedSpringModelImpl;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.impl.SpringAutoConfiguredModels;
import com.intellij.spring.impl.SpringCombinedModelFactory;
import com.intellij.spring.impl.SpringModelsCreationContext;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringManagerImpl
extends SpringManager {
    private static final Key<CachedValue<Set<SpringModel>>> ALL_MODELS_MODULE_WITH_DEPS = Key.create((String)"ALL_MODELS_MODULE_WITH_DEPS");
    private static final Key<CachedValue<SpringModel>> MODULE_COMBINED_MODEL_KEY = Key.create((String)"MODULE_COMBINED_MODEL_KEY");
    private final Project myProject;

    public SpringManagerImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public Object @NotNull [] getModelsDependencies(@NotNull Module module, Object ... additional) {
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(0);
        }
        return SpringManagerImpl.getModelDependenciesObjects(module, additional);
    }

    private static Object @NotNull [] getModelDependenciesObjects(@NotNull Module module, Object ... additional) {
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(1);
        }
        ArrayList<Object> dependencies = new ArrayList<Object>(6);
        Collections.addAll(dependencies, additional);
        Object[] objectArray = SpringManagerImpl.addModuleModelsDependencies(module, dependencies).toArray();
        if (objectArray == null) {
            SpringManagerImpl.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    @NotNull
    private static Collection<Object> addModuleModelsDependencies(@NotNull Module module, Collection<Object> dependencies) {
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(3);
        }
        ContainerUtil.addAll(dependencies, (Object[])SpringModificationTrackersManager.getInstance(module.getProject()).getOuterModelsDependencies());
        SpringFacet facet = SpringFacet.getInstance(module);
        if (facet != null) {
            dependencies.add(facet.getConfiguration());
        }
        Collection<Object> collection = dependencies;
        if (collection == null) {
            SpringManagerImpl.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    @NotNull
    public Set<SpringModel> getAllModels(@NotNull Module module) {
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(5);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)module, ALL_MODELS_MODULE_WITH_DEPS, () -> {
            Set<SpringModel> models = SpringManagerImpl.computeAllModels(SpringModelsCreationContext.create(module));
            return CachedValueProvider.Result.create(models, (Object[])this.getModelsDependencies(module, SpringManagerImpl.getConfigs(models)));
        }, false);
        if (set == null) {
            SpringManagerImpl.$$$reportNull$$$0(6);
        }
        return set;
    }

    private static Object @NotNull [] getConfigs(@NotNull Set<SpringModel> models) {
        if (models == null) {
            SpringManagerImpl.$$$reportNull$$$0(7);
        }
        HashSet configs = new HashSet();
        for (SpringModel model : models) {
            configs.addAll(model.getRelatedModels().stream().filter(lm -> lm instanceof LocalModel).map(lm -> ((LocalModel)lm).getConfig()).collect(Collectors.toSet()));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(configs);
        if (objectArray == null) {
            SpringManagerImpl.$$$reportNull$$$0(8);
        }
        return objectArray;
    }

    @NotNull
    public static Set<SpringModel> getAllModels(@NotNull SpringModelsCreationContext context) {
        if (context == null) {
            SpringManagerImpl.$$$reportNull$$$0(9);
        }
        Set<SpringModel> set = SpringManagerImpl.computeAllModels(context);
        if (set == null) {
            SpringManagerImpl.$$$reportNull$$$0(10);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<SpringModel> getAllModelsWithoutDependencies(@NotNull Module module) {
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(11);
        }
        Set<SpringModel> set = SpringManagerImpl.getModelsWithoutDependencies(module);
        if (set == null) {
            SpringManagerImpl.$$$reportNull$$$0(12);
        }
        return set;
    }

    public static Set<SpringModel> getModelsWithoutDependencies(@NotNull Module module) {
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(13);
        }
        if (module.isDisposed()) {
            return Collections.emptySet();
        }
        Project project = module.getProject();
        return (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            SpringFacet facet = SpringFacet.getInstance(module);
            if (facet == null) {
                if (SpringManagerImpl.isAllowAutoConfiguration(project)) {
                    return SpringAutoConfiguredModels.getAutoConfiguredModels(module);
                }
                return CachedValueProvider.Result.create(Collections.emptySet(), (Object[])new Object[]{FacetFinder.getInstance((Project)project).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID)});
            }
            Set<SpringFileSet> fileSets = SpringFileSetService.getInstance().getAllSets(facet);
            if (fileSets.isEmpty() && SpringManagerImpl.isAllowAutoConfiguration(project)) {
                return SpringAutoConfiguredModels.getAutoConfiguredModels(module);
            }
            Set<SpringModel> models = SpringManagerImpl.createModelsWithoutDependencies(module, module);
            return CachedValueProvider.Result.create(models, (Object[])SpringManagerImpl.getModelDependenciesObjects(module, PsiModificationTracker.MODIFICATION_COUNT));
        });
    }

    @NotNull
    private static Set<SpringModel> createModelsWithoutDependencies(@NotNull Module module, @Nullable Module contextModule) {
        SpringFacet facet;
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(14);
        }
        if ((facet = SpringFacet.getInstance(module)) == null) {
            Set<SpringModel> set = Collections.emptySet();
            if (set == null) {
                SpringManagerImpl.$$$reportNull$$$0(15);
            }
            return set;
        }
        LinkedHashSet<SpringModel> models = new LinkedHashSet<SpringModel>();
        for (SpringFileSet set : SpringFileSetService.getInstance().getAllSets(facet)) {
            if (set.isRemoved()) continue;
            SpringModel model = SpringCombinedModelFactory.createModel(set, contextModule == null ? module : contextModule);
            ContainerUtil.addIfNotNull(models, (Object)model);
        }
        LinkedHashSet<SpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            SpringManagerImpl.$$$reportNull$$$0(16);
        }
        return linkedHashSet;
    }

    public static boolean isAllowAutoConfiguration(@NotNull Project project) {
        if (project == null) {
            SpringManagerImpl.$$$reportNull$$$0(17);
        }
        return SpringGeneralSettings.getInstance(project).isAllowAutoConfigurationMode();
    }

    @Override
    @NotNull
    public SpringModel getCombinedModel(@NotNull Module module) {
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(18);
        }
        SpringModel springModel = (SpringModel)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)module, MODULE_COMBINED_MODEL_KEY, () -> {
            Set<SpringModel> models = this.getAllModels(module);
            return CachedValueProvider.Result.create((Object)new CombinedSpringModelImpl(models, module), (Object[])this.getModelsDependencies(module, SpringManagerImpl.getConfigs(models)));
        }, false);
        if (springModel == null) {
            SpringManagerImpl.$$$reportNull$$$0(19);
        }
        return springModel;
    }

    @Override
    @NotNull
    public Set<SpringModel> getSpringModelsByFile(@NotNull PsiFile file) {
        if (file == null) {
            SpringManagerImpl.$$$reportNull$$$0(20);
        }
        Set<SpringModel> set = SpringManagerImpl.getCachedValueModelsByFile(file);
        if (set == null) {
            SpringManagerImpl.$$$reportNull$$$0(21);
        }
        return set;
    }

    private static Set<SpringModel> getCachedValueModelsByFile(@NotNull PsiFile file) {
        if (file == null) {
            SpringManagerImpl.$$$reportNull$$$0(22);
        }
        return (Set)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            Set<SpringModel> models;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            if (module == null) {
                return CachedValueProvider.Result.create(Collections.emptySet(), (Object[])SpringManagerImpl.getSpringModelDependencies(Collections.emptySet(), file).toArray());
            }
            SpringContextDescriptor descriptor = SpringMultipleContextsManager.getInstance().getContextDescriptor(file);
            if (descriptor.equals(SpringContextDescriptor.LOCAL_CONTEXT)) {
                models = ContainerUtil.createMaybeSingletonSet((Object)SpringCombinedModelFactory.createSingleModel(file, module));
            } else if (descriptor.equals(SpringContextDescriptor.ALL_CONTEXTS)) {
                models = SpringManagerImpl.findModelsInScope(file, module);
            } else {
                Module descriptorModule = descriptor.getModule();
                Set<SpringModel> allModels = SpringManagerImpl.getAllModels(SpringModelsCreationContext.create(descriptorModule != null ? descriptorModule : module));
                models = allModels.stream().filter(model -> {
                    SpringFileSet fileSet = model.getFileSet();
                    if (fileSet == null) {
                        return false;
                    }
                    return descriptor.getId().equals(fileSet.getId()) && SpringManagerImpl.isConfiguredInModel(file, model);
                }).collect(Collectors.toSet());
            }
            return CachedValueProvider.Result.create(models, (Object[])SpringManagerImpl.getSpringModelDependencies(models, file).toArray());
        });
    }

    private static boolean isConfiguredInModel(@NotNull PsiFile file, @NotNull SpringModel model) {
        if (file == null) {
            SpringManagerImpl.$$$reportNull$$$0(23);
        }
        if (model == null) {
            SpringManagerImpl.$$$reportNull$$$0(24);
        }
        return SpringManagerImpl.isConfiguredInFileSet(model, file.getOriginalFile().getVirtualFile()) || SpringModelVisitorUtils.hasConfigFile(model, file);
    }

    @Override
    @Nullable
    public SpringModel getSpringModelByFile(@NotNull PsiFile file) {
        if (file == null) {
            SpringManagerImpl.$$$reportNull$$$0(25);
        }
        return (SpringModel)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            Set<SpringModel> allModels = this.getSpringModelsByFile(file);
            SpringModel modelByFile = allModels.size() == 0 ? null : (allModels.size() == 1 ? allModels.iterator().next() : new CombinedSpringModelImpl(allModels, allModels.iterator().next().getModule()));
            return CachedValueProvider.Result.create(modelByFile, (Object[])SpringManagerImpl.getSpringModelDependencies(allModels, file).toArray());
        });
    }

    public void dispose() {
    }

    @NotNull
    private static Set<Object> getSpringModelDependencies(@NotNull Set<SpringModel> allModels, @NotNull PsiFile file) {
        if (allModels == null) {
            SpringManagerImpl.$$$reportNull$$$0(26);
        }
        if (file == null) {
            SpringManagerImpl.$$$reportNull$$$0(27);
        }
        Project project = file.getProject();
        HashSet<Object> dependencies = new HashSet<Object>();
        dependencies.add(SpringModificationTrackersManager.getInstance(project).getMultipleContextsModificationTracker());
        dependencies.add(FacetFinder.getInstance((Project)project).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID));
        dependencies.add(ProjectRootManager.getInstance((Project)project));
        for (SpringModel model : allModels) {
            SpringFileSet fileSet = model.getFileSet();
            if (fileSet == null) continue;
            ContainerUtil.addIfNotNull(dependencies, (Object)((SpringFacetConfiguration)fileSet.getFacet().getConfiguration()));
        }
        SpringContextDescriptor descriptor = SpringMultipleContextsManager.getInstance().getContextDescriptor(file);
        if (descriptor.equals(SpringContextDescriptor.LOCAL_CONTEXT)) {
            dependencies.add(file);
        }
        HashSet<Object> hashSet = dependencies;
        if (hashSet == null) {
            SpringManagerImpl.$$$reportNull$$$0(28);
        }
        return hashSet;
    }

    private static Set<SpringModel> computeAllModels(@NotNull SpringModelsCreationContext context) {
        LinkedHashSet<SpringModel> result;
        block3: {
            Module contextModule;
            block2: {
                if (context == null) {
                    SpringManagerImpl.$$$reportNull$$$0(29);
                }
                contextModule = context.getModule();
                result = new LinkedHashSet<SpringModel>(SpringManagerImpl.getModelsWithoutDependencies(contextModule));
                if (!context.onlyCurrentModule()) break block2;
                if (!result.isEmpty()) break block3;
                result.addAll(SpringManagerImpl.getModelsFromDependencies(contextModule));
                if (!result.isEmpty()) break block3;
                result.addAll(SpringManagerImpl.getModelsFromDependentModules(contextModule));
                break block3;
            }
            for (Module module : SpringManagerImpl.getRelatedModules(context)) {
                if (module.equals(contextModule)) continue;
                result.addAll(SpringManagerImpl.getModelsWithoutDependencies(module));
            }
        }
        Set<SpringModel> springModels = Collections.unmodifiableSet(result);
        SpringManagerImpl.processFileSetDependencies(springModels);
        return springModels;
    }

    @NotNull
    private static Set<Module> getRelatedModules(@NotNull SpringModelsCreationContext context) {
        if (context == null) {
            SpringManagerImpl.$$$reportNull$$$0(30);
        }
        @NotNull Module contextModule = context.getModule();
        HashSet<Module> relatedModules = new HashSet<Module>();
        if (context.isLoadModelsFromModuleDependencies()) {
            ModuleUtilCore.getDependencies((Module)contextModule, relatedModules);
        }
        if (context.isLoadModelsFromDependentModules()) {
            LinkedHashSet dependentModules = new LinkedHashSet();
            ModuleUtilCore.collectModulesDependsOn((Module)contextModule, dependentModules);
            relatedModules.addAll(dependentModules);
        }
        HashSet<Module> hashSet = relatedModules;
        if (hashSet == null) {
            SpringManagerImpl.$$$reportNull$$$0(31);
        }
        return hashSet;
    }

    @NotNull
    private static Set<SpringModel> getModelsFromDependencies(@NotNull Module contextModule) {
        if (contextModule == null) {
            SpringManagerImpl.$$$reportNull$$$0(32);
        }
        LinkedHashSet dependencies = new LinkedHashSet();
        ModuleUtilCore.getDependencies((Module)contextModule, dependencies);
        @NotNull LinkedHashSet<SpringModel> models = new LinkedHashSet<SpringModel>();
        for (Module dep : dependencies) {
            if (dep.equals(contextModule)) continue;
            models.addAll(SpringManagerImpl.createModelsWithoutDependencies(dep, contextModule));
        }
        LinkedHashSet<SpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            SpringManagerImpl.$$$reportNull$$$0(33);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<SpringModel> getModelsFromDependentModules(@NotNull Module contextModule) {
        if (contextModule == null) {
            SpringManagerImpl.$$$reportNull$$$0(34);
        }
        LinkedHashSet dependentModules = new LinkedHashSet();
        ModuleUtilCore.collectModulesDependsOn((Module)contextModule, dependentModules);
        @NotNull LinkedHashSet<SpringModel> models = new LinkedHashSet<SpringModel>();
        for (Module dep : dependentModules) {
            if (dep.equals(contextModule)) continue;
            models.addAll(SpringManagerImpl.createModelsWithoutDependencies(dep, dep));
        }
        LinkedHashSet<SpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            SpringManagerImpl.$$$reportNull$$$0(35);
        }
        return linkedHashSet;
    }

    private static void processFileSetDependencies(@NotNull Set<SpringModel> models) {
        if (models == null) {
            SpringManagerImpl.$$$reportNull$$$0(36);
        }
        for (SpringModel model : models) {
            SpringManagerImpl.resolveDependencies(new LinkedHashSet<SpringModel>(models), model);
        }
    }

    private static void resolveDependencies(@NotNull Set<SpringModel> dependenciesCandidates, @NotNull SpringModel model) {
        SpringFileSet fileSet;
        if (dependenciesCandidates == null) {
            SpringManagerImpl.$$$reportNull$$$0(37);
        }
        if (model == null) {
            SpringManagerImpl.$$$reportNull$$$0(38);
        }
        if ((fileSet = model.getFileSet()) == null) {
            return;
        }
        Set<SpringFileSet> dependencyFileSets = fileSet.getDependencyFileSets();
        if (dependencyFileSets.isEmpty()) {
            return;
        }
        LinkedHashSet<SpringModel> dependencies = new LinkedHashSet<SpringModel>();
        for (SpringFileSet depend : dependencyFileSets) {
            SpringModel candidateModel;
            SpringModel resolvedModel = SpringManagerImpl.findResolvedModel(model, depend, dependenciesCandidates.toArray(new SpringModel[0]));
            if (resolvedModel != null) {
                dependencies.add(resolvedModel);
                continue;
            }
            Module module = model.getModule();
            if (module == null || (candidateModel = SpringCombinedModelFactory.createModel(depend, module)) == null) continue;
            dependencies.add(candidateModel);
            dependenciesCandidates.add(candidateModel);
            SpringManagerImpl.resolveDependencies(dependenciesCandidates, candidateModel);
        }
        model.setDependencies(dependencies);
    }

    @Nullable
    private static SpringModel findResolvedModel(@NotNull SpringModel model, SpringFileSet depend, SpringModel ... candidates) {
        if (model == null) {
            SpringManagerImpl.$$$reportNull$$$0(39);
        }
        if (candidates == null) {
            SpringManagerImpl.$$$reportNull$$$0(40);
        }
        for (SpringModel depModel : candidates) {
            if (depModel == model || !depend.equals(depModel.getFileSet())) continue;
            return depModel;
        }
        return null;
    }

    @NotNull
    private static Set<SpringModel> findModelsInScope(@NotNull PsiFile psiFile, @NotNull Module module) {
        if (psiFile == null) {
            SpringManagerImpl.$$$reportNull$$$0(41);
        }
        if (module == null) {
            SpringManagerImpl.$$$reportNull$$$0(42);
        }
        PsiFile originalFile = psiFile.getOriginalFile();
        VirtualFile virtualFile = originalFile.getVirtualFile();
        LinkedHashSet<SpringModel> models = new LinkedHashSet<SpringModel>();
        for (SpringModel model : SpringManagerImpl.getAllModels(SpringModelsCreationContext.fromEverywhere(module))) {
            if (SpringManagerImpl.isConfiguredInFileSet(model, virtualFile)) {
                models.add(model);
                continue;
            }
            if (!SpringModelVisitorUtils.hasConfigFile(model, originalFile)) continue;
            models.add(model);
        }
        LinkedHashSet<SpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            SpringManagerImpl.$$$reportNull$$$0(43);
        }
        return linkedHashSet;
    }

    private static boolean isConfiguredInFileSet(SpringModel model, VirtualFile virtualFile) {
        SpringFileSet fileSet = model.getFileSet();
        if (fileSet == null) {
            return false;
        }
        if (fileSet.hasFile(virtualFile)) {
            return true;
        }
        for (SpringFileSet dep : fileSet.getDependencyFileSets()) {
            if (!dep.hasFile(virtualFile)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 28: 
            case 31: 
            case 33: 
            case 35: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 28: 
            case 31: 
            case 33: 
            case 35: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 28: 
            case 31: 
            case 33: 
            case 35: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/impl/SpringManagerImpl";
                break;
            }
            case 7: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 9: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allModels";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextModule";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesCandidates";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/impl/SpringManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelDependenciesObjects";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addModuleModelsDependencies";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModels";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigs";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModelsWithoutDependencies";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createModelsWithoutDependencies";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCombinedModel";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringModelsByFile";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringModelDependencies";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedModules";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelsFromDependencies";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelsFromDependentModules";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "findModelsInScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModelsDependencies";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getModelDependenciesObjects";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 28: 
            case 31: 
            case 33: 
            case 35: 
            case 43: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addModuleModelsDependencies";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllModels";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConfigs";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAllModelsWithoutDependencies";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getModelsWithoutDependencies";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createModelsWithoutDependencies";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAllowAutoConfiguration";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCombinedModel";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSpringModelsByFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValueModelsByFile";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isConfiguredInModel";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSpringModelByFile";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSpringModelDependencies";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "computeAllModels";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedModules";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getModelsFromDependencies";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getModelsFromDependentModules";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processFileSetDependencies";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "resolveDependencies";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findResolvedModel";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findModelsInScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 28: 
            case 31: 
            case 33: 
            case 35: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

