/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.impl;

import com.intellij.facet.FacetFinder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.CombinedSpringModelImpl;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.graph.LazyModelDependenciesGraph;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.util.Chunk;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.xml.DomService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringAutoConfiguredModels {
    public static final List<String> bootAnnotations = List.of("org.springframework.boot.autoconfigure.SpringBootApplication", "org.springframework.boot.autoconfigure.EnableAutoConfiguration");

    @NotNull
    public static CachedValueProvider.Result<Set<SpringModel>> getAutoConfiguredModels(@NotNull Module module) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(0);
        }
        Set<SpringModel> models = SpringAutoConfiguredModels.discoverAutoConfiguredModels(module);
        CachedValueProvider.Result result = CachedValueProvider.Result.create(models, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, FacetFinder.getInstance((Project)module.getProject()).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID)});
        if (result == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(1);
        }
        return result;
    }

    @NotNull
    public static Set<SpringModel> discoverAutoConfiguredModels(@NotNull Module module) {
        Set<SpringModel> springBootModels;
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(2);
        }
        if (!(springBootModels = SpringAutoConfiguredModels.getSpringBootModels(module)).isEmpty()) {
            Set<SpringModel> set = springBootModels;
            if (set == null) {
                SpringAutoConfiguredModels.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set<LocalModel<?>> autoConfiguredModels = SpringAutoConfiguredModels.getAutoConfiguredLocalModels(module);
        if (autoConfiguredModels.isEmpty()) {
            Set<SpringModel> set = Collections.emptySet();
            if (set == null) {
                SpringAutoConfiguredModels.$$$reportNull$$$0(4);
            }
            return set;
        }
        Set<SpringModel> set = Collections.singleton(new CombinedSpringModelImpl(autoConfiguredModels, module));
        if (set == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public static Set<SpringModel> getSpringBootModels(@NotNull Module module) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(6);
        }
        LinkedHashSet<SpringModel> bootApplications = new LinkedHashSet<SpringModel>();
        for (String bootAnno : bootAnnotations) {
            bootApplications.addAll(SpringAutoConfiguredModels.getAnnoConfiguredModels(module, bootAnno));
        }
        LinkedHashSet<SpringModel> linkedHashSet = bootApplications;
        if (linkedHashSet == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    @NotNull
    public static Set<LocalModel<?>> getAutoConfiguredLocalModels(@NotNull Module module) {
        Set<LocalModel<?>> localModels;
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(8);
        }
        if (!(localModels = SpringAutoConfiguredModels.getLocalModelCandidates(module)).isEmpty()) {
            return SpringAutoConfiguredModels.filterAutoConfiguredModelsSet(localModels, module);
        }
        Set<LocalModel<?>> set = Collections.emptySet();
        if (set == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    public static Set<LocalModel<?>> getLocalModelCandidates(@NotNull Module module) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(10);
        }
        LinkedHashSet localModels = new LinkedHashSet();
        localModels.addAll(SpringAutoConfiguredModels.getLocalAnnotationModelCandidates(module));
        localModels.addAll(SpringAutoConfiguredModels.getLocalXmlModelCandidates(module));
        LinkedHashSet linkedHashSet = localModels;
        if (linkedHashSet == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(11);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<LocalModel<?>> filterAutoConfiguredModelsSet(@NotNull Set<LocalModel<?>> models, @NotNull Module module) {
        if (models == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(12);
        }
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(13);
        }
        LazyModelDependenciesGraph graph = SpringAutoConfiguredModels.getModelsGraph(models, module);
        HashSet configuredModels = new HashSet();
        Graph sccGraph = GraphAlgorithms.getInstance().computeSCCGraph((Graph)graph);
        for (Chunk chunk : sccGraph.getNodes()) {
            Set chunkNodes;
            if (sccGraph.getIn((Object)chunk).hasNext() || !(chunkNodes = chunk.getNodes()).iterator().hasNext()) continue;
            configuredModels.add((LocalModel)chunkNodes.iterator().next());
        }
        HashSet hashSet = configuredModels;
        if (hashSet == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    @NotNull
    private static LazyModelDependenciesGraph getModelsGraph(final @NotNull Set<LocalModel<?>> models, @NotNull Module module) {
        if (models == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(15);
        }
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(16);
        }
        return new LazyModelDependenciesGraph(module, Collections.emptySet()){

            @Override
            @NotNull
            public Collection<LocalModel<?>> getNodes() {
                Set set = models;
                if (set == null) {
                    1.$$$reportNull$$$0(0);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringAutoConfiguredModels$1", "getNodes"));
            }
        };
    }

    @NotNull
    private static Set<LocalAnnotationModel> getLocalAnnotationModelCandidates(@NotNull Module module) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(17);
        }
        List<SpringConfiguration> configurations = SpringJamModel.getModel(module).getConfigurations(GlobalSearchScope.moduleWithDependenciesScope((Module)module));
        Set<LocalAnnotationModel> set = configurations.stream().filter(configuration -> {
            PsiFile file = configuration.getContainingFile();
            return file != null && !SpringAutoConfiguredModels.isInTestSourceContent(file.getProject(), file.getVirtualFile());
        }).filter(configuration -> SpringCommonUtils.isSpringBeanCandidateClass(configuration.getPsiElement())).map(configuration -> SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(configuration.getPsiElement(), module, Collections.emptySet())).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(18);
        }
        return set;
    }

    @NotNull
    private static Set<LocalXmlModel> getLocalXmlModelCandidates(@NotNull Module module) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(19);
        }
        Project project = module.getProject();
        Collection springXmlCandidates = DomService.getInstance().getDomFileCandidates(Beans.class, GlobalSearchScope.moduleWithDependenciesScope((Module)module));
        Set<LocalXmlModel> set = springXmlCandidates.stream().filter(vf -> ApplicationManager.getApplication().isUnitTestMode() || !SpringAutoConfiguredModels.isInTestSourceContent(project, vf)).map(file -> {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            return psiFile instanceof XmlFile ? SpringLocalModelFactory.getInstance().getOrCreateLocalXmlModel((XmlFile)psiFile, module, Collections.emptySet()) : null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(20);
        }
        return set;
    }

    private static boolean isInTestSourceContent(@NotNull Project project, @Nullable VirtualFile vf) {
        if (project == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(21);
        }
        return vf != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInTestSourceContent(vf);
    }

    @NotNull
    private static Set<SpringModel> getAnnoConfiguredModels(@NotNull Module module, @NotNull String anno) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(22);
        }
        if (anno == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(23);
        }
        if (DumbService.isDumb((Project)module.getProject())) {
            Set<SpringModel> set = Collections.emptySet();
            if (set == null) {
                SpringAutoConfiguredModels.$$$reportNull$$$0(24);
            }
            return set;
        }
        LinkedHashSet<SpringModel> models = new LinkedHashSet<SpringModel>();
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        PsiClass psiAnno = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(anno, scope);
        if (psiAnno != null) {
            for (PsiMember member : AnnotatedMembersSearch.search((PsiClass)psiAnno, (SearchScope)scope).findAll()) {
                LocalAnnotationModel localAnnotationModel;
                if (!(member instanceof PsiClass) || !SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)member) || (localAnnotationModel = SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel((PsiClass)member, module, Collections.emptySet())) == null) continue;
                models.add(new CombinedSpringModelImpl(Collections.singleton(localAnnotationModel), localAnnotationModel.getModule()));
            }
        }
        LinkedHashSet<SpringModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(25);
        }
        return linkedHashSet;
    }

    public static boolean isAllowAutoConfiguration(@NotNull Project project) {
        if (project == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(26);
        }
        return !project.isDisposed() && SpringGeneralSettings.getInstance(project).isAllowAutoConfigurationMode();
    }

    public static boolean hasAutoConfiguredModels(@NotNull Module module) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(27);
        }
        return SpringAutoConfiguredModels.isAllowAutoConfiguration(module.getProject()) && !SpringAutoConfiguredModels.getAutoConfiguredLocalModels(module).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/impl/SpringAutoConfiguredModels";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/impl/SpringAutoConfiguredModels";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoConfiguredModels";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "discoverAutoConfiguredModels";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringBootModels";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoConfiguredLocalModels";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalModelCandidates";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAutoConfiguredModelsSet";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalAnnotationModelCandidates";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalXmlModelCandidates";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnoConfiguredModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAutoConfiguredModels";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 24: 
            case 25: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "discoverAutoConfiguredModels";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSpringBootModels";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAutoConfiguredLocalModels";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLocalModelCandidates";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "filterAutoConfiguredModelsSet";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getModelsGraph";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLocalAnnotationModelCandidates";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLocalXmlModelCandidates";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInTestSourceContent";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAnnoConfiguredModels";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isAllowAutoConfiguration";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "hasAutoConfiguredModels";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

