/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.semantic.SemService;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.visitors.CommonSpringModelVisitorContext;
import com.intellij.spring.contexts.model.visitors.SpringModelVisitors;
import com.intellij.spring.gutter.NavigationGutterIconBuilderUtil;
import com.intellij.spring.gutter.SpringAnnotatorBase;
import com.intellij.spring.gutter.SpringAutowiredAnnotator;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.impl.SpringAutoConfiguredModels;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.jam.javaConfig.SpringOldJavaConfigurationUtil;
import com.intellij.spring.model.jam.stereotype.SpringImport;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;

public final class SpringBeanAnnotator
extends SpringAnnotatorBase {
    public String getId() {
        return "SpringBeanAnnotator";
    }

    public String getName() {
        return SpringBundle.message("spring.core.bean.annotator.name", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = SpringApiIcons.SpringBean;
        if (icon == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @Override
    protected void annotateClass(Collection<? super RelatedItemLineMarkerInfo<?>> result, @NotNull UClass uClass, PsiElement identifier) {
        PsiClass psiClass;
        if (uClass == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(1);
        }
        if ((psiClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)uClass, PsiClass.class)) == null) {
            return;
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            return;
        }
        SpringJavaClassInfo info1 = SpringJavaClassInfo.getSpringJavaClassInfo(psiClass);
        if (info1.isMappedDomBean()) {
            SpringBeanAnnotator.addSpringBeanGutterIcon(result, identifier, NotNullLazyValue.lazy(() -> {
                List<DomSpringBeanPointer> domBeans = SpringJavaClassInfo.getSpringJavaClassInfo(psiClass).getMappedDomBeans();
                domBeans.sort(SpringBeanPointer.DISPLAY_COMPARATOR);
                return domBeans;
            }));
        } else if (info1.isStereotypeJavaBean()) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, SpringAutoConfiguredModels.bootAnnotations, (int)8)) {
                return;
            }
            SpringBeanAnnotator.addSpringJavaBeanGutterIcon(result, identifier, (NotNullLazyValue<Collection<? extends CommonModelElement>>)NotNullLazyValue.lazy(() -> {
                SmartList result2 = new SmartList();
                List<JamSpringBeanPointer> mappedBeans = SpringJavaClassInfo.getSpringJavaClassInfo(psiClass).getStereotypeMappedBeans();
                for (JamSpringBeanPointer mappedBean : mappedBeans) {
                    JamPsiMemberSpringBean bean = (JamPsiMemberSpringBean)mappedBean.getSpringBean();
                    if (!(bean instanceof SpringJavaBean) && (!(bean instanceof SpringStereotypeElement) || psiClass.isEquivalentTo(bean.getPsiElement()))) continue;
                    result2.add(bean);
                }
                CommonSpringModel model = SpringModelUtils.getInstance().getPsiClassSpringModel(psiClass);
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
                ContainerUtil.addAllNotNull((Collection)result2, SpringJamUtils.getInstance().findStereotypeConfigurationBeans(model, mappedBeans, module));
                ContainerUtil.addAllNotNull((Collection)result2, SpringBeanAnnotator.getImportConfigurations(model, psiClass));
                return result2;
            }), SpringApiIcons.Gutter.SpringJavaBean);
            PsiClassType classType = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createType(psiClass);
            result.add(SpringAutowiredAnnotator.getNavigateToAutowiredCandidatesBuilder((PsiMember)psiClass, (PsiType)classType).createSpringGroupLineMarkerInfo(identifier));
        }
    }

    @Override
    protected void annotateMethod(@NotNull UMethod uMethod, PsiElement identifier, Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        PsiMethod method;
        if (uMethod == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(2);
        }
        if ((method = (PsiMethod)UElementKt.getAsJavaPsiElement((UElement)uMethod, PsiMethod.class)) == null) {
            return;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return;
        }
        if (SpringCommonUtils.isSpringBeanCandidateClassInSpringProject(psiClass)) {
            Collection<Pair<PsiElement, SpringJavaClassInfo.SpringMethodType>> methodTypes;
            SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo(psiClass);
            List<SpringBeanPointer<?>> externalBeans = SpringOldJavaConfigurationUtil.findExternalBeans(method);
            if (!externalBeans.isEmpty()) {
                SpringBeanAnnotator.addSpringBeanGutterIcon(result, identifier, NotNullLazyValue.lazy(() -> {
                    List<SpringBeanPointer<?>> externalBeans2 = SpringOldJavaConfigurationUtil.findExternalBeans(method);
                    externalBeans2.sort(SpringBeanPointer.DISPLAY_COMPARATOR);
                    return externalBeans2;
                }));
            }
            if (!(methodTypes = info.getMethodTypes(method)).isEmpty()) {
                SpringBeanAnnotator.addMethodTypesGutterIcon(result, method, methodTypes);
            }
        }
    }

    private static void addMethodTypesGutterIcon(Collection<? super RelatedItemLineMarkerInfo<?>> result, PsiMethod psiMethod, Collection<? extends Pair<PsiElement, SpringJavaClassInfo.SpringMethodType>> targets) {
        String tooltipText = SpringBundle.message("spring.bean.methods.tooltip.navigate.declaration", new Object[0]);
        Icon icon = SpringApiIcons.Gutter.SpringBeanMethod;
        if (targets.size() == 1) {
            SpringJavaClassInfo.SpringMethodType methodType = (SpringJavaClassInfo.SpringMethodType)((Object)targets.iterator().next().second);
            tooltipText = SpringBundle.message("spring.bean.method.tooltip.navigate.declaration", methodType.getName());
            if (methodType == SpringJavaClassInfo.SpringMethodType.FACTORY) {
                icon = SpringApiIcons.Gutter.FactoryMethodBean;
            }
        }
        SpringGutterIconBuilder<PsiElement> builder = SpringGutterIconBuilder.createBuilder(icon);
        builder.setTargets(ContainerUtil.mapNotNull(targets, pair -> (PsiElement)pair.getFirst())).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setPopupTitle(SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0])).setTooltipText(tooltipText);
        PsiIdentifier identifier = psiMethod.getNameIdentifier();
        if (identifier != null) {
            result.add(builder.createLineMarkerInfo((PsiElement)identifier));
        }
    }

    private static void addSpringBeanGutterIcon(Collection<? super RelatedItemLineMarkerInfo<?>> result, PsiElement psiIdentifier, NotNullLazyValue<Collection<? extends SpringBeanPointer<?>>> targets) {
        SpringGutterIconBuilder<SpringBeanPointer<?>> builder = SpringGutterIconBuilder.createBuilder(SpringApiIcons.Gutter.SpringBean, NavigationGutterIconBuilderUtil.BEAN_POINTER_CONVERTOR, NavigationGutterIconBuilderUtil.AUTOWIRED_BEAN_POINTER_GOTO_PROVIDER);
        builder.setTargets(targets).setEmptyPopupText(SpringBundle.message("gutter.navigate.no.matching.beans", new Object[0])).setPopupTitle(SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0])).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setTooltipText(SpringBundle.message("spring.bean.class.tooltip.navigate.declaration", new Object[0]));
        result.add(builder.createSpringGroupLineMarkerInfo(psiIdentifier));
    }

    private static List<CommonModelElement> getImportConfigurations(@NotNull CommonSpringModel model, @NotNull PsiClass psiClass) {
        Module module;
        if (model == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(3);
        }
        if (psiClass == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(4);
        }
        if ((module = model.getModule()) == null) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        if (model instanceof SpringModel) {
            SpringModelVisitors.visitRecursionAwareRelatedModels(model, CommonSpringModelVisitorContext.context(p -> true, (arg_0, arg_1) -> SpringBeanAnnotator.lambda$getImportConfigurations$5((List)result, psiClass, arg_0, arg_1)));
        }
        return result;
    }

    private static CommonModelElement getImportConfiguration(PsiClass candidate, PsiClass importedPsiClass) {
        SpringImport springImport = (SpringImport)SemService.getSemService((Project)candidate.getProject()).getSemElement(SpringImport.IMPORT_JAM_KEY, (PsiElement)candidate);
        if (springImport != null && springImport.getImportedClasses().contains(importedPsiClass)) {
            return springImport;
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$getImportConfigurations$5(List result, PsiClass psiClass, CommonSpringModel m, Processor p) {
        if (m instanceof LocalAnnotationModel) {
            PsiClass configClass = ((LocalAnnotationModel)m).getConfig();
            ContainerUtil.addIfNotNull((Collection)result, (Object)SpringBeanAnnotator.getImportConfiguration(configClass, psiClass));
            for (PsiClass superClass : InheritanceUtil.getSuperClasses((PsiClass)configClass)) {
                if ("java.lang.Object".equals(superClass.getQualifiedName())) continue;
                ContainerUtil.addIfNotNull((Collection)result, (Object)SpringBeanAnnotator.getImportConfiguration(superClass, psiClass));
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/gutter/SpringBeanAnnotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/gutter/SpringBeanAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "annotateClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "annotateMethod";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getImportConfigurations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

