/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class DomElementListCellRenderer
extends PsiElementListCellRenderer<PsiElement> {
    protected final String myUnknown;

    public DomElementListCellRenderer(@Nls String unknownElementText) {
        this.myUnknown = unknownElementText;
    }

    public String getElementText(PsiElement element) {
        String elementName = null;
        DomElement domElement = DomElementListCellRenderer.getDomElement(element);
        if (domElement != null) {
            elementName = domElement.getPresentation().getElementName();
        } else if (element instanceof XmlTag) {
            return ((XmlTag)element).getName();
        }
        return elementName == null ? this.myUnknown : elementName;
    }

    @Nullable
    public static DomElement getDomElement(@Nullable PsiElement element) {
        if (element instanceof PomTargetPsiElement) {
            return DomElementListCellRenderer.getDomElement(element.getNavigationElement());
        }
        if (element instanceof XmlTag) {
            return DomManager.getDomManager((Project)element.getProject()).getDomElement((XmlTag)element);
        }
        return null;
    }

    protected String getContainerText(PsiElement element, String name) {
        return DomElementListCellRenderer.getContainerText(element);
    }

    public static String getContainerText(PsiElement element) {
        return " (" + element.getContainingFile().getName() + ")";
    }

    protected Icon getIcon(PsiElement element) {
        Icon presentationIcon;
        DomElement domElement = DomElementListCellRenderer.getDomElement(element);
        if (domElement != null && (presentationIcon = domElement.getPresentation().getIcon()) != null) {
            return presentationIcon;
        }
        return super.getIcon(element);
    }
}

