/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.folding;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.properties.IProperty;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.values.PlaceholderPropertyReference;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlPropertyPlaceholderFoldingBuilder
extends FoldingBuilderEx {
    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (!(root instanceof XmlFile) || quick || !this.isEnabled()) {
            if (FoldingDescriptor.EMPTY == null) {
                XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(2);
            }
            return FoldingDescriptor.EMPTY;
        }
        DomFileElement<Beans> fileElement = SpringDomUtils.getSpringDomFileElement((XmlFile)root);
        if (fileElement == null) {
            if (FoldingDescriptor.EMPTY == null) {
                XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(3);
            }
            return FoldingDescriptor.EMPTY;
        }
        final PlaceholderUtils placeholderUtils = PlaceholderUtils.getInstance();
        SmartList regions = new SmartList();
        fileElement.accept(new DomElementVisitor((List)regions){
            final /* synthetic */ List val$regions;
            {
                this.val$regions = list;
            }

            public void visitDomElement(DomElement element) {
                if (!DomUtil.hasXml((DomElement)element)) {
                    return;
                }
                if (element instanceof GenericDomValue) {
                    if (placeholderUtils.isRawTextPlaceholder((GenericDomValue)element)) {
                        XmlElement xmlElement = element.getXmlElement();
                        if (xmlElement instanceof XmlAttribute) {
                            XmlAttributeValue value = ((XmlAttribute)xmlElement).getValueElement();
                            if (value != null) {
                                ContainerUtil.addIfNotNull((Collection)this.val$regions, (Object)XmlPropertyPlaceholderFoldingBuilder.this.createDescriptor((PsiElement)value));
                            }
                        } else if (xmlElement instanceof XmlTag) {
                            ContainerUtil.addIfNotNull((Collection)this.val$regions, (Object)XmlPropertyPlaceholderFoldingBuilder.this.createDescriptor((PsiElement)xmlElement));
                        }
                    }
                } else {
                    element.acceptChildren((DomElementVisitor)this);
                }
            }
        });
        FoldingDescriptor[] foldingDescriptorArray = regions.isEmpty() ? FoldingDescriptor.EMPTY : regions.toArray(FoldingDescriptor.EMPTY);
        if (foldingDescriptorArray == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(4);
        }
        return foldingDescriptorArray;
    }

    protected boolean isEnabled() {
        return JavaCodeFoldingSettings.getInstance().isCollapseI18nMessages();
    }

    @Nullable
    protected FoldingDescriptor createDescriptor(final PsiElement element) {
        for (PsiReference reference : XmlPropertyPlaceholderFoldingBuilder.getInnerReferences(element)) {
            if (!(reference instanceof PlaceholderPropertyReference)) continue;
            if (((PlaceholderPropertyReference)reference).multiResolve(false).length == 0) {
                return null;
            }
            return new FoldingDescriptor(element, this.getRangeForFolding(element, (PlaceholderPropertyReference)reference)){

                @NotNull
                public Set<Object> getDependencies() {
                    PsiElement property = XmlPropertyPlaceholderFoldingBuilder.resolveProperty(element);
                    if (property != null) {
                        PsiFile containingFile = property.getContainingFile();
                        Set set = ContainerUtil.createMaybeSingletonSet((Object)containingFile);
                        if (set == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return set;
                    }
                    Set set = super.getDependencies();
                    if (set == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return set;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/folding/XmlPropertyPlaceholderFoldingBuilder$2", "getDependencies"));
                }
            };
        }
        return null;
    }

    @NotNull
    private static Iterable<PsiReference> getInnerReferences(PsiElement element) {
        Stream<PsiReference> references = Arrays.stream(element.getReferences());
        if (element instanceof PsiLanguageInjectionHost) {
            Stream innerReferences = Arrays.stream(element.getChildren()).flatMap(e -> Arrays.stream(e.getReferences()));
            references = Stream.concat(references, innerReferences);
        }
        Iterable<PsiReference> iterable = references::iterator;
        if (iterable == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(5);
        }
        return iterable;
    }

    @NotNull
    protected TextRange getRangeForFolding(PsiElement element, PlaceholderPropertyReference reference) {
        TextRange textRange = reference.getFullTextRange().shiftRight(element.getTextRange().getStartOffset());
        if (textRange == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(7);
        }
        PsiElement element = node.getPsi();
        PsiElement property = XmlPropertyPlaceholderFoldingBuilder.resolveProperty(element);
        String text = null;
        if (property instanceof IProperty) {
            text = ((IProperty)property).getUnescapedValue();
        }
        if (text == null) {
            return null;
        }
        return text.trim().isEmpty() ? "<empty>" : text;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            XmlPropertyPlaceholderFoldingBuilder.$$$reportNull$$$0(8);
        }
        return true;
    }

    @Nullable
    private static PsiElement resolveProperty(PsiElement element) {
        for (PsiReference reference : XmlPropertyPlaceholderFoldingBuilder.getInnerReferences(element)) {
            ResolveResult[] results;
            if (!(reference instanceof PlaceholderPropertyReference) || (results = ((PlaceholderPropertyReference)reference).multiResolve(false)).length <= 0) continue;
            return results[0].getElement();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/folding/XmlPropertyPlaceholderFoldingBuilder";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/folding/XmlPropertyPlaceholderFoldingBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerReferences";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeForFolding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

