/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.folding;

import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.folding.XmlPropertyPlaceholderFoldingBuilder;
import com.intellij.spring.model.values.PlaceholderPropertyReference;
import com.intellij.util.SmartList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/spring/folding/CodePropertyPlaceholderFoldingBuilder;", "Lcom/intellij/spring/folding/XmlPropertyPlaceholderFoldingBuilder;", "()V", "buildFoldRegions", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Document;Z)[Lcom/intellij/lang/folding/FoldingDescriptor;", "getRangeForFolding", "Lcom/intellij/openapi/util/TextRange;", "element", "reference", "Lcom/intellij/spring/model/values/PlaceholderPropertyReference;", "intellij.spring.core"})
public final class CodePropertyPlaceholderFoldingBuilder
extends XmlPropertyPlaceholderFoldingBuilder {
    @Override
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (quick || !this.isEnabled() || !SpringLibraryUtil.hasSpringLibrary(root.getProject())) {
            Intrinsics.checkNotNullExpressionValue((Object)FoldingDescriptor.EMPTY, (String)"FoldingDescriptor.EMPTY");
            return FoldingDescriptor.EMPTY;
        }
        UElement uElement = UastContextKt.toUElement((PsiElement)root);
        if (uElement == null) {
            Intrinsics.checkNotNullExpressionValue((Object)FoldingDescriptor.EMPTY, (String)"FoldingDescriptor.EMPTY");
            return FoldingDescriptor.EMPTY;
        }
        UElement uFile = uElement;
        SmartList descriptors = new SmartList();
        uFile.accept((UastVisitor)new AbstractUastVisitor(this, descriptors){
            final /* synthetic */ CodePropertyPlaceholderFoldingBuilder this$0;
            final /* synthetic */ SmartList $descriptors;

            public boolean visitAnnotation(@NotNull UAnnotation node) {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (Intrinsics.areEqual((Object)node.getQualifiedName(), (Object)"org.springframework.beans.factory.annotation.Value") ^ true) {
                        return false;
                    }
                    UExpression uExpression = node.findDeclaredAttributeValue("value");
                    if (uExpression == null) {
                        return false;
                    }
                    UExpression value = uExpression;
                    PsiElement psiElement = value.getSourcePsi();
                    if (psiElement == null) {
                        return false;
                    }
                    PsiElement psi = psiElement;
                    FoldingDescriptor foldingDescriptor = this.this$0.createDescriptor(psi);
                    if (foldingDescriptor == null) break block3;
                    FoldingDescriptor foldingDescriptor2 = foldingDescriptor;
                    boolean bl = false;
                    boolean bl2 = false;
                    FoldingDescriptor it = foldingDescriptor2;
                    boolean bl3 = false;
                    this.$descriptors.add((Object)it);
                }
                return false;
            }
            {
                this.this$0 = this$0;
                this.$descriptors = $captured_local_variable$1;
            }
        });
        Collection $this$toTypedArray$iv = (Collection)descriptors;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        FoldingDescriptor[] foldingDescriptorArray = thisCollection$iv.toArray(new FoldingDescriptor[0]);
        if (foldingDescriptorArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return foldingDescriptorArray;
    }

    @Override
    @NotNull
    protected TextRange getRangeForFolding(@NotNull PsiElement element, @NotNull PlaceholderPropertyReference reference) {
        Integer n;
        block4: {
            TextRange refRange;
            block3: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)((Object)reference), (String)"reference");
                refRange = reference.getFullTextRange();
                String text = element.getText();
                String wrappedRefText = "${" + refRange.substring(text) + '}';
                String string = text;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                Integer n2 = StringsKt.indexOf$default((CharSequence)string, (String)wrappedRefText, (int)0, (boolean)false, (int)6, null);
                boolean bl = false;
                boolean bl2 = false;
                int it = ((Number)n2).intValue();
                boolean bl3 = false;
                n = it != -1 ? n2 : null;
                if (n == null) break block3;
                n2 = n;
                bl = false;
                bl2 = false;
                it = ((Number)n2).intValue();
                boolean bl4 = false;
                Character c = StringsKt.getOrNull((CharSequence)text, (int)(it - 1));
                TextRange textRange = c != null && c.charValue() == '\\' ? TextRange.from((int)(it - 1), (int)(wrappedRefText.length() + 1)) : TextRange.from((int)it, (int)wrappedRefText.length());
                n = textRange;
                if (textRange != null) break block4;
            }
            n = refRange;
        }
        Integer wrappedRefRange = n;
        TextRange textRange = element.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.textRange");
        TextRange textRange2 = wrappedRefRange.shiftRight(textRange.getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"wrappedRefRange.shiftRig\u2026nt.textRange.startOffset)");
        return textRange2;
    }
}

