/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.factories.resolvers.AbstractProxiedTypeResolver;
import com.intellij.spring.factories.resolvers.AbstractTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodInvokingFactoryBeanTypeResolver
extends AbstractProxiedTypeResolver {
    @Override
    @NotNull
    public Set<PsiType> getObjectType(@Nullable CommonSpringBean context) {
        PsiMethod[] methodsByName;
        PsiMethod[] psiMethodArray;
        int n;
        int n2;
        PsiClass psiClass;
        Module module;
        String methodName;
        SpringBean springBean;
        SpringPropertyDefinition targetMethod;
        if (context instanceof SpringBean && (targetMethod = SpringPropertyUtils.findPropertyByName(springBean = (SpringBean)context, "targetMethod")) != null && StringUtil.isNotEmpty((String)(methodName = targetMethod.getValueAsString())) && (module = context.getModule()) != null && (psiClass = MethodInvokingFactoryBeanTypeResolver.getMethodInvokingPsiClass(null, module.getProject(), springBean)) != null && (n2 = 0) < (n = (psiMethodArray = (methodsByName = psiClass.findMethodsByName(methodName, true))).length)) {
            PsiMethod method = psiMethodArray[n2];
            Set<PsiType> set = Collections.singleton(method.getReturnType());
            if (set == null) {
                MethodInvokingFactoryBeanTypeResolver.$$$reportNull$$$0(0);
            }
            return set;
        }
        Set<PsiType> set = Collections.emptySet();
        if (set == null) {
            MethodInvokingFactoryBeanTypeResolver.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Nullable
    public static PsiClass getMethodInvokingPsiClass(@Nullable GlobalSearchScope scope, @NotNull Project project, @NotNull SpringBean springBean) {
        String className;
        SpringPropertyDefinition targetClassProperty;
        SpringPropertyDefinition targetObjectProperty;
        if (project == null) {
            MethodInvokingFactoryBeanTypeResolver.$$$reportNull$$$0(2);
        }
        if (springBean == null) {
            MethodInvokingFactoryBeanTypeResolver.$$$reportNull$$$0(3);
        }
        if ((targetObjectProperty = SpringPropertyUtils.findPropertyByName(springBean, "targetObject")) != null) {
            PsiType[] types;
            SpringBean bean;
            SpringBeanPointer<?> springBeanPointer = targetObjectProperty.getRefValue();
            if (springBeanPointer != null) {
                PsiType[] types2 = MethodInvokingFactoryBeanTypeResolver.getEffectiveFactoryTypes(springBeanPointer.getSpringBean());
                if (types2.length == 1) {
                    return PsiTypesUtil.getPsiClass((PsiType)types2[0]);
                }
            } else if (targetObjectProperty instanceof SpringProperty && DomUtil.hasXml((DomElement)(bean = ((SpringProperty)targetObjectProperty).getBean())) && (types = MethodInvokingFactoryBeanTypeResolver.getEffectiveFactoryTypes(bean)).length == 1) {
                return PsiTypesUtil.getPsiClass((PsiType)types[0]);
            }
        }
        if ((targetClassProperty = SpringPropertyUtils.findPropertyByName(springBean, "targetClass")) != null && (className = targetClassProperty.getValueAsString()) != null) {
            return JavaPsiFacade.getInstance((Project)project).findClass(className, scope != null ? scope : GlobalSearchScope.allScope((Project)project));
        }
        return null;
    }

    private static PsiType @NotNull [] getEffectiveFactoryTypes(@NotNull CommonSpringBean bean) {
        if (bean == null) {
            MethodInvokingFactoryBeanTypeResolver.$$$reportNull$$$0(4);
        }
        PsiType[] psiTypeArray = AbstractTypeResolver.getEffectiveTypes(bean);
        if (psiTypeArray == null) {
            MethodInvokingFactoryBeanTypeResolver.$$$reportNull$$$0(5);
        }
        return psiTypeArray;
    }

    @Override
    public boolean accept(@NotNull String factoryClassName) {
        if (factoryClassName == null) {
            MethodInvokingFactoryBeanTypeResolver.$$$reportNull$$$0(6);
        }
        return "org.springframework.beans.factory.config.MethodInvokingFactoryBean".equals(factoryClassName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/factories/resolvers/MethodInvokingFactoryBeanTypeResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/factories/resolvers/MethodInvokingFactoryBeanTypeResolver";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveFactoryTypes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMethodInvokingPsiClass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveFactoryTypes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

