/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.spring.factories.resolvers.AbstractJeeSchemaTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.jee.JndiLookup;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JndiObjectFactoryBeanTypeResolver
extends AbstractJeeSchemaTypeResolver {
    @NonNls
    private static final String[] myProperties = new String[]{"proxyInterface", "expectedType"};

    @Override
    @NotNull
    protected Set<PsiType> getJeeObjectType(CommonSpringBean context) {
        if (context instanceof JndiLookup) {
            JndiLookup jndiLookup = (JndiLookup)context;
            PsiClass proxyInterface = (PsiClass)jndiLookup.getProxyInterface().getValue();
            if (proxyInterface != null) {
                return this.getSingletonCollection(proxyInterface);
            }
            PsiClass expectedType = (PsiClass)jndiLookup.getExpectedType().getValue();
            if (expectedType != null) {
                return this.getSingletonCollection(expectedType);
            }
        }
        Set<PsiType> set = Collections.emptySet();
        if (set == null) {
            JndiObjectFactoryBeanTypeResolver.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    private Set<PsiType> getSingletonCollection(@NotNull PsiClass proxyInterface) {
        if (proxyInterface == null) {
            JndiObjectFactoryBeanTypeResolver.$$$reportNull$$$0(1);
        }
        Set<PsiClassType> set = Collections.singleton(JavaPsiFacade.getElementFactory((Project)proxyInterface.getProject()).createType(proxyInterface));
        if (set == null) {
            JndiObjectFactoryBeanTypeResolver.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    protected List<String> getProperties() {
        return Arrays.asList(myProperties);
    }

    @Override
    protected List<String> getFactoryClasses() {
        return Collections.singletonList("org.springframework.jndi.JndiObjectFactoryBean");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/factories/resolvers/JndiObjectFactoryBeanTypeResolver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxyInterface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getJeeObjectType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/factories/resolvers/JndiObjectFactoryBeanTypeResolver";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingletonCollection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSingletonCollection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

