/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.validation;

import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.validation.SpringUnmappedConfigurationFilesCollector;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class UnmappedConfigurationFilesValidator
extends FacetEditorValidator {
    private static final int MAX_FILES_TO_SHOW = 5;
    private final Module myModule;

    public UnmappedConfigurationFilesValidator(Module module) {
        this.myModule = module;
    }

    @NotNull
    public ValidationResult check() {
        if (DumbService.isDumb((Project)this.myModule.getProject()) || !ProjectInspectionProfileManager.getInstance((Project)this.myModule.getProject()).isCurrentProfileInitialized()) {
            ValidationResult validationResult = ValidationResult.OK;
            if (validationResult == null) {
                UnmappedConfigurationFilesValidator.$$$reportNull$$$0(0);
            }
            return validationResult;
        }
        SpringUnmappedConfigurationFilesCollector collector = new SpringUnmappedConfigurationFilesCollector(this.myModule);
        if (!collector.isEnabledInProject()) {
            ValidationResult validationResult = ValidationResult.OK;
            if (validationResult == null) {
                UnmappedConfigurationFilesValidator.$$$reportNull$$$0(1);
            }
            return validationResult;
        }
        collector.collect();
        Collection unmappedFiles = collector.getResults().get((Object)this.myModule);
        if (unmappedFiles.isEmpty()) {
            ValidationResult validationResult = ValidationResult.OK;
            if (validationResult == null) {
                UnmappedConfigurationFilesValidator.$$$reportNull$$$0(2);
            }
            return validationResult;
        }
        if (unmappedFiles.size() <= 5) {
            String filesText = StringUtil.join((Collection)unmappedFiles, psiFile -> psiFile.getVirtualFile().getPresentableName(), (String)"<br/>");
            return new ValidationResult(SpringBundle.message("unmapped.configuration.files.full", unmappedFiles.size(), filesText));
        }
        return new ValidationResult(SpringBundle.message("unmapped.configuration.files.short", unmappedFiles.size()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/validation/UnmappedConfigurationFilesValidator", "check"));
    }
}

