/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.validation;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.facet.SpringFrameworkDetector;
import com.intellij.spring.facet.searchers.CodeConfigSearcher;
import com.intellij.spring.facet.searchers.XmlConfigSearcher;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.config.ConfigFileSearcher;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class SpringUnmappedConfigurationFilesCollector {
    private static final Logger LOG = Logger.getInstance(SpringUnmappedConfigurationFilesCollector.class);
    private static final String XML_CONFIG_INSPECTION = "SpringFacetInspection";
    private static final String CODE_CONFIG_INSPECTION = "SpringFacetCodeInspection";
    private final DetectionExcludesConfiguration myDetectionExcludesConfiguration;
    private final InspectionProfile myProfile;
    private final boolean myCheckXml;
    private final boolean myCheckCode;
    private final Module[] myModules;
    private final Project myProject;
    private final MultiMap<Module, PsiFile> myNotConfiguredStorage = MultiMap.createLinked();

    SpringUnmappedConfigurationFilesCollector(Module ... modules) {
        this.myModules = modules;
        assert (modules.length != 0);
        this.myProject = modules[0].getProject();
        this.myDetectionExcludesConfiguration = DetectionExcludesConfiguration.getInstance((Project)this.myProject);
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance((Project)this.myProject);
        this.myProfile = profileManager.getCurrentProfile();
        this.myCheckXml = this.myProfile.isToolEnabled(HighlightDisplayKey.find((String)XML_CONFIG_INSPECTION));
        this.myCheckCode = this.myProfile.isToolEnabled(HighlightDisplayKey.find((String)CODE_CONFIG_INSPECTION));
    }

    boolean isEnabledInProject() {
        return this.myCheckXml || this.myCheckCode;
    }

    void collect() {
        this.collect((ProgressIndicator)new EmptyProgressIndicator());
    }

    void collect(ProgressIndicator indicator) {
        SpringFileSetService fileSetService = SpringFileSetService.getInstance();
        long start = System.currentTimeMillis();
        LOG.debug("================= START ============ total modules #" + this.myModules.length);
        NullableFunction<VirtualFilePointer, PsiFile> virtualFileMapper = SpringUnmappedConfigurationFilesCollector.getVirtualFileMapper(this.myProject);
        HashSet<PsiFile> allKnownConfigurationFiles = new HashSet<PsiFile>();
        for (Module module : this.myModules) {
            indicator.checkCanceled();
            SpringFacet springFacet = SpringFacet.getInstance(module);
            if (springFacet == null) continue;
            for (SpringFileSet fileSet : fileSetService.getAllSets(springFacet)) {
                allKnownConfigurationFiles.addAll(ContainerUtil.mapNotNull(fileSet.getXmlFiles(), virtualFileMapper));
                allKnownConfigurationFiles.addAll(ContainerUtil.mapNotNull(fileSet.getCodeConfigurationFiles(), virtualFileMapper));
            }
        }
        LOG.debug("=== collected all known");
        boolean i = false;
        for (Module module : this.myModules) {
            List<PsiFile> files;
            indicator.checkCanceled();
            if (this.myCheckXml) {
                files = this.collectNotConfigured(indicator, allKnownConfigurationFiles, new XmlConfigSearcher(module, false), module);
                this.myNotConfiguredStorage.putValues((Object)module, files);
            }
            if (!this.myCheckCode) continue;
            files = this.collectNotConfigured(indicator, allKnownConfigurationFiles, new CodeConfigSearcher(module, false), module);
            this.myNotConfiguredStorage.putValues((Object)module, files);
        }
        LOG.debug("=== collected not configured");
        Set<PsiFile> filesUsedInSpringModels = this.getFilesUsedImplicitlyInSpringModels(indicator, this.myNotConfiguredStorage);
        for (Map.Entry entry : this.myNotConfiguredStorage.entrySet()) {
            ((Collection)entry.getValue()).removeAll(filesUsedInSpringModels);
        }
        LOG.debug("=== processed implicit spring model");
        Set<PsiFile> filesUsedImplicitlyAsStereotype = SpringUnmappedConfigurationFilesCollector.getFilesUsedImplicitlyAsStereotype(indicator, this.myNotConfiguredStorage);
        for (Map.Entry entry : this.myNotConfiguredStorage.entrySet()) {
            ((Collection)entry.getValue()).removeAll(filesUsedImplicitlyAsStereotype);
        }
        LOG.debug("================= END ============  total time: " + (System.currentTimeMillis() - start));
    }

    MultiMap<Module, PsiFile> getResults() {
        return this.myNotConfiguredStorage;
    }

    private List<PsiFile> collectNotConfigured(ProgressIndicator indicator, Set<PsiFile> allKnownConfigurationFiles, ConfigFileSearcher searcher, Module module) {
        searcher.search();
        Collection files = searcher.getFilesByModules().get((Object)module);
        SmartList notConfigured = new SmartList();
        for (PsiFile file : files) {
            PsiClass[] classes;
            if (allKnownConfigurationFiles.contains(file)) continue;
            indicator.checkCanceled();
            if (this.myDetectionExcludesConfiguration.isExcludedFromDetection(file.getVirtualFile(), SpringFrameworkDetector.getSpringFrameworkType()) || file instanceof XmlFile && this.skipConfigInspectionFor((PsiElement)file, XML_CONFIG_INSPECTION) || file instanceof PsiClassOwner && (classes = ((PsiClassOwner)file).getClasses()).length == 1 && this.skipConfigInspectionFor((PsiElement)classes[0], CODE_CONFIG_INSPECTION)) continue;
            notConfigured.add(file);
        }
        return notConfigured;
    }

    private boolean skipConfigInspectionFor(PsiElement place, String toolId) {
        HighlightDisplayKey toolHighlightDisplayKey = HighlightDisplayKey.find((String)toolId);
        if (!this.myProfile.isToolEnabled(toolHighlightDisplayKey, place)) {
            return true;
        }
        InspectionProfileEntry tool = this.myProfile.getUnwrappedTool(toolId, place);
        if (tool == null) {
            return true;
        }
        return SuppressionUtil.inspectionResultSuppressed((PsiElement)place, (InspectionProfileEntry)tool);
    }

    private Set<PsiFile> getFilesUsedImplicitlyInSpringModels(ProgressIndicator indicator, MultiMap<Module, PsiFile> notConfigured) {
        Collection allNotConfiguredFiles = notConfigured.values();
        if (allNotConfiguredFiles.isEmpty()) {
            return Collections.emptySet();
        }
        indicator.setText2(SpringBundle.message("searching.for.implicit.usages", new Object[0]));
        indicator.setFraction(0.0);
        int i = 0;
        int moduleCount = notConfigured.size();
        LOG.debug("=== implicit spring model  modules #" + moduleCount + " total files #" + allNotConfiguredFiles.size());
        SpringManager springManager = SpringManager.getInstance(this.myProject);
        int moduleIdx = 0;
        HashSet<PsiFile> found = new HashSet<PsiFile>();
        for (Map.Entry entry : notConfigured.entrySet()) {
            Module module = (Module)entry.getKey();
            Collection notConfiguredFiles = (Collection)entry.getValue();
            LOG.debug("=== processing " + ++moduleIdx + " files #" + notConfiguredFiles.size());
            ModuleUtilCore.visitMeAndDependentModules((Module)module, visitModule -> {
                Set<SpringModel> models = springManager.getAllModelsWithoutDependencies(visitModule);
                for (SpringModel model : models) {
                    if (model.getFileSet() == null) continue;
                    indicator.checkCanceled();
                    for (PsiFile configFile : SpringModelVisitorUtils.getConfigFiles(model)) {
                        if (!notConfiguredFiles.contains(configFile)) continue;
                        found.add(configFile);
                        if (!found.containsAll(notConfiguredFiles)) continue;
                        return false;
                    }
                }
                return true;
            });
            if (found.containsAll(allNotConfiguredFiles)) {
                LOG.debug("=== early exit");
                return found;
            }
            indicator.setFraction((double)i++ / (double)moduleCount);
        }
        return found;
    }

    private static Set<PsiFile> getFilesUsedImplicitlyAsStereotype(ProgressIndicator indicator, MultiMap<Module, PsiFile> notConfigured) {
        if (notConfigured.isEmpty()) {
            return Collections.emptySet();
        }
        LOG.debug("=== collected implicit stereotype   remaining modules #" + notConfigured.size());
        indicator.setText2(SpringBundle.message("searching.for.stereotype.usages", new Object[0]));
        indicator.setFraction(0.0);
        int totalNotConfiguredStereoTypes = 0;
        HashMap<Module, List> notConfiguredStereotypes = new HashMap<Module, List>();
        for (Map.Entry entry : notConfigured.entrySet()) {
            Collection configFiles = (Collection)entry.getValue();
            List psiClassOwners = ContainerUtil.findAll((Collection)configFiles, PsiClassOwner.class);
            if (psiClassOwners.isEmpty()) continue;
            notConfiguredStereotypes.put((Module)entry.getKey(), psiClassOwners);
            totalNotConfiguredStereoTypes += psiClassOwners.size();
        }
        int moduleIdx = 0;
        int processed = 0;
        HashSet<PsiFile> foundStereoTypeConfigFiles = new HashSet<PsiFile>();
        for (Map.Entry entry : notConfiguredStereotypes.entrySet()) {
            Module module = (Module)entry.getKey();
            List psiClassOwners = (List)entry.getValue();
            Set<SpringModel> allModels = SpringManager.getInstance(module.getProject()).getAllModels(module);
            LOG.debug("=== processing " + ++moduleIdx + " with " + allModels.size() + " models, PCO #" + psiClassOwners.size());
            for (PsiClassOwner psiClassOwner : psiClassOwners) {
                SpringModelSearchParameters.BeanClass params;
                PsiClass[] classes = psiClassOwner.getClasses();
                if (classes.length == 0) continue;
                PsiClass configClass = classes[0];
                LOG.debug("  " + configClass);
                if (!SpringCommonUtils.isSpringBeanCandidateClass(configClass) || !(params = SpringModelSearchParameters.byClass(configClass)).canSearch()) continue;
                for (CommonSpringModel commonSpringModel : allModels) {
                    LOG.debug("  in " + commonSpringModel);
                    indicator.checkCanceled();
                    if (!SpringModelSearchers.doesBeanExist(commonSpringModel, params)) continue;
                    foundStereoTypeConfigFiles.add((PsiFile)psiClassOwner);
                    break;
                }
                indicator.setFraction((double)processed++ / (double)totalNotConfiguredStereoTypes);
                LOG.debug("   processed: " + processed);
            }
        }
        return foundStereoTypeConfigFiles;
    }

    static NullableFunction<VirtualFilePointer, PsiFile> getVirtualFileMapper(@NotNull Project project) {
        if (project == null) {
            SpringUnmappedConfigurationFilesCollector.$$$reportNull$$$0(0);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        return pointer -> pointer.isValid() && pointer.getFile() != null ? psiManager.findFile(pointer.getFile()) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/facet/validation/SpringUnmappedConfigurationFilesCollector", "getVirtualFileMapper"));
    }
}

