/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.validation;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelProvider;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.facet.SpringFileSetServiceImpl;
import com.intellij.spring.facet.SpringFrameworkDetector;
import com.intellij.spring.facet.validation.SpringProgrammaticConfigurationCollector;
import com.intellij.spring.facet.validation.SpringUnmappedConfigurationFilesCollector;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringConfigurationCheckTask
extends Task.Backgroundable {
    private static final String NOTIFICATION_ID = "Spring Configuration Check";
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Spring Configuration Check", NotificationDisplayType.STICKY_BALLOON, true);
    private volatile List<Pair<Module, Collection<VirtualFilePointer>>> myUnmappedConfigurations;
    private volatile SmartPsiElementPointer<?>[] myProgrammaticConfigurations;

    SpringConfigurationCheckTask(Project project) {
        super(project, SpringBundle.message("spring.configuration.check", new Object[0]));
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            SpringConfigurationCheckTask.$$$reportNull$$$0(0);
        }
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        if (modules.length == 0) {
            return;
        }
        SpringUnmappedConfigurationFilesCollector unmappedCollector = new SpringUnmappedConfigurationFilesCollector(modules);
        if (unmappedCollector.isEnabledInProject()) {
            ArrayList result = new ArrayList();
            indicator.setIndeterminate(false);
            int i = 0;
            for (Module module : modules) {
                indicator.setText2(SpringBundle.message("checking.spring.configuration", module));
                this.runCollector(progressIndicator -> this.runUnmappedCollector((ProgressIndicator)progressIndicator, module, result), indicator);
                indicator.setFraction((double)i++ / (double)modules.length);
            }
            this.myUnmappedConfigurations = new ArrayList<Pair<Module, Collection<VirtualFilePointer>>>(result);
        }
        if (ApplicationManager.getApplication().isInternal()) {
            this.runCollector(this::runProgrammaticCollector, indicator);
        }
        snapshot.logResponsivenessSinceCreation("Spring Config Check [" + modules.length + " modules]");
    }

    private void runCollector(Consumer<ProgressIndicator> runner, ProgressIndicator indicator) {
        ReadAction.nonBlocking(() -> runner.accept(ProgressIndicatorProvider.getGlobalProgressIndicator())).inSmartMode(this.myProject).wrapProgress(indicator).executeSynchronously();
    }

    private void runUnmappedCollector(ProgressIndicator indicator, Module module, List<Pair<Module, Collection<VirtualFilePointer>>> result) {
        SpringUnmappedConfigurationFilesCollector unmappedCollector = new SpringUnmappedConfigurationFilesCollector(module);
        unmappedCollector.collect(indicator);
        result.add(SpringConfigurationCheckTask.createPair(module, unmappedCollector.getResults().get((Object)module)));
    }

    private void runProgrammaticCollector(ProgressIndicator indicator) {
        SpringProgrammaticConfigurationCollector programmaticCollector = new SpringProgrammaticConfigurationCollector(this.getProject());
        if (programmaticCollector.isEnabledInProject()) {
            programmaticCollector.collect(indicator);
            this.myProgrammaticConfigurations = (SmartPsiElementPointer[])ContainerUtil.map2Array(programmaticCollector.getResults(), SmartPsiElementPointer.class, SmartPointerManager::createPointer);
        }
    }

    public void onSuccess() {
        MultiMap<Module, VirtualFilePointer> unmappedResults;
        if (this.getProject().isDisposed()) {
            return;
        }
        List programmaticResults = this.myProgrammaticConfigurations == null ? Collections.emptyList() : ContainerUtil.mapNotNull((Object[])this.myProgrammaticConfigurations, pointer -> {
            PsiElement element = pointer.getElement();
            return element == null ? null : Pair.create((Object)pointer, (Object)element);
        });
        MultiMap<Module, VirtualFilePointer> multiMap = unmappedResults = this.myUnmappedConfigurations == null ? MultiMap.empty() : SpringConfigurationCheckTask.filterEmptyConfigurations(this.getProject(), this.myUnmappedConfigurations);
        if (unmappedResults.isEmpty() && programmaticResults.isEmpty()) {
            return;
        }
        StringBuilder notification = new StringBuilder();
        if (!unmappedResults.isEmpty()) {
            StringBuilder unmappedFilesText = new StringBuilder();
            boolean atLeastOneModuleWithoutFacet = false;
            for (Map.Entry entry : unmappedResults.entrySet()) {
                Module module = (Module)entry.getKey();
                String moduleName = module.getName();
                Collection pointers = (Collection)entry.getValue();
                int filesCount = pointers.size();
                unmappedFilesText.append("<a href=\"config#").append(moduleName).append("\">").append(moduleName).append("</a>");
                unmappedFilesText.append(" (<a href=\"files#").append(moduleName).append("\">").append(SpringBundle.message("unmapped.configuration.files.count", filesCount)).append("</a>)");
                SpringFacet springFacet = SpringFacet.getInstance(module);
                if (springFacet == null || springFacet.getFileSets().isEmpty()) {
                    unmappedFilesText.append("&nbsp;&nbsp;&nbsp;<a href=\"createDefault#").append(moduleName).append("\">").append(SpringBundle.message("unmapped.configuration.create.default.context", new Object[0])).append("</a>");
                    atLeastOneModuleWithoutFacet = true;
                }
                unmappedFilesText.append("<br/>");
            }
            String fixInstruction = atLeastOneModuleWithoutFacet ? SpringBundle.message("unmapped.configuration.fix.instruction", SpringBundle.message("unmapped.configuration.create.default.context", new Object[0])) : SpringBundle.message("unmapped.configuration.configure.facet", new Object[0]);
            notification.append(SpringBundle.message("unmapped.configuration.files.found", new Object[0])).append("<br/><br/>").append(fixInstruction).append("<br/><br/>").append((CharSequence)unmappedFilesText);
        }
        if (!programmaticResults.isEmpty()) {
            notification.append(notification.length() > 0 ? "<br/>" : "").append(SpringBundle.message("unmapped.configuration.programmatic.contexts.found", new Object[0])).append("<br/>");
            for (int i = 0; i < programmaticResults.size(); ++i) {
                PsiElement psiElement = (PsiElement)((Pair)programmaticResults.get((int)i)).second;
                PsiFile psiFile = psiElement.getContainingFile();
                notification.append("<a href=\"psi#").append(i).append("\">").append(psiFile.getName()).append("</a><br/>");
            }
        }
        @NlsSafe String notificationText = notification.toString();
        NOTIFICATION_GROUP.createNotification(SpringBundle.message("spring.configuration.check", new Object[0]), notificationText, NotificationType.WARNING).setListener((NotificationListener)new UnmappedConfigurationsNotificationAdapter(this.getProject(), unmappedResults, ContainerUtil.map((Collection)programmaticResults, pair -> (SmartPsiElementPointer)pair.first))).addAction((AnAction)new NotificationAction(SpringBundle.message("spring.facet.validation.help.action", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    2.$$$reportNull$$$0(1);
                }
                HelpManager.getInstance().invokeHelp("spring.managing.file.sets");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/spring/facet/validation/SpringConfigurationCheckTask$2";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).addAction((AnAction)new NotificationAction(SpringBundle.message("spring.facet.validation.disable.action", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                int result;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((result = Messages.showYesNoDialog((Project)SpringConfigurationCheckTask.this.getProject(), (String)SpringBundle.message("spring.facet.detection.will.be.disabled.for.whole.project", new Object[0]), (String)SpringBundle.message("spring.facet.config.detection", new Object[0]), (String)SpringBundle.message("spring.facet/detection.disable.detection", new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon())) == 0) {
                    DetectionExcludesConfiguration detectionExcludesConfiguration = DetectionExcludesConfiguration.getInstance((Project)SpringConfigurationCheckTask.this.getProject());
                    detectionExcludesConfiguration.addExcludedFramework(SpringFrameworkDetector.getSpringFrameworkType());
                    notification.hideBalloon();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/spring/facet/validation/SpringConfigurationCheckTask$1";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).setIcon(SpringApiIcons.Spring).notify(this.getProject());
    }

    private static Pair<Module, Collection<VirtualFilePointer>> createPair(Module module, Collection<PsiFile> files) {
        List pointers = ContainerUtil.map(files, file -> VirtualFilePointerManager.getInstance().create(file.getVirtualFile(), (Disposable)SpringManager.getInstance(file.getProject()), null));
        return Pair.create((Object)module, (Object)pointers);
    }

    private static MultiMap<Module, VirtualFilePointer> filterEmptyConfigurations(Project project, List<Pair<Module, Collection<VirtualFilePointer>>> unmappedConfigurations) {
        NullableFunction<VirtualFilePointer, PsiFile> virtualFileMapper = SpringUnmappedConfigurationFilesCollector.getVirtualFileMapper(project);
        MultiMap result = new MultiMap();
        for (Pair<Module, Collection<VirtualFilePointer>> entry : unmappedConfigurations) {
            List pointers;
            if (((Collection)entry.second).isEmpty() || (pointers = ContainerUtil.filter((Collection)((Collection)entry.second), pointer -> virtualFileMapper.fun(pointer) != null)).isEmpty()) continue;
            result.put((Object)((Module)entry.first), (Collection)pointers);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/spring/facet/validation/SpringConfigurationCheckTask", "run"));
    }

    private static final class UnmappedConfigurationsNotificationAdapter
    extends NotificationListener.Adapter {
        private final Project myProject;
        private final MultiMap<Module, VirtualFilePointer> myUnmappedConfigurations;
        private final List<SmartPsiElementPointer<?>> myProgrammaticConfigurations;

        private UnmappedConfigurationsNotificationAdapter(Project project, MultiMap<Module, VirtualFilePointer> unmappedConfigurations, List<SmartPsiElementPointer<?>> programmaticConfigurations) {
            this.myProject = project;
            this.myUnmappedConfigurations = unmappedConfigurations;
            this.myProgrammaticConfigurations = programmaticConfigurations;
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            if (notification == null) {
                UnmappedConfigurationsNotificationAdapter.$$$reportNull$$$0(0);
            }
            if (e == null) {
                UnmappedConfigurationsNotificationAdapter.$$$reportNull$$$0(1);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            String description = e.getDescription();
            String navigationTarget = StringUtil.substringAfter((String)description, (String)"#");
            assert (navigationTarget != null);
            if (description.startsWith("config")) {
                Module module = this.findModuleByName(navigationTarget);
                if (module == null) {
                    return;
                }
                SpringFacet springFacet = SpringFacet.getInstance(module);
                if (springFacet != null) {
                    ModulesConfigurator.showFacetSettingsDialog((Facet)springFacet, null);
                } else {
                    ModulesConfigurator.showDialog((Project)this.myProject, (String)navigationTarget, null);
                }
                this.updateNotification(notification);
            } else if (description.startsWith("createDefault")) {
                Module module = this.findModuleByName(navigationTarget);
                if (module == null) {
                    return;
                }
                DumbService dumbService = DumbService.getInstance((Project)this.myProject);
                if (dumbService.isDumb()) {
                    dumbService.showDumbModeNotification(SpringBundle.message("unmapped.configuration.is.not.available.during.index.update", SpringBundle.message("unmapped.configuration.create.default.context", new Object[0])));
                    return;
                }
                SpringFacet springFacet = SpringFacet.getInstance(module);
                if (springFacet == null) {
                    springFacet = (SpringFacet)FacetUtil.addFacet((Module)module, SpringFacet.getSpringFacetType());
                }
                for (SpringModelProvider provider : (SpringModelProvider[])SpringFileSetServiceImpl.SPRING_MODEL_PROVIDER_EP_NAME.getExtensions()) {
                    if (provider.getFilesets(springFacet).isEmpty()) continue;
                    int result = Messages.showYesNoDialog((Project)this.myProject, (String)SpringBundle.message("unmapped.configuration.autodetected.context.found.for", provider.getName()), (String)SpringBundle.message("unmapped.configuration.spring.configuration", new Object[0]), (String)SpringBundle.message("unmapped.configuration.open.facet.configuration", new Object[0]), (String)CommonBundle.getCloseButtonText(), (Icon)Messages.getInformationIcon());
                    if (result == 0) {
                        ModulesConfigurator.showFacetSettingsDialog((Facet)springFacet, null);
                    }
                    this.updateNotification(notification);
                    return;
                }
                Set<SpringFileSet> existingFileSets = Collections.emptySet();
                String id = SpringFileSetService.getInstance().getUniqueId(existingFileSets);
                String name = SpringFileSetService.getInstance().getUniqueName(SpringBundle.message("facet.context.default.name", new Object[0]), existingFileSets);
                SpringFileSet fileSet = springFacet.addFileSet(id, name);
                Collection pointers = this.myUnmappedConfigurations.get((Object)module);
                NullableFunction<VirtualFilePointer, PsiFile> virtualFileMapper = SpringUnmappedConfigurationFilesCollector.getVirtualFileMapper(module.getProject());
                for (VirtualFilePointer pointer : pointers) {
                    PsiFile psiFile = (PsiFile)virtualFileMapper.fun((Object)pointer);
                    if (psiFile == null) continue;
                    fileSet.addFile(psiFile.getVirtualFile());
                }
                FacetManager.getInstance((Module)module).facetConfigurationChanged((Facet)springFacet);
                this.updateNotification(notification);
            } else if (description.startsWith("files")) {
                Module module = this.findModuleByName(navigationTarget);
                if (module == null) {
                    return;
                }
                NullableFunction<VirtualFilePointer, PsiFile> virtualFileMapper = SpringUnmappedConfigurationFilesCollector.getVirtualFileMapper(module.getProject());
                List files = ContainerUtil.mapNotNull((Collection)this.myUnmappedConfigurations.get((Object)module), virtualFileMapper);
                if (files.isEmpty()) {
                    JBPopupFactory.getInstance().createMessage(SpringBundle.message("config.files.not.found", new Object[0])).showInFocusCenter();
                    return;
                }
                JBPopup popup = NavigationUtil.getPsiElementPopup((PsiElement[])((PsiElement[])files.toArray(PsiFile.EMPTY_ARRAY)), (String)SpringBundle.message("config.unmapped.configs.popup.title", navigationTarget));
                Object event = e.getSource();
                if (event instanceof Component) {
                    popup.showInCenterOf((Component)event);
                } else {
                    popup.showInFocusCenter();
                }
            } else if (description.startsWith("psi")) {
                PsiElement element = this.myProgrammaticConfigurations.get(Integer.parseInt(navigationTarget)).getElement();
                if (element != null) {
                    NavigationUtil.activateFileWithPsiElement((PsiElement)element);
                } else {
                    JBPopupFactory.getInstance().createMessage(SpringBundle.message("config.file.not.found", new Object[0])).showInFocusCenter();
                }
            }
        }

        private void updateNotification(@NotNull Notification notification) {
            if (notification == null) {
                UnmappedConfigurationsNotificationAdapter.$$$reportNull$$$0(2);
            }
            notification.expire();
            ApplicationManager.getApplication().invokeLater(() -> new SpringConfigurationCheckTask(this.myProject).queue(), this.myProject.getDisposed());
        }

        @Nullable
        private Module findModuleByName(String navigationTarget) {
            return ModuleManager.getInstance((Project)this.myProject).findModuleByName(navigationTarget);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spring/facet/validation/SpringConfigurationCheckTask$UnmappedConfigurationsNotificationAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkActivated";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateNotification";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

