/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class SpringFileSetData {
    private final String myId;
    private String myName;
    private final List<String> myFiles;
    private final Set<String> myDependencies;
    private Set<String> myActiveProfiles;
    private boolean myRemoved;

    static SpringFileSetData create(@NonNls @NotNull String id, @NotNull String name) {
        if (id == null) {
            SpringFileSetData.$$$reportNull$$$0(0);
        }
        if (name == null) {
            SpringFileSetData.$$$reportNull$$$0(1);
        }
        return new SpringFileSetData(id, name);
    }

    private SpringFileSetData(@NonNls @NotNull String id, @NotNull String name) {
        if (id == null) {
            SpringFileSetData.$$$reportNull$$$0(2);
        }
        if (name == null) {
            SpringFileSetData.$$$reportNull$$$0(3);
        }
        this.myFiles = new SmartList();
        this.myDependencies = new LinkedHashSet<String>();
        this.myActiveProfiles = new LinkedHashSet<String>();
        this.myId = id;
        this.myName = name;
    }

    public boolean isRemoved() {
        return this.myRemoved;
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            SpringFileSetData.$$$reportNull$$$0(4);
        }
        return string;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            SpringFileSetData.$$$reportNull$$$0(5);
        }
        this.myName = name;
    }

    @NotNull
    public List<String> getFiles() {
        List<String> list = this.myFiles;
        if (list == null) {
            SpringFileSetData.$$$reportNull$$$0(6);
        }
        return list;
    }

    public void setActiveProfiles(@NotNull Set<String> activeProfiles) {
        if (activeProfiles == null) {
            SpringFileSetData.$$$reportNull$$$0(7);
        }
        this.myActiveProfiles = activeProfiles;
    }

    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = this.myActiveProfiles;
        if (set == null) {
            SpringFileSetData.$$$reportNull$$$0(8);
        }
        return set;
    }

    public Set<String> getDependencies() {
        return this.myDependencies;
    }

    public void addDependency(String dep) {
        this.myDependencies.add(dep);
    }

    public void addFile(@NonNls String url) {
        if (!StringUtil.isEmptyOrSpaces((String)url)) {
            this.myFiles.add(url);
        }
    }

    public void removeFile(@NonNls String url) {
        this.myFiles.remove(url);
    }

    void setRemoved(boolean removed) {
        this.myRemoved = removed;
    }

    public static SpringFileSetData create(SpringFileSetData original) {
        SpringFileSetData springFileSetData = new SpringFileSetData(original.getId(), original.getName());
        springFileSetData.setRemoved(original.isRemoved());
        springFileSetData.getDependencies().addAll(original.getDependencies());
        springFileSetData.getFiles().addAll(original.getFiles());
        springFileSetData.getActiveProfiles().addAll(original.getActiveProfiles());
        return springFileSetData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpringFileSetData data = (SpringFileSetData)o;
        if (!this.myId.equals(data.myId)) {
            return false;
        }
        return !(this.myName != null ? !this.myName.equals(data.myName) : data.myName != null);
    }

    public int hashCode() {
        int result = this.myId.hashCode();
        result = 31 * result + (this.myName != null ? this.myName.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/facet/SpringFileSetData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/facet/SpringFileSetData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveProfiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setActiveProfiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

