/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFacetConfigurationImpl;
import com.intellij.spring.facet.SpringFacetImpl;
import com.intellij.spring.facet.SpringFileSetEditorCustomization;
import com.intellij.spring.facet.beans.CustomSetting;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SpringFacetType
extends FacetType<SpringFacet, SpringFacetConfiguration> {
    SpringFacetType() {
        super(SpringFacet.FACET_TYPE_ID, "Spring", SpringBundle.message("spring", new Object[0]));
        SpringFileSetEditorCustomization.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<SpringFileSetEditorCustomization>(){

            public void extensionAdded(@NotNull SpringFileSetEditorCustomization customization, @NotNull PluginDescriptor pluginDescriptor) {
                if (customization == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.forEachSpringFacet(facet -> {
                    Set<CustomSetting> customSettings = ((SpringFacetConfiguration)facet.getConfiguration()).getCustomSettings();
                    boolean modified = customSettings.addAll(customization.getCustomSettings());
                    if (modified) {
                        this.setModified((SpringFacet)((Object)facet));
                    }
                });
            }

            private void forEachSpringFacet(Consumer<SpringFacet> consumer) {
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                        SpringFacet facet = SpringFacet.getInstance(module);
                        if (facet == null) continue;
                        consumer.accept(facet);
                    }
                }
            }

            private void setModified(SpringFacet facet) {
                ((SpringFacetConfiguration)facet.getConfiguration()).setModified();
                FacetManager.getInstance((Module)facet.getModule()).facetConfigurationChanged((Facet)facet);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "customization";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/spring/facet/SpringFacetType$1";
                objectArray[2] = "extensionAdded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    public SpringFacetConfiguration createDefaultConfiguration() {
        return new SpringFacetConfigurationImpl();
    }

    public SpringFacet createFacet(@NotNull Module module, String name, @NotNull SpringFacetConfiguration configuration, Facet underlyingFacet) {
        if (module == null) {
            SpringFacetType.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            SpringFacetType.$$$reportNull$$$0(1);
        }
        return new SpringFacetImpl(this, module, name, configuration, underlyingFacet);
    }

    public boolean isSuitableModuleType(ModuleType moduleType) {
        return moduleType instanceof JavaModuleType;
    }

    public Icon getIcon() {
        return SpringApiIcons.Spring;
    }

    public String getHelpTopic() {
        return "IntelliJ.IDEA.Procedures.Java.EE.Development.Managing.Facets.Facet.Specific.Settings.Spring";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/facet/SpringFacetType";
        objectArray[2] = "createFacet";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

