/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.facet.impl.ui.FacetEditorsFactoryImpl;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.libraries.FrameworkLibraryValidator;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.facet.SpringConfigurationTab;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetData;
import com.intellij.spring.facet.SpringFileSetEditorCustomization;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.spring.library.SpringLibraryType;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringFacetConfigurationImpl
extends SimpleModificationTracker
implements SpringFacetConfiguration {
    @NonNls
    private static final String FILESET = "fileset";
    @NonNls
    private static final String SET_ID = "id";
    @NonNls
    private static final String ACTIVE_PROFILES = "profiles";
    @NonNls
    private static final String SET_NAME = "name";
    @NonNls
    private static final String SET_REMOVED = "removed";
    @NonNls
    private static final String FILE = "file";
    @NonNls
    private static final String DEPENDENCY = "dependency";
    @NonNls
    private static final String AUTODETECTED = "autodetected";
    private final Set<SpringFileSetData> myFileSets = new LinkedHashSet<SpringFileSetData>();
    private final NotNullLazyValue<Set<CustomSetting>> myCustomSettings = NotNullLazyValue.atomicLazy(() -> {
        LinkedHashSet<CustomSetting> myCustomSettings = new LinkedHashSet<CustomSetting>();
        myCustomSettings.add(new CustomSetting.BOOLEAN(LocalXmlModel.PROCESS_EXPLICITLY_ANNOTATED, SpringBundle.message("process.explicitly.annotated.beans", new Object[0]), true));
        for (SpringFileSetEditorCustomization customization : (SpringFileSetEditorCustomization[])SpringFileSetEditorCustomization.EP_NAME.getExtensions()) {
            myCustomSettings.addAll(customization.getCustomSettings());
        }
        return myCustomSettings;
    });
    private final SortedMap<String, String> myAutodetectedFileSetProfiles = new TreeMap<String, String>();
    private final SimpleModificationTracker mySettingsModificationTracker = new SimpleModificationTracker();

    @NotNull
    Set<SpringFileSetData> getFileSetDescriptors() {
        Set<SpringFileSetData> set = Collections.unmodifiableSet(this.myFileSets);
        if (set == null) {
            SpringFacetConfigurationImpl.$$$reportNull$$$0(0);
        }
        return set;
    }

    boolean addSpringFileSetData(@NotNull SpringFileSetData fileSet) {
        if (fileSet == null) {
            SpringFacetConfigurationImpl.$$$reportNull$$$0(1);
        }
        this.incSettingsModificationCount();
        return this.myFileSets.add(fileSet);
    }

    public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        FrameworkLibraryValidator validator = FacetEditorsFactoryImpl.getInstanceImpl().createLibraryValidator(DownloadableLibraryService.getInstance().createDescriptionForType(SpringLibraryType.class), editorContext, validatorsManager, "spring");
        validatorsManager.registerValidator((FacetEditorValidator)validator, new JComponent[0]);
        return new FacetEditorTab[]{new SpringConfigurationTab(editorContext, validatorsManager)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(Element element) throws InvalidDataException {
        for (Element setElement : element.getChildren(FILESET)) {
            Object dep2;
            String auto = setElement.getAttributeValue(AUTODETECTED);
            if (auto != null && Boolean.parseBoolean(auto)) {
                String setId = setElement.getAttributeValue(SET_ID);
                String activeProfiles = setElement.getAttributeValue(ACTIVE_PROFILES);
                if (setId == null || activeProfiles == null) continue;
                SortedMap<String, String> sortedMap = this.myAutodetectedFileSetProfiles;
                synchronized (sortedMap) {
                    this.myAutodetectedFileSetProfiles.put(setId, activeProfiles);
                    continue;
                }
            }
            String setName = setElement.getAttributeValue(SET_NAME);
            String setId = setElement.getAttributeValue(SET_ID);
            String removed = setElement.getAttributeValue(SET_REMOVED);
            if (setName == null || setId == null) continue;
            SpringFileSetData fileSet = SpringFileSetData.create(setId, setName);
            List deps = setElement.getChildren(DEPENDENCY);
            for (Object dep2 : deps) {
                fileSet.addDependency(dep2.getText());
            }
            List files = setElement.getChildren(FILE);
            dep2 = files.iterator();
            while (dep2.hasNext()) {
                Element fileElement = (Element)dep2.next();
                String text = fileElement.getText();
                fileSet.addFile(text);
            }
            fileSet.setRemoved(Boolean.valueOf(removed));
            this.addSpringFileSetData(fileSet);
            String activeProfiles = setElement.getAttributeValue(ACTIVE_PROFILES);
            if (!StringUtil.isNotEmpty((String)activeProfiles)) continue;
            fileSet.setActiveProfiles(new LinkedHashSet<String>(StringUtil.split((String)activeProfiles, (String)",")));
        }
        for (CustomSetting settingBean : this.getCustomSettings()) {
            String name = settingBean.getName();
            String s = element.getAttributeValue(name);
            if (s == null) continue;
            settingBean.setStringValue(s);
            settingBean.apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(Element element) throws WriteExternalException {
        for (SpringFileSetData fileSet : this.myFileSets) {
            Element setElement = new Element(FILESET);
            setElement.setAttribute(SET_ID, fileSet.getId());
            setElement.setAttribute(SET_NAME, fileSet.getName());
            setElement.setAttribute(SET_REMOVED, Boolean.toString(fileSet.isRemoved()));
            element.addContent(setElement);
            for (String dep : fileSet.getDependencies()) {
                Element depElement = new Element(DEPENDENCY);
                depElement.setText(dep);
                setElement.addContent(depElement);
            }
            for (String url : fileSet.getFiles()) {
                Element fileElement = new Element(FILE);
                fileElement.setText(url);
                setElement.addContent(fileElement);
            }
            Set<String> activeProfiles = fileSet.getActiveProfiles();
            if (activeProfiles.size() <= 0) continue;
            setElement.setAttribute(ACTIVE_PROFILES, StringUtil.join(activeProfiles, (String)","));
        }
        for (CustomSetting customSetting : this.getCustomSettings()) {
            if (customSetting.getStringValue() == null) continue;
            element.setAttribute(customSetting.getName(), customSetting.getStringValue());
        }
        SortedMap<String, String> sortedMap = this.myAutodetectedFileSetProfiles;
        synchronized (sortedMap) {
            for (Map.Entry<String, String> entry : this.myAutodetectedFileSetProfiles.entrySet()) {
                if (!StringUtil.isNotEmpty((String)entry.getValue())) continue;
                Element setElement = new Element(FILESET);
                setElement.setAttribute(SET_ID, entry.getKey());
                setElement.setAttribute(ACTIVE_PROFILES, entry.getValue());
                setElement.setAttribute(AUTODETECTED, "true");
                element.addContent(setElement);
            }
        }
    }

    @Override
    public void setModified() {
        this.incSettingsModificationCount();
    }

    public void dispose() {
    }

    @Override
    public synchronized void registerAutodetectedFileSet(@NotNull SpringFileSet fileset) {
        if (fileset == null) {
            SpringFacetConfigurationImpl.$$$reportNull$$$0(2);
        }
        assert (fileset.isAutodetected()) : fileset.getId();
        String id = fileset.getId();
        if (!this.myAutodetectedFileSetProfiles.containsKey(id)) {
            this.myAutodetectedFileSetProfiles.put(id, "");
        }
        fileset.setActiveProfiles(this.getActiveProfiles(id));
        this.incModificationCount();
    }

    @Override
    public synchronized void setActiveProfilesForAutodetected(@NotNull String filesetId, @NotNull Set<String> profiles) {
        if (filesetId == null) {
            SpringFacetConfigurationImpl.$$$reportNull$$$0(3);
        }
        if (profiles == null) {
            SpringFacetConfigurationImpl.$$$reportNull$$$0(4);
        }
        this.myAutodetectedFileSetProfiles.put(filesetId, StringUtil.join(profiles, (String)","));
    }

    @NotNull
    private synchronized Set<String> getActiveProfiles(@NotNull String filesetId) {
        String profiles;
        if (filesetId == null) {
            SpringFacetConfigurationImpl.$$$reportNull$$$0(5);
        }
        return StringUtil.isEmptyOrSpaces((String)(profiles = (String)this.myAutodetectedFileSetProfiles.get(filesetId))) ? new LinkedHashSet<String>() : new LinkedHashSet(StringUtil.split((String)profiles, (String)","));
    }

    void removeFileSetDescriptors() {
        this.myFileSets.clear();
    }

    @Override
    @NotNull
    public Set<CustomSetting> getCustomSettings() {
        Set set = (Set)this.myCustomSettings.getValue();
        if (set == null) {
            SpringFacetConfigurationImpl.$$$reportNull$$$0(6);
        }
        return set;
    }

    private void incSettingsModificationCount() {
        this.incModificationCount();
        this.mySettingsModificationTracker.incModificationCount();
    }

    @Override
    public ModificationTracker getSettingsModificationTracker() {
        return this.mySettingsModificationTracker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/facet/SpringFacetConfigurationImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = FILESET;
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesetId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = ACTIVE_PROFILES;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSetDescriptors";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/facet/SpringFacetConfigurationImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addSpringFileSetData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerAutodetectedFileSet";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setActiveProfilesForAutodetected";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getActiveProfiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

