/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.el.SpringELBundle;
import com.intellij.spring.el.SpringELFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringElStaticFieldInjectionInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Module module;
        if (holder == null) {
            SpringElStaticFieldInjectionInspection.$$$reportNull$$$0(0);
        }
        if (!SpringLibraryUtil.hasSpringLibrary(module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile()))) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SpringElStaticFieldInjectionInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            SpringElStaticFieldInjectionInspection.$$$reportNull$$$0(2);
        }
        return psiElementVisitor;
    }

    public ProblemDescriptor @Nullable [] checkField(@NotNull PsiField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiAnnotation psiAnnotation;
        PsiModifierList modifierList;
        if (field == null) {
            SpringElStaticFieldInjectionInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            SpringElStaticFieldInjectionInspection.$$$reportNull$$$0(4);
        }
        if ((modifierList = field.getModifierList()) != null && modifierList.hasModifierProperty("static") && (psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)field, (boolean)true, (String[])new String[]{"org.springframework.beans.factory.annotation.Value"})) != null && SpringElStaticFieldInjectionInspection.isSpElInjected(psiAnnotation)) {
            PsiJavaCodeReferenceElement nameReferenceElement = psiAnnotation.getNameReferenceElement();
            return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)(nameReferenceElement != null ? nameReferenceElement : psiAnnotation), SpringELBundle.message("SpringElStaticFieldInjectionInspection.cannot.inject.in.static.fields", new Object[0]), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, false)};
        }
        return super.checkField(field, manager, isOnTheFly);
    }

    private static boolean isSpElInjected(PsiAnnotation annotation) {
        Ref ref = Ref.create((Object)false);
        for (PsiNameValuePair pair : annotation.getParameterList().getAttributes()) {
            PsiAnnotationMemberValue value = pair.getValue();
            if (!(value instanceof PsiLiteralExpression)) continue;
            InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)annotation.getProject());
            manager.enumerate((PsiElement)value, (injectedPsi, places) -> {
                if (injectedPsi.getFileType() instanceof SpringELFileType) {
                    ref.set((Object)true);
                }
            });
        }
        return (Boolean)ref.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/el/inspections/SpringElStaticFieldInjectionInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/el/inspections/SpringElStaticFieldInjectionInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

