/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el.contextProviders;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.el.contextProviders.SpringElInjectionContext;
import com.intellij.spring.model.aliasFor.SpringAliasFor;
import com.intellij.spring.model.aliasFor.SpringAliasForUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SpringELAliasedAttributeInjectionContext
extends SpringElInjectionContext {
    @NonNls
    private static final String CONDITION_ATTR_NAME = "condition";
    @NonNls
    private static final String UNLESS_ATTR_NAME = "unless";
    @NonNls
    private static final String KEY_ATTR_NAME = "key";
    private final Map<String, Set<String>> ourAliasAnnotationToAttributesMap = Map.of("org.springframework.context.event.EventListener", Set.of("condition"), "org.springframework.cache.annotation.Cacheable", Set.of("condition", "unless", "key"), "org.springframework.cache.annotation.CachePut", Set.of("condition", "unless", "key"), "org.springframework.cache.annotation.CacheEvict", Set.of("condition", "unless"));

    public static boolean isCustomAnnotation(@NotNull Module module, @NotNull String annotationName, @NotNull String baseAnnoName) {
        if (module == null) {
            SpringELAliasedAttributeInjectionContext.$$$reportNull$$$0(0);
        }
        if (annotationName == null) {
            SpringELAliasedAttributeInjectionContext.$$$reportNull$$$0(1);
        }
        if (baseAnnoName == null) {
            SpringELAliasedAttributeInjectionContext.$$$reportNull$$$0(2);
        }
        if (annotationName.equals(baseAnnoName)) {
            return true;
        }
        PsiClass annoClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(annotationName, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        return annoClass != null && MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)annoClass, Collections.singleton(baseAnnoName));
    }

    @Override
    public boolean isSpringElCompatibleHost(@NotNull PsiLiteralExpression host) {
        PsiElement hostParent;
        if (host == null) {
            SpringELAliasedAttributeInjectionContext.$$$reportNull$$$0(3);
        }
        if (!((hostParent = host.getParent()) instanceof PsiNameValuePair)) {
            return false;
        }
        PsiElement parent = hostParent.getParent();
        if (!(parent instanceof PsiAnnotationParameterList) || parent.getProject().isDefault()) {
            return false;
        }
        PsiElement element = parent.getParent();
        if (!(element instanceof PsiAnnotation)) {
            return false;
        }
        PsiAnnotation psiAnnotation = (PsiAnnotation)element;
        String qualifiedName = psiAnnotation.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiAnnotation);
        if (!SpringLibraryUtil.hasSpringLibrary(module)) {
            return false;
        }
        String attributeName = ((PsiNameValuePair)hostParent).getName();
        if (StringUtil.isEmptyOrSpaces((String)attributeName)) {
            return false;
        }
        for (Map.Entry<String, Set<String>> entry : this.ourAliasAnnotationToAttributesMap.entrySet()) {
            String aliasedAnnoName = entry.getKey();
            if (!SpringELAliasedAttributeInjectionContext.isCustomAnnotation(module, qualifiedName, aliasedAnnoName)) continue;
            for (String aliasedAttrName : entry.getValue()) {
                SpringAliasFor aliasFor = SpringAliasForUtils.findAliasFor((PsiElement)psiAnnotation, qualifiedName, aliasedAnnoName, aliasedAttrName);
                if (aliasFor == null || !attributeName.equals(aliasFor.getMethodName())) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseAnnoName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/el/contextProviders/SpringELAliasedAttributeInjectionContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomAnnotation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSpringElCompatibleHost";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

