/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el;

import com.intellij.jsp.source.JspImplicitVariableImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.model.SpringBeanPointer;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class SpringElBeanVariable
extends JspImplicitVariableImpl {
    private final Icon myIcon;
    private final String myLocation;

    public SpringElBeanVariable(SpringBeanPointer springBeanPointer, PsiFile file, String beanName, PsiElement declaration) {
        super((PsiElement)file, beanName, SpringElBeanVariable.getBeanType(springBeanPointer), declaration, "NESTED");
        this.myIcon = SpringPresentationProvider.getSpringIcon(springBeanPointer);
        this.myLocation = SpringPresentationProvider.getSpringBeanLocation(springBeanPointer);
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return this.myIcon;
    }

    public String getLocationString() {
        return this.myLocation;
    }

    private static PsiType getBeanType(SpringBeanPointer springBeanPointer) {
        PsiType[] classes = springBeanPointer.getEffectiveBeanTypes();
        if (classes.length == 0) {
            PsiManager psiManager = springBeanPointer.getContainingFile().getManager();
            return PsiType.getJavaLangObject((PsiManager)psiManager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)psiManager.getProject()));
        }
        return classes[0];
    }
}

