/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.dom.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.spring.SpringApiBundle;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CharsetConverter
extends ResolvingConverter.StringConverter {
    private final NotNullLazyValue<Set<String>> charSets = NotNullLazyValue.atomicLazy(() -> ContainerUtil.map2Set((Object[])CharsetToolkit.getAvailableCharsets(), Charset::name));

    public String fromString(String s, ConvertContext convertContext) {
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        return ((Set)this.charSets.getValue()).contains(s) ? s : null;
    }

    @NotNull
    public LookupElement createLookupElement(String s) {
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)s).withCaseSensitivity(false);
        if (lookupElementBuilder == null) {
            CharsetConverter.$$$reportNull$$$0(0);
        }
        return lookupElementBuilder;
    }

    @NotNull
    public Collection<String> getVariants(ConvertContext convertContext) {
        Collection collection = (Collection)this.charSets.getValue();
        if (collection == null) {
            CharsetConverter.$$$reportNull$$$0(1);
        }
        return collection;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return SpringApiBundle.message("cannot.resolve.charset", s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/dom/converters/CharsetConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

