/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.diagram.contexts.beans;

import com.intellij.diagram.DiagramEdgeBase;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipInfoAdapter;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.diagram.contexts.beans.LocalModelGraphElementWrapper;
import java.awt.Shape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringLocalModelDependencyEdge
extends DiagramEdgeBase<LocalModelGraphElementWrapper<?>> {
    @NotNull
    private final LocalModelDependency myDependency;
    private boolean myError;

    public boolean isError() {
        return this.myError;
    }

    public void setError(boolean isError) {
        this.myError = isError;
    }

    public SpringLocalModelDependencyEdge(DiagramNode<LocalModelGraphElementWrapper<?>> source, DiagramNode<LocalModelGraphElementWrapper<?>> target, @NotNull LocalModelDependency dependency) {
        if (dependency == null) {
            SpringLocalModelDependencyEdge.$$$reportNull$$$0(0);
        }
        this(source, target, dependency, null);
    }

    public SpringLocalModelDependencyEdge(DiagramNode<LocalModelGraphElementWrapper<?>> source, DiagramNode<LocalModelGraphElementWrapper<?>> target, @NotNull LocalModelDependency dependency, @Nullable String label) {
        if (dependency == null) {
            SpringLocalModelDependencyEdge.$$$reportNull$$$0(1);
        }
        super(source, target, SpringLocalModelDependencyEdge.getInfo(dependency, label));
        this.myDependency = dependency;
    }

    @NotNull
    public LocalModelDependency getDependency() {
        LocalModelDependency localModelDependency = this.myDependency;
        if (localModelDependency == null) {
            SpringLocalModelDependencyEdge.$$$reportNull$$$0(2);
        }
        return localModelDependency;
    }

    private static DiagramRelationshipInfo getInfo(LocalModelDependency type, @Nullable String label) {
        String name = SpringLocalModelDependencyEdge.getRelationshipName(type.getType());
        return new DiagramRelationshipInfoAdapter(name, SpringLocalModelDependencyEdge.getLineType(type.getType()), label == null ? name : label){

            public Shape getStartArrow() {
                return STANDARD;
            }
        };
    }

    private static DiagramLineType getLineType(LocalModelDependencyType type) {
        switch (type) {
            case COMPONENT_SCAN: 
            case ENABLE_ANNO: {
                return DiagramLineType.SOLID;
            }
            case IMPORT: {
                return DiagramLineType.DASHED;
            }
        }
        return DiagramLineType.DOTTED;
    }

    private static String getRelationshipName(LocalModelDependencyType type) {
        return "";
    }

    public String getName() {
        return StringUtil.escapeXmlEntities((String)this.myDependency.getLabel());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpringLocalModelDependencyEdge)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpringLocalModelDependencyEdge that = (SpringLocalModelDependencyEdge)((Object)o);
        return this.myDependency == that.myDependency;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myDependency.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/diagram/contexts/beans/SpringLocalModelDependencyEdge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/diagram/contexts/beans/SpringLocalModelDependencyEdge";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

