/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.graph;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.util.CachedValue;
import com.intellij.spring.contexts.model.graph.LazyModelDependenciesGraph;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.Graph;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public abstract class LazyDependenciesGraph<N, E>
extends UserDataHolderBase
implements Graph<N> {
    private static final Key<CachedValue<Map<String, LazyModelDependenciesGraph>>> OUTS_KEY = Key.create((String)"OUTS_KEY");
    private final Map<N, Collection<Pair<N, E>>> myIns = new ConcurrentHashMap<N, Collection<Pair<N, E>>>();
    private final Map<N, Collection<Pair<N, E>>> myOuts = new ConcurrentHashMap<N, Collection<Pair<N, E>>>();
    private volatile boolean myIsBuilt = false;
    private final Function<Pair<N, E>, N> mySourceNodeFunction = pair -> pair.getFirst();

    @NotNull
    protected abstract Collection<Pair<N, E>> getDependencies(@NotNull N var1);

    @NotNull
    public Iterator<N> getIn(N n) {
        this.guaranteeGraphIsBuilt();
        Collection<Pair<N, E>> dependencies = this.myIns.get(n);
        Iterator<Object> iterator = dependencies != null ? this.getIterator(dependencies) : Collections.emptyIterator();
        if (iterator == null) {
            LazyDependenciesGraph.$$$reportNull$$$0(0);
        }
        return iterator;
    }

    @NotNull
    public Iterator<N> getOut(N n) {
        return this.getIterator(this.getOrCreateOutDependencies(n));
    }

    @NotNull
    private Iterator<N> getIterator(Collection<Pair<N, E>> dependencies) {
        Iterator iterator = ContainerUtil.map(dependencies, this.mySourceNodeFunction).iterator();
        if (iterator == null) {
            LazyDependenciesGraph.$$$reportNull$$$0(1);
        }
        return iterator;
    }

    protected final void guaranteeGraphIsBuilt() {
        if (!this.myIsBuilt) {
            Collection nodes = this.getNodes();
            for (Object node : nodes) {
                this.getOrCreateOutDependencies(node);
            }
            this.myIsBuilt = true;
        }
    }

    @NotNull
    public final Collection<Pair<N, E>> getOrCreateOutDependencies(@NotNull N n) {
        Collection<Pair<N, E>> outSet;
        if (n == null) {
            LazyDependenciesGraph.$$$reportNull$$$0(2);
        }
        if ((outSet = this.myOuts.get(n)) == null) {
            outSet = this.getDependencies(n);
            for (Pair<N, E> dependency : outSet) {
                this.addInDependency(n, dependency.first, dependency.second);
            }
            this.myOuts.put(n, outSet);
        }
        Collection<Pair<N, E>> collection = this.myOuts.get(n);
        if (collection == null) {
            LazyDependenciesGraph.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public void addInDependency(@NotNull N from, @NotNull N to, @NotNull E edgeDescriptor) {
        Collection<Pair<N, Pair>> inNodes;
        if (from == null) {
            LazyDependenciesGraph.$$$reportNull$$$0(4);
        }
        if (to == null) {
            LazyDependenciesGraph.$$$reportNull$$$0(5);
        }
        if (edgeDescriptor == null) {
            LazyDependenciesGraph.$$$reportNull$$$0(6);
        }
        if ((inNodes = this.myIns.get(to)) == null) {
            inNodes = new LinkedHashSet<Pair<N, E>>();
        }
        inNodes.add(Pair.create(from, edgeDescriptor));
        this.myIns.put(to, inNodes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/graph/LazyDependenciesGraph";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIn";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIterator";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/graph/LazyDependenciesGraph";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateOutDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateOutDependencies";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addInDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

