/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringSizeLimitedCache<K, V> {
    private final Map<K, V> myQueue;
    @NotNull
    private final Condition<? super K> myKeyValidityCheck;
    private final int myMaxQueueSize;
    private final Object myLock;

    protected SpringSizeLimitedCache(int maxQueueSize, @NotNull Condition<? super K> keyValidityCheck) {
        if (keyValidityCheck == null) {
            SpringSizeLimitedCache.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myQueue = new LinkedHashMap<K, V>(10, 0.6f, EqualityPolicy.CANONICAL, true){

            protected boolean removeEldestEntry(Map.Entry<K, V> eldest, K key, V value) {
                return this.size() > SpringSizeLimitedCache.this.myMaxQueueSize;
            }
        };
        this.myKeyValidityCheck = keyValidityCheck;
        this.myMaxQueueSize = maxQueueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected V getCachedValue(K key) {
        V value;
        Object object = this.myLock;
        synchronized (object) {
            value = this.myQueue.get(key);
        }
        return value;
    }

    @NotNull
    protected abstract V createValue(K var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public V get(K key) {
        V value = this.getCachedValue(key);
        if (value != null) {
            V v = value;
            if (v == null) {
                SpringSizeLimitedCache.$$$reportNull$$$0(1);
            }
            return v;
        }
        V newValue = this.createValue(key);
        Object object = this.myLock;
        synchronized (object) {
            if (this.myQueue.size() > this.myMaxQueueSize && !this.allKeysAreValid()) {
                this.myQueue.clear();
            }
            this.myQueue.put(key, newValue);
        }
        V v = newValue;
        if (v == null) {
            SpringSizeLimitedCache.$$$reportNull$$$0(2);
        }
        return v;
    }

    private boolean allKeysAreValid() {
        for (K k : this.myQueue.keySet()) {
            if (this.myKeyValidityCheck.value(k)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValidityCheck";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/SpringSizeLimitedCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/SpringSizeLimitedCache";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

