/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.chooser;

import com.intellij.facet.FacetFinder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.chooser.SpringContextDescriptor;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.impl.SpringManagerImpl;
import com.intellij.spring.impl.SpringModelsCreationContext;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.SmartList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastContextKt;

public class SpringMultipleContextsManager {
    private static final FileAttribute CURRENT_SPRING_CONTEXT = new FileAttribute("spring_context", 1, false);

    public static SpringMultipleContextsManager getInstance() {
        return (SpringMultipleContextsManager)ApplicationManager.getApplication().getService(SpringMultipleContextsManager.class);
    }

    @NotNull
    public SpringContextDescriptor getContextDescriptor(@NotNull PsiFile file) {
        SpringContextDescriptor cached;
        if (file == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(0);
        }
        if ((cached = this.getUserDefinedContextDescriptor(file)) != null) {
            SpringContextDescriptor springContextDescriptor = cached;
            if (springContextDescriptor == null) {
                SpringMultipleContextsManager.$$$reportNull$$$0(1);
            }
            return springContextDescriptor;
        }
        SpringContextDescriptor springContextDescriptor = (SpringContextDescriptor)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create((Object)this.calculateDescriptor(file), (Object[])SpringModificationTrackersManager.getInstance(file.getProject()).getOuterModelsDependencies()));
        if (springContextDescriptor == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(2);
        }
        return springContextDescriptor;
    }

    private static Object @NotNull [] geDependencies(@NotNull Project project) {
        if (project == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(3);
        }
        Object[] objectArray = new Object[]{ProjectRootManager.getInstance((Project)project), SpringModificationTrackersManager.getInstance(project).getOuterModelsModificationTracker(), FacetFinder.getInstance((Project)project).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID)};
        if (objectArray == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    @Nullable
    public SpringContextDescriptor getUserDefinedContextDescriptor(@NotNull PsiFile file) {
        if (file == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(5);
        }
        PsiFile originalFile = file.getOriginalFile();
        return (SpringContextDescriptor)originalFile.getUserData(SpringContextDescriptor.KEY);
    }

    @NotNull
    public List<SpringContextDescriptor> getAllContextDescriptors(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(6);
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)psiFile, () -> CachedValueProvider.Result.create(SpringMultipleContextsManager.getDescriptors(psiFile), (Object[])SpringMultipleContextsManager.geDependencies(psiFile.getProject())));
        if (list == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static List<SpringContextDescriptor> getDescriptors(@NotNull PsiFile psiFile) {
        Module module;
        if (psiFile == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(8);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile)) == null) {
            List<SpringContextDescriptor> list = Collections.emptyList();
            if (list == null) {
                SpringMultipleContextsManager.$$$reportNull$$$0(9);
            }
            return list;
        }
        SpringModelsCreationContext context = SpringModelsCreationContext.create(module).loadModelsFromDependentModules().loadModelsFromModuleDependencies();
        Set<SpringModel> modelsByModule = SpringManagerImpl.getAllModels(context);
        if (modelsByModule.isEmpty()) {
            List<SpringContextDescriptor> list = Collections.emptyList();
            if (list == null) {
                SpringMultipleContextsManager.$$$reportNull$$$0(10);
            }
            return list;
        }
        SmartList descriptors = new SmartList();
        PsiFile file = psiFile.getOriginalFile();
        for (SpringModel model : modelsByModule) {
            SpringFileSet fileSet;
            if (!SpringMultipleContextsManager.containsFile(file, model, fileSet = model.getFileSet())) continue;
            descriptors.add(SpringMultipleContextsManager.createDescriptor(model, fileSet));
        }
        if (!descriptors.isEmpty()) {
            descriptors.sort(Comparator.comparing(SpringContextDescriptor::getName));
        }
        SmartList smartList = descriptors;
        if (smartList == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    private static boolean containsFile(PsiFile file, SpringModel model, SpringFileSet fileSet) {
        if (fileSet == null) {
            return false;
        }
        return SpringMultipleContextsManager.containsFile(file.getVirtualFile(), model, new LinkedHashSet<SpringModel>()) || SpringMultipleContextsManager.isImplicitConfigFile(file, model);
    }

    private static boolean isImplicitConfigFile(PsiFile file, SpringModel model) {
        return SpringMultipleContextsManager.isConfigFileCandidate(file) && SpringModelVisitorUtils.hasConfigFile(model, file);
    }

    private static boolean isConfigFileCandidate(PsiFile file) {
        if (file instanceof XmlFile && SpringDomUtils.isSpringXml((XmlFile)file)) {
            return true;
        }
        UFile uFile = (UFile)UastContextKt.toUElement((PsiElement)file, UFile.class);
        if (uFile != null) {
            for (UClass aClass : uFile.getClasses()) {
                if (!SpringCommonUtils.isConfigurationOrMeta(aClass.getJavaPsi())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean containsFile(VirtualFile virtualFile, @NotNull SpringModel model, Set<SpringModel> visited) {
        SpringFileSet fileSet;
        if (model == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(12);
        }
        if ((fileSet = model.getFileSet()) != null && fileSet.hasFile(virtualFile)) {
            return true;
        }
        visited.add(model);
        for (SpringModel depModel : model.getDependencies()) {
            if (visited.contains(depModel) || !SpringMultipleContextsManager.containsFile(virtualFile, depModel, visited)) continue;
            return true;
        }
        return false;
    }

    private static SpringContextDescriptor createDescriptor(@NotNull SpringModel model, @NotNull SpringFileSet fileSet) {
        if (model == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(13);
        }
        if (fileSet == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(14);
        }
        return SpringMultipleContextsManager.createDescriptor(fileSet, model.getModule());
    }

    @NotNull
    public static SpringContextDescriptor createDescriptor(@NotNull SpringFileSet fileSet, Module module) {
        if (fileSet == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(15);
        }
        final String qualifiedName = fileSet.getQualifiedName();
        return new SpringContextDescriptor(module, fileSet.getId(), fileSet.getName()){

            @Override
            @NotNull
            public String getQualifiedName() {
                String string = qualifiedName;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager$1", "getQualifiedName"));
            }
        };
    }

    void persistDescriptor(@NotNull PsiFile file, @NotNull SpringContextDescriptor descriptor) {
        VirtualFile virtualFile;
        if (file == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(16);
        }
        if (descriptor == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(17);
        }
        if ((virtualFile = file.getOriginalFile().getVirtualFile()) == null || virtualFile.isDirectory()) {
            return;
        }
        file.putUserData(SpringContextDescriptor.KEY, (Object)descriptor);
        String id = descriptor.getQualifiedName();
        try (DataOutputStream outputStream = CURRENT_SPRING_CONTEXT.writeAttribute(virtualFile);){
            outputStream.writeUTF(StringUtil.notNullize((String)id));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String getPersistedDescriptor(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(18);
        }
        if ((virtualFile = file.getOriginalFile().getVirtualFile()) == null) return null;
        if (virtualFile.isDirectory()) return null;
        if (!(virtualFile instanceof VirtualFileWithId)) return null;
        try (DataInputStream inputStream = CURRENT_SPRING_CONTEXT.readAttribute(virtualFile);){
            if (inputStream == null) return null;
            String string = inputStream.readUTF();
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    private SpringContextDescriptor calculateDescriptor(@NotNull PsiFile file) {
        Module currentModule;
        if (file == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(19);
        }
        List<SpringContextDescriptor> descriptors = null;
        String qualifiedName = SpringMultipleContextsManager.getPersistedDescriptor(file);
        if (qualifiedName != null) {
            if (qualifiedName.equals(SpringContextDescriptor.LOCAL_CONTEXT.getQualifiedName())) {
                SpringContextDescriptor springContextDescriptor = SpringContextDescriptor.LOCAL_CONTEXT;
                if (springContextDescriptor == null) {
                    SpringMultipleContextsManager.$$$reportNull$$$0(20);
                }
                return springContextDescriptor;
            }
            if (qualifiedName.equals(SpringContextDescriptor.ALL_CONTEXTS.getQualifiedName())) {
                SpringContextDescriptor springContextDescriptor = SpringContextDescriptor.ALL_CONTEXTS;
                if (springContextDescriptor == null) {
                    SpringMultipleContextsManager.$$$reportNull$$$0(21);
                }
                return springContextDescriptor;
            }
            descriptors = this.getAllContextDescriptors(file);
            for (SpringContextDescriptor descriptor : descriptors) {
                if (!qualifiedName.equals(descriptor.getQualifiedName())) continue;
                SpringContextDescriptor springContextDescriptor = descriptor;
                if (springContextDescriptor == null) {
                    SpringMultipleContextsManager.$$$reportNull$$$0(22);
                }
                return springContextDescriptor;
            }
        }
        if ((currentModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) != null) {
            if (descriptors == null) {
                descriptors = this.getAllContextDescriptors(file);
            }
            for (SpringContextDescriptor descriptor : descriptors) {
                if (!currentModule.equals(descriptor.getModule())) continue;
                SpringContextDescriptor springContextDescriptor = descriptor;
                if (springContextDescriptor == null) {
                    SpringMultipleContextsManager.$$$reportNull$$$0(23);
                }
                return springContextDescriptor;
            }
        }
        SpringContextDescriptor springContextDescriptor = SpringContextDescriptor.LOCAL_CONTEXT;
        if (springContextDescriptor == null) {
            SpringMultipleContextsManager.$$$reportNull$$$0(24);
        }
        return springContextDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/chooser/SpringMultipleContextsManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "geDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllContextDescriptors";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptors";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "geDependencies";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUserDefinedContextDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllContextDescriptors";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptors";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "containsFile";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "persistDescriptor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPersistedDescriptor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "calculateDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

