/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.chooser;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.contexts.chooser.SpringContextDescriptor;
import com.intellij.spring.contexts.chooser.SpringMultipleContextsManager;
import com.intellij.spring.contexts.chooser.SpringMultipleContextsPanel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.ui.EditorNotifications;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringMultipleContextsEditorNotification
extends EditorNotifications.Provider<SpringMultipleContextsPanel> {
    private static final Key<SpringMultipleContextsPanel> KEY = Key.create((String)"SpringMultipleContextsManager");

    public SpringMultipleContextsEditorNotification(final @NotNull Project project) {
        if (project == null) {
            SpringMultipleContextsEditorNotification.$$$reportNull$$$0(0);
        }
        project.getMessageBus().connect().subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

            public void facetAdded(@NotNull Facet facet) {
                if (facet == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.facetChanged(facet);
            }

            public void facetRemoved(@NotNull Facet facet) {
                if (facet == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.facetChanged(facet);
            }

            public void facetConfigurationChanged(@NotNull Facet facet) {
                if (facet == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.facetChanged(facet);
            }

            private void facetChanged(Facet facet) {
                if (facet.getTypeId() == SpringFacet.FACET_TYPE_ID) {
                    EditorNotifications.getInstance((Project)project).updateAllNotifications();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "facet";
                objectArray2[1] = "com/intellij/spring/contexts/chooser/SpringMultipleContextsEditorNotification$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetConfigurationChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public Key<SpringMultipleContextsPanel> getKey() {
        Key<SpringMultipleContextsPanel> key = KEY;
        if (key == null) {
            SpringMultipleContextsEditorNotification.$$$reportNull$$$0(1);
        }
        return key;
    }

    public SpringMultipleContextsPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file == null) {
            SpringMultipleContextsEditorNotification.$$$reportNull$$$0(2);
        }
        if (fileEditor == null) {
            SpringMultipleContextsEditorNotification.$$$reportNull$$$0(3);
        }
        if (project == null) {
            SpringMultipleContextsEditorNotification.$$$reportNull$$$0(4);
        }
        if (!SpringGeneralSettings.getInstance(project).isShowMultipleContextsPanel()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        if (!SpringDomUtils.isSpringXml((XmlFile)psiFile)) {
            return null;
        }
        List<SpringContextDescriptor> descriptors = SpringMultipleContextsManager.getInstance().getAllContextDescriptors(psiFile);
        if (descriptors.size() > 1) {
            ArrayList<SpringContextDescriptor> allDescriptors = new ArrayList<SpringContextDescriptor>();
            allDescriptors.add(SpringContextDescriptor.LOCAL_CONTEXT);
            allDescriptors.add(SpringContextDescriptor.ALL_CONTEXTS);
            allDescriptors.addAll(descriptors);
            SpringContextDescriptor currentContext = SpringMultipleContextsEditorNotification.getUpdatedCurrentContext(psiFile, allDescriptors);
            return new SpringMultipleContextsPanel(psiFile, allDescriptors, currentContext);
        }
        return null;
    }

    @NotNull
    private static SpringContextDescriptor getUpdatedCurrentContext(PsiFile psiFile, List<SpringContextDescriptor> allDescriptors) {
        SpringContextDescriptor userDefinedDescriptor = SpringMultipleContextsManager.getInstance().getUserDefinedContextDescriptor(psiFile);
        if (userDefinedDescriptor == null) {
            SpringContextDescriptor springContextDescriptor = SpringMultipleContextsManager.getInstance().getContextDescriptor(psiFile);
            if (springContextDescriptor == null) {
                SpringMultipleContextsEditorNotification.$$$reportNull$$$0(5);
            }
            return springContextDescriptor;
        }
        for (SpringContextDescriptor existing : allDescriptors) {
            if (!userDefinedDescriptor.getQualifiedName().equals(existing.getQualifiedName())) continue;
            SpringContextDescriptor springContextDescriptor = existing;
            if (springContextDescriptor == null) {
                SpringMultipleContextsEditorNotification.$$$reportNull$$$0(6);
            }
            return springContextDescriptor;
        }
        SpringContextDescriptor springContextDescriptor = SpringContextDescriptor.DEFAULT;
        if (springContextDescriptor == null) {
            SpringMultipleContextsEditorNotification.$$$reportNull$$$0(7);
        }
        return springContextDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/chooser/SpringMultipleContextsEditorNotification";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/chooser/SpringMultipleContextsEditorNotification";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatedCurrentContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

