/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.code;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.gutter.SpringAutowiredAnnotator;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class SpringImplicitUsageProvider
implements ImplicitUsageProvider {
    private static final List<String> WRITE_ANNOTATIONS = List.of("org.springframework.beans.factory.annotation.Autowired", "org.springframework.beans.factory.annotation.Required", "org.springframework.context.annotation.Bean", "org.springframework.beans.factory.annotation.Value", "org.springframework.jmx.export.annotation.ManagedOperation", "org.springframework.jmx.export.annotation.ManagedAttribute", "org.springframework.scheduling.annotation.Scheduled", "org.springframework.scheduling.annotation.Schedules", "org.springframework.context.event.EventListener", "org.springframework.transaction.event.TransactionalEventListener", "org.springframework.test.context.transaction.BeforeTransaction", "org.springframework.test.context.transaction.AfterTransaction");
    private static final List<String> NON_SPRING_WRITE_ANNOTATIONS = List.of("javax.inject.Inject", "javax.annotation.Resource");
    private static final List<String> READ_ANNOTATIONS = List.of("org.springframework.beans.factory.annotation.Value");

    SpringImplicitUsageProvider() {
    }

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        return SpringImplicitUsageProvider.hasWriteAnnotation(element) || SpringImplicitUsageProvider.isBeanSetterOrLifeCycleMethod(element) || SpringImplicitUsageProvider.isBeanClassOrConstructor(element) || SpringImplicitUsageProvider.isDynamicPropertySource(element) || SpringImplicitUsageProvider.isJsonComponentClass(element);
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        return element instanceof PsiMethod && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiMethod)element), READ_ANNOTATIONS, (int)0);
    }

    private static boolean isMetaAnnotated(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiClass) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return false;
        }
        List<String> annotations = SpringImplicitUsageProvider.getMetaAnnotations(module, "org.springframework.scheduling.annotation.Scheduled", "org.springframework.context.event.EventListener", "org.springframework.beans.factory.annotation.Autowired", "org.springframework.context.annotation.Bean", "org.springframework.beans.factory.annotation.Value", "org.springframework.messaging.handler.annotation.MessageMapping");
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)element, annotations, (int)0);
    }

    @NotNull
    private static List<String> getMetaAnnotations(@NotNull Module module, String ... annotations) {
        if (module == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(3);
        }
        SmartList annotationTypes = new SmartList();
        for (String annotation : annotations) {
            annotationTypes.addAll(MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)annotation, (boolean)false));
        }
        List fqns = ContainerUtil.mapNotNull((Collection)annotationTypes, (Function)((NullableFunction)PsiClass::getQualifiedName));
        ContainerUtil.removeAll((Collection)fqns, (Object[])annotations);
        List list = fqns;
        if (list == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(4);
        }
        return list;
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(5);
        }
        return SpringImplicitUsageProvider.hasWriteAnnotation(element) || SpringImplicitUsageProvider.isBeanSetterOrLifeCycleMethod(element) || element instanceof PsiModifierListOwner && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), NON_SPRING_WRITE_ANNOTATIONS, (int)0);
    }

    private static boolean hasWriteAnnotation(PsiElement element) {
        if (!(element instanceof PsiModifierListOwner)) {
            return false;
        }
        if (element instanceof PsiParameter || element instanceof PsiLocalVariable) {
            return false;
        }
        PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)element;
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null || modifierList.getAnnotations().length == 0) {
            return false;
        }
        return !(!SpringCommonUtils.hasSpringFacets(element.getProject()) && !SpringLibraryUtil.hasSpringLibrary(element.getProject()) || !AnnotationUtil.isAnnotated((PsiModifierListOwner)modifierListOwner, WRITE_ANNOTATIONS, (int)0) && !SpringImplicitUsageProvider.isMetaAnnotated(modifierListOwner));
    }

    private static boolean isBeanSetterOrLifeCycleMethod(PsiElement element) {
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            int parametersCount = method.getParameterList().getParametersCount();
            if (parametersCount > 1) {
                return false;
            }
            PsiClass psiClass = method.getContainingClass();
            PsiIdentifier identifier = method.getNameIdentifier();
            if (SpringCommonUtils.isSpringBeanCandidateClassInSpringProject(psiClass) && identifier != null) {
                SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo(psiClass);
                if (info.isMappedProperty(method)) {
                    return true;
                }
                if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)((PsiMethod)element)) && info.isAutowired() && SpringAutowiredAnnotator.checkAutowiredMethod(method, null, info, (PsiElement)identifier)) {
                    return true;
                }
                if (parametersCount == 0 && !info.getMethodTypes(method).isEmpty()) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isBeanClassOrConstructor(PsiElement element) {
        if (element instanceof PsiClass) {
            return SpringImplicitUsageProvider.isMappedBeanClass((PsiClass)element);
        }
        if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
            PsiClass containingClass = ((PsiMethod)element).getContainingClass();
            return SpringImplicitUsageProvider.isMappedBeanClass(containingClass);
        }
        return false;
    }

    private static boolean isMappedBeanClass(PsiClass containingClass) {
        return SpringCommonUtils.isSpringBeanCandidateClassInSpringProject(containingClass) && SpringJavaClassInfo.getSpringJavaClassInfo(containingClass).isMapped();
    }

    private static boolean isDynamicPropertySource(@NotNull PsiElement element) {
        PsiMethod psiMethod;
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(6);
        }
        return element instanceof PsiMethod && (psiMethod = (PsiMethod)element).hasModifier(JvmModifier.STATIC) && !psiMethod.hasModifier(JvmModifier.ABSTRACT) && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"org.springframework.test.context.DynamicPropertySource", (int)0);
    }

    private static boolean isJsonComponentClass(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(7);
        }
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass psiClass = (PsiClass)element;
        if (psiClass.isAnnotationType() || psiClass.isInterface() || psiClass.isEnum()) {
            return false;
        }
        PsiClass containingClass = ((PsiClass)element).getContainingClass();
        if (containingClass == null) {
            return false;
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)containingClass, (String)"org.springframework.boot.jackson.JsonComponent", (int)0)) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"com.fasterxml.jackson.databind.JsonDeserializer") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"com.fasterxml.jackson.databind.JsonSerializer");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/code/SpringImplicitUsageProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/code/SpringImplicitUsageProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitRead";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isMetaAnnotated";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMetaAnnotations";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitWrite";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDynamicPropertySource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isJsonComponentClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

