/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop.psi;

import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.aop.psi.AopElementBase;
import com.intellij.aop.psi.AopPointcutExpressionFile;
import com.intellij.aop.psi.AopPointcutExpressionFileType;
import com.intellij.aop.psi.AopPointcutUtil;
import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.PointcutContext;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.aop.SpringAdvisedElementsSearcher;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiBeanPointcutExpression
extends AopElementBase
implements PsiPointcutExpression {
    public PsiBeanPointcutExpression(@NotNull ASTNode node) {
        if (node == null) {
            PsiBeanPointcutExpression.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public String toString() {
        return "PsiBeanPointcutExpression";
    }

    @NotNull
    public PointcutMatchDegree acceptsSubject(PointcutContext context, PsiMember member) {
        PointcutMatchDegree pointcutMatchDegree = this.acceptsClass(member instanceof PsiClass ? (PsiClass)member : member.getContainingClass());
        if (pointcutMatchDegree == null) {
            PsiBeanPointcutExpression.$$$reportNull$$$0(1);
        }
        return pointcutMatchDegree;
    }

    private PointcutMatchDegree acceptsClass(PsiClass psiClass) {
        PsiReference reference = this.getReference();
        if (reference == null) {
            return PointcutMatchDegree.FALSE;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            return PointcutMatchDegree.FALSE;
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            return PointcutMatchDegree.FALSE;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass(psiClass);
        Pattern pattern = Pattern.compile(reference.getCanonicalText().replaceAll(" ", "").replaceAll("\\*", "\\.\\*"));
        Processor namePatternProcessor = pointer -> {
            String name = pointer.getName();
            return !StringUtil.isNotEmpty((String)name) || !pattern.matcher(name).matches();
        };
        for (SpringModel model : SpringManager.getInstance(module.getProject()).getAllModels(module)) {
            if (model.processByClass(searchParameters, namePatternProcessor)) continue;
            return PointcutMatchDegree.TRUE;
        }
        return PointcutMatchDegree.FALSE;
    }

    public PsiReference getReference() {
        String s = this.getText();
        int start = s.indexOf(40);
        if (start < 0) {
            return null;
        }
        int end = s.indexOf(41);
        if (end < 0) {
            end = s.length();
        }
        return new PsiReferenceBase<PsiBeanPointcutExpression>(this, new TextRange(start + 1, end), true){

            public PsiElement resolve() {
                CommonSpringModel model = PsiBeanPointcutExpression.this.getModel();
                if (model == null) {
                    return null;
                }
                SpringBeanPointer<?> bean = SpringModelSearchers.findBean(model, this.getCanonicalText());
                return bean != null ? bean.getSpringBean().getIdentifyingPsiElement() : null;
            }

            public PsiElement handleElementRename(@NotNull String newText) throws IncorrectOperationException {
                if (newText == null) {
                    1.$$$reportNull$$$0(0);
                }
                AopPointcutExpressionFile file = (AopPointcutExpressionFile)PsiFileFactory.getInstance((Project)PsiBeanPointcutExpression.this.getProject()).createFileFromText("a", (FileType)AopPointcutExpressionFileType.INSTANCE, (CharSequence)("bean(" + newText + ")"));
                PsiBeanPointcutExpression pointcutExpression = (PsiBeanPointcutExpression)file.getPointcutExpression();
                assert (pointcutExpression != null);
                ASTNode parent = PsiBeanPointcutExpression.this.getNode().getTreeParent();
                parent.replaceChild(PsiBeanPointcutExpression.this.getNode(), pointcutExpression.getNode());
                ASTNode node = parent.findChildByType(PsiBeanPointcutExpression.this.getNode().getElementType());
                assert (node != null);
                return node.getPsi();
            }

            public Object @NotNull [] getVariants() {
                CommonSpringModel model = PsiBeanPointcutExpression.this.getModel();
                if (model == null) {
                    if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
                }
                ArrayList result = new ArrayList();
                ContainerUtil.process(model.getAllCommonBeans(), bean -> {
                    String name = bean.getName();
                    if (name != null && name.indexOf(35) < 0) {
                        ContainerUtil.addIfNotNull((Collection)result, (Object)SpringConverterUtil.createCompletionVariant(bean));
                    }
                    return true;
                });
                Object[] objectArray = result.toArray();
                if (objectArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return objectArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newText";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/aop/psi/PsiBeanPointcutExpression$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/aop/psi/PsiBeanPointcutExpression$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariants";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "handleElementRename";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Nullable
    private CommonSpringModel getModel() {
        AopAdvisedElementsSearcher searcher = AopPointcutUtil.getHolder((PsiElement)this).getAopModel().getAdvisedElementsSearcher();
        if (!(searcher instanceof SpringAdvisedElementsSearcher)) {
            return null;
        }
        return ((SpringAdvisedElementsSearcher)searcher).getSpringModel();
    }

    @NotNull
    public Collection<AopPsiTypePattern> getPatterns() {
        List<AopPsiTypePattern> list = Collections.emptyList();
        if (list == null) {
            PsiBeanPointcutExpression.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/aop/psi/PsiBeanPointcutExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/aop/psi/PsiBeanPointcutExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "acceptsSubject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

