/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop.model.converters;

import com.intellij.aop.AopAdviceType;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodQuickFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.spring.aop.model.xml.BasicAdvice;
import com.intellij.spring.aop.model.xml.SpringAspect;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.PsiMethodConverter;
import com.intellij.spring.model.converters.SpringBeanMethodConverter;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAdviceMethodConverter
extends SpringBeanMethodConverter {
    private static final PsiMethodConverter.MethodAccepter ALL_METHODS_ACCEPTER = new PsiMethodConverter.MethodAccepter(){

        @Override
        public boolean accept(PsiMethod method) {
            return true;
        }
    };

    @Override
    protected PsiMethodConverter.MethodAccepter getMethodAccepter(ConvertContext context, boolean forCompletion) {
        return ALL_METHODS_ACCEPTER;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        if (this.getPsiClass(context) == null) {
            return null;
        }
        return super.getErrorMessage(s, context);
    }

    @Override
    public PsiReference @NotNull [] createReferences(GenericDomValue<PsiMethod> genericDomValue, PsiElement element, ConvertContext context) {
        if (this.getPsiClass(context) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringAdviceMethodConverter.$$$reportNull$$$0(0);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = super.createReferences(genericDomValue, element, context);
        if (psiReferenceArray == null) {
            SpringAdviceMethodConverter.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    @Override
    @Nullable
    protected PsiClass getPsiClass(ConvertContext context) {
        SpringBeanPointer pointer;
        SpringAspect aspect = (SpringAspect)context.getInvocationElement().getParentOfType(SpringAspect.class, false);
        if (aspect != null && (pointer = (SpringBeanPointer)aspect.getRef().getValue()) != null) {
            return pointer.getBeanClass();
        }
        return null;
    }

    @Override
    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        GenericDomValue element = (GenericDomValue)context.getInvocationElement();
        String elementName = element.getStringValue();
        DomElement parent = element.getParent();
        PsiClass psiClass = this.getPsiClass(context);
        if (psiClass != null && elementName != null && parent instanceof BasicAdvice) {
            LocalQuickFix[] localQuickFixArray;
            String body;
            boolean isAround = ((BasicAdvice)parent).getAdviceType() == AopAdviceType.AROUND;
            @NonNls String signature = isAround ? "public Object " + elementName + "(org.aspectj.lang.ProceedingJoinPoint pjp)" : "public void " + elementName + "(org.aspectj.lang.JoinPoint jp)";
            CreateMethodQuickFix fix2 = CreateMethodQuickFix.createFix((PsiClass)psiClass, (String)(signature = signature + " throws java.lang.Throwable"), (String)(body = isAround ? "return pjp.proceed();" : ""));
            if (fix2 == null) {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            } else {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = fix2;
            }
            return localQuickFixArray;
        }
        return super.getQuickFixes(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/aop/model/converters/SpringAdviceMethodConverter", "createReferences"));
    }
}

