/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop.highlighting;

import com.intellij.aop.jam.AopJavaAnnotator;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiClass;
import com.intellij.spring.aop.SpringAopBundle;
import com.intellij.spring.aop.model.xml.SpringAspect;
import com.intellij.spring.aop.model.xml.SpringPointcut;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.XmlDomBundle;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DefineAttributeQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;

public final class SpringAopWarningsInspection
extends BasicDomElementsInspection<Beans> {
    public SpringAopWarningsInspection() {
        super(Beans.class, new Class[0]);
    }

    public void checkFileElement(DomFileElement<Beans> domFileElement, DomElementAnnotationHolder holder) {
        if (!SpringDomUtils.hasNamespace(domFileElement, "Spring AOP namespace key")) {
            return;
        }
        super.checkFileElement(domFileElement, holder);
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        if (element instanceof SpringPointcut) {
            GenericAttributeValue<String> id = ((SpringPointcut)element).getId();
            if (!DomUtil.hasXml(id)) {
                holder.createProblem(element, HighlightSeverity.WARNING, SpringAopBundle.message("warning.pointcut.should.have.id", new Object[0]), new LocalQuickFix[]{new DefineAttributeQuickFix("id")});
            }
        } else if (element instanceof SpringAspect) {
            PsiClass beanClass;
            GenericAttributeValue<SpringBeanPointer<?>> ref = ((SpringAspect)element).getRef();
            if (!DomUtil.hasXml(ref)) {
                holder.createProblem(element, HighlightSeverity.WARNING, XmlDomBundle.message((String)"dom.inspections.attribute.0.should.be.defined", (Object[])new Object[]{"ref"}), new LocalQuickFix[]{new DefineAttributeQuickFix("ref")});
                return;
            }
            SpringBeanPointer pointer = (SpringBeanPointer)ref.getValue();
            if (!(pointer == null || (beanClass = pointer.getBeanClass()) == null || AopJavaAnnotator.getBoundAdvices((PsiClass)beanClass).isEmpty() && AopJavaAnnotator.getBoundIntroductions((PsiClass)beanClass).isEmpty())) {
                holder.createProblem(ref, HighlightSeverity.WARNING, SpringAopBundle.message("aop.advice.matching.aspect.bean", new Object[0]));
            }
        }
    }
}

