/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.spring.aop.SpringAopBundle;
import com.intellij.spring.aop.model.xml.Advisor;
import com.intellij.spring.aop.model.xml.BasicAdvice;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DefineAttributeQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;

public final class SpringAopErrorsInspection
extends BasicDomElementsInspection<Beans> {
    public SpringAopErrorsInspection() {
        super(Beans.class, new Class[0]);
    }

    public void checkFileElement(DomFileElement<Beans> domFileElement, DomElementAnnotationHolder holder) {
        if (!SpringDomUtils.hasNamespace(domFileElement, "Spring AOP namespace key")) {
            return;
        }
        super.checkFileElement(domFileElement, holder);
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        Advisor advisor;
        if (element instanceof BasicAdvice) {
            BasicAdvice advice = (BasicAdvice)element;
            if (!DomUtil.hasXml(advice.getPointcut()) && !DomUtil.hasXml(advice.getPointcutRef())) {
                SpringAopErrorsInspection.createPointcutProblem(element, holder);
            }
        } else if (element instanceof Advisor && !DomUtil.hasXml((advisor = (Advisor)element).getPointcut()) && !DomUtil.hasXml(advisor.getPointcutRef())) {
            SpringAopErrorsInspection.createPointcutProblem(element, holder);
        }
    }

    private static void createPointcutProblem(DomElement element, DomElementAnnotationHolder holder) {
        holder.createProblem(element, HighlightSeverity.ERROR, SpringAopBundle.message("error.pointcut.or.pointcut.ref.should.be.defined", new Object[0]), new LocalQuickFix[]{new DefineAttributeQuickFix("pointcut"), new DefineAttributeQuickFix("pointcut-ref")});
    }
}

