/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop.highlighting;

import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.aop.AopProvider;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.aop.SpringAdvisedElementsSearcher;
import com.intellij.spring.aop.SpringAopBundle;
import com.intellij.spring.aop.SpringAopProvider;
import com.intellij.spring.aop.highlighting.EnableAspectJQuickFix;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class MissingAspectjAutoproxyInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            MissingAspectjAutoproxyInspection.$$$reportNull$$$0(0);
        }
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                MissingAspectjAutoproxyInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile());
        if (!JavaLibraryUtils.hasLibraryClass((Module)module, (String)"org.aspectj.lang.annotation.Aspect")) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                MissingAspectjAutoproxyInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        if (SpringLibraryUtil.isAtLeastVersion(module, SpringLibraryUtil.SpringVersion.V_2_5)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                MissingAspectjAutoproxyInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            MissingAspectjAutoproxyInspection.$$$reportNull$$$0(4);
        }
        return psiElementVisitor;
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            MissingAspectjAutoproxyInspection.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            MissingAspectjAutoproxyInspection.$$$reportNull$$$0(6);
        }
        if (JamCommonUtil.isPlainJavaFile((PsiElement)file)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            for (PsiClass aClass : ((PsiJavaFile)file).getClasses()) {
                LocalQuickFix[] localQuickFixArray;
                SpringAopProvider provider;
                AopAdvisedElementsSearcher searcher;
                PsiJavaCodeReferenceElement annoName;
                PsiModifierList modifierList = aClass.getModifierList();
                if (modifierList == null) continue;
                PsiAnnotation annotation = modifierList.findAnnotation("org.aspectj.lang.annotation.Aspect");
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = annoName = annotation == null ? null : annotation.getNameReferenceElement();
                if (annoName == null || !((searcher = (provider = (SpringAopProvider)((Object)AopProvider.EXTENSION_POINT_NAME.findExtensionOrFail(SpringAopProvider.class))).getAdvisedElementsSearcher(aClass)) instanceof SpringAdvisedElementsSearcher)) continue;
                CommonSpringModel model = ((SpringAdvisedElementsSearcher)searcher).getSpringModel();
                PsiClass aspectJAutoProxy = SpringCommonUtils.findLibraryClass(module, "org.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator");
                if (aspectJAutoProxy != null && MissingAspectjAutoproxyInspection.isAspectJSupportEnabled(model, aspectJAutoProxy)) continue;
                Set<LocalXmlModel> models = SpringModelVisitorUtils.getLocalXmlModels(model);
                if (models.isEmpty()) {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                } else {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = new EnableAspectJQuickFix((CommonSpringModel)models.iterator().next());
                }
                LocalQuickFix[] fixes = localQuickFixArray;
                return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)annoName, SpringAopBundle.message("aop.warning.aspectj.isnt.enabled", new Object[0]), isOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
            }
        }
        return super.checkFile(file, manager, isOnTheFly);
    }

    public static boolean isAspectJSupportEnabled(CommonSpringModel model, @NotNull PsiClass aspectJBeanClass) {
        if (aspectJBeanClass == null) {
            MissingAspectjAutoproxyInspection.$$$reportNull$$$0(7);
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass(aspectJBeanClass);
        for (LocalXmlModel xmlModel : SpringModelVisitorUtils.getLocalXmlModels(model)) {
            if (!SpringModelSearchers.doesBeanExist((CommonSpringModel)xmlModel, searchParameters)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/aop/highlighting/MissingAspectjAutoproxyInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aspectJBeanClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/aop/highlighting/MissingAspectjAutoproxyInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAspectJSupportEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

