/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop.highlighting;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.aop.SpringAopBundle;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomFileElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnableAspectJQuickFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(EnableAspectJQuickFix.class);
    private final CommonSpringModel myModel;

    public EnableAspectJQuickFix(CommonSpringModel beans) {
        this.myModel = beans;
    }

    @NotNull
    public String getFamilyName() {
        String string = SpringAopBundle.message("aop.enable.aspectj.fix.text", new Object[0]);
        if (string == null) {
            EnableAspectJQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            EnableAspectJQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            EnableAspectJQuickFix.$$$reportNull$$$0(2);
        }
        for (LocalXmlModel model : SpringModelVisitorUtils.getLocalXmlModels(this.myModel)) {
            DomFileElement<Beans> fileElement = model.getRoot();
            if (fileElement == null) continue;
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)fileElement.getFile())) {
                return;
            }
            XmlTag root = ((Beans)fileElement.getRootElement()).ensureTagExists();
            try {
                if (EnableAspectJQuickFix.isSchemaStyle(root)) {
                    WriteCommandAction.runWriteCommandAction((Project)project, () -> EnableAspectJQuickFix.addAspectjAutoproxy(root));
                    continue;
                }
                WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                    XmlTag childTag = root.createChildTag("bean", root.getNamespace(), null, false);
                    childTag.setAttribute("class", "org.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator");
                    root.add((PsiElement)childTag);
                });
                return;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public static boolean isSchemaStyle(@Nullable XmlTag root) {
        return root != null && root.getNamespace().contains("http://www.springframework.org/schema/");
    }

    public static void addAspectjAutoproxy(XmlTag root) {
        try {
            if (root.getPrefixByNamespace("http://www.springframework.org/schema/aop") == null && root.getNamespaceByPrefix("aop") == "") {
                root.setAttribute("xmlns:aop", "http://www.springframework.org/schema/aop");
            }
            root.add((PsiElement)root.createChildTag("aspectj-autoproxy", "http://www.springframework.org/schema/aop", null, false));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/aop/highlighting/EnableAspectJQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/aop/highlighting/EnableAspectJQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

