/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop;

import com.intellij.aop.AopAdvice;
import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.aop.AopAspect;
import com.intellij.aop.AopProvider;
import com.intellij.aop.ArgNamesManipulator;
import com.intellij.aop.psi.AllAdvisedElementsSearcher;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.aop.SpringAdvisedElementsSearcher;
import com.intellij.spring.aop.SpringArgNamesManipulator;
import com.intellij.spring.aop.model.xml.AopConfig;
import com.intellij.spring.aop.model.xml.BasicAdvice;
import com.intellij.spring.aop.model.xml.SpringAopAdvice;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAopProvider
extends AopProvider {
    @NotNull
    public Set<? extends AopAspect> getAdditionalAspects(@NotNull Module module) {
        if (module == null) {
            SpringAopProvider.$$$reportNull$$$0(0);
        }
        if (!SpringCommonUtils.hasSpringFacet(module) && !SpringModelUtils.getInstance().hasAutoConfiguredModels(module)) {
            Set set = Collections.emptySet();
            if (set == null) {
                SpringAopProvider.$$$reportNull$$$0(1);
            }
            return set;
        }
        Set set = (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            HashSet<AopAspect> set = new HashSet<AopAspect>();
            HashSet<XmlFile> configFiles = new HashSet<XmlFile>();
            Set<SpringModel> models = SpringManager.getInstance(module.getProject()).getAllModelsWithoutDependencies(module);
            for (SpringModel model : models) {
                for (LocalXmlModel localXmlModel : SpringModelVisitorUtils.getLocalXmlModels(model)) {
                    DomFileElement<Beans> element = localXmlModel.getRoot();
                    if (element == null) continue;
                    configFiles.add(element.getFile());
                    if (!SpringDomUtils.hasNamespace(element, "Spring AOP namespace key")) continue;
                    SpringAopProvider.addAopAspects(set, element.getRootElement());
                }
            }
            Object[] dependencies = SpringManager.getInstance(module.getProject()).getModelsDependencies(module, configFiles.toArray());
            return new CachedValueProvider.Result(set, dependencies);
        });
        if (set == null) {
            SpringAopProvider.$$$reportNull$$$0(2);
        }
        return set;
    }

    protected static Set<AopAspect> addAopAspects(Set<AopAspect> set, DomElement element) {
        for (DomElement child : DomUtil.getDefinedChildren((DomElement)element, (boolean)true, (boolean)false)) {
            if (child instanceof AopAspect) {
                AopAspect aspect = (AopAspect)child;
                set.add(aspect);
                continue;
            }
            if (!(child instanceof AopConfig)) continue;
            AopConfig config = (AopConfig)child;
            set.addAll(config.getAdvisors());
            set.addAll(config.getAspects());
        }
        return set;
    }

    public AopAdvisedElementsSearcher getAdvisedElementsSearcher(@NotNull PsiClass aClass) {
        PsiFile file;
        if (aClass == null) {
            SpringAopProvider.$$$reportNull$$$0(3);
        }
        if ((file = aClass.getContainingFile()) == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return AopAdvisedElementsSearcher.EMPTY;
        }
        return (AopAdvisedElementsSearcher)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create((Object)SpringAopProvider.getModuleElementsSearcher(module), (Object[])SpringManager.getInstance(module.getProject()).getModelsDependencies(module, PsiModificationTracker.MODIFICATION_COUNT)));
    }

    @NotNull
    private static AopAdvisedElementsSearcher getModuleElementsSearcher(@NotNull Module module) {
        if (module == null) {
            SpringAopProvider.$$$reportNull$$$0(4);
        }
        return SpringAopProvider.hasNoSpringFacetAtAll(module) ? new AllAdvisedElementsSearcher(module) : new SpringAdvisedElementsSearcher(module, (NotNullFactory<? extends CommonSpringModel>)((NotNullFactory)() -> SpringManager.getInstance(module.getProject()).getCombinedModel(module)));
    }

    private static boolean hasNoSpringFacetAtAll(Module module) {
        return !SpringCommonUtils.hasSpringFacets(module.getProject()) || ModuleUtilCore.visitMeAndDependentModules((Module)module, checkModule -> !SpringCommonUtils.hasSpringFacet(checkModule));
    }

    @Nullable
    public Pair<? extends ArgNamesManipulator, PsiMethod> getCustomArgNamesManipulator(@NotNull PsiElement element) {
        DomElement domElement;
        XmlTag tag;
        if (element == null) {
            SpringAopProvider.$$$reportNull$$$0(5);
        }
        if (element instanceof XmlAttributeValue && element.getParent() instanceof XmlAttribute && "pointcut-ref".equals(((XmlAttribute)element.getParent()).getLocalName()) && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class)) != null && (domElement = DomManager.getDomManager((Project)element.getProject()).getDomElement(tag)) instanceof BasicAdvice) {
            BasicAdvice advice = (BasicAdvice)domElement;
            PsiMethod method = (PsiMethod)advice.getMethod().getValue();
            if (advice.getPointcut().getStringValue() == null && method != null) {
                return Pair.create((Object)((Object)new SpringArgNamesManipulator(tag)), (Object)method);
            }
        }
        return super.getCustomArgNamesManipulator(element);
    }

    public Integer getAdviceOrder(AopAdvice advice) {
        if (advice instanceof SpringAopAdvice) {
            return (Integer)((SpringAopAdvice)advice).getOrder().getValue();
        }
        PsiElement element = advice.getIdentifyingPsiElement();
        if (element instanceof PsiAnnotation) {
            PsiClass aClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)element, PsiClass.class, (boolean)false);
            if (aClass == null) {
                return null;
            }
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (boolean)true, (String[])new String[]{"org.springframework.core.annotation.Order"});
            if (annotation != null) {
                Object o;
                PsiAnnotationMemberValue value = annotation.findDeclaredAttributeValue("value");
                if (value instanceof PsiExpression && (o = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)((PsiExpression)value), (boolean)false)) instanceof Integer) {
                    return (Integer)o;
                }
                return null;
            }
            PsiClass orderedClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("org.springframework.core.Ordered", aClass.getResolveScope());
            if (orderedClass != null && aClass.isInheritor(orderedClass, true)) {
                PsiMethod[] methods;
                for (PsiMethod method : methods = aClass.findMethodsByName("getOrder", true)) {
                    PsiExpression value;
                    Object o;
                    PsiStatement first;
                    PsiCodeBlock body = method.getBody();
                    if (method.getParameterList().getParametersCount() != 0 || body == null || body.getStatements().length != 1 || !((first = body.getStatements()[0]) instanceof PsiReturnStatement) || !((o = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)(value = ((PsiReturnStatement)first).getReturnValue()), (boolean)false)) instanceof Integer)) continue;
                    return (Integer)o;
                }
            }
        }
        return super.getAdviceOrder(advice);
    }

    @NotNull
    public static SpringAdvisedElementsSearcher getLocalModelSearcher(@NotNull PsiFile file) {
        if (file == null) {
            SpringAopProvider.$$$reportNull$$$0(6);
        }
        SpringAdvisedElementsSearcher springAdvisedElementsSearcher = (SpringAdvisedElementsSearcher)((Object)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            SpringAdvisedElementsSearcher searcher = new SpringAdvisedElementsSearcher(ModuleUtilCore.findModuleForFile((PsiFile)file), (NotNullFactory<? extends CommonSpringModel>)((NotNullFactory)() -> file instanceof XmlFile ? SpringModelUtils.getInstance().getSpringModel((PsiElement)file) : SpringModel.UNKNOWN));
            return CachedValueProvider.Result.create((Object)((Object)searcher), (Object[])new Object[]{file});
        }));
        if (springAdvisedElementsSearcher == null) {
            SpringAopProvider.$$$reportNull$$$0(7);
        }
        return springAdvisedElementsSearcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/aop/SpringAopProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/aop/SpringAopProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalAspects";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalModelSearcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalAspects";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAdvisedElementsSearcher";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModuleElementsSearcher";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCustomArgNamesManipulator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLocalModelSearcher";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

